/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.kiulian.downloader.jackson.JSONArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;

public class JSONObject {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ObjectNode node;

    public JSONObject() {
        this.node = MAPPER.createObjectNode();
    }

    public JSONObject(String string) throws Exception {
        this.node = (ObjectNode)MAPPER.readTree(string);
    }

    public JSONObject(ObjectNode objectNode) {
        this.node = objectNode;
    }

    public static JSONObject parseObject(String string) throws Exception {
        return new JSONObject(string);
    }

    public void put(String string, Object object) {
        if (object instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)object;
            this.node.set(string, (JsonNode)objectNode);
        } else if (object instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            this.node.set(string, (JsonNode)jSONObject.node);
        } else if (object instanceof Short) {
            Short s = (Short)object;
            this.node.put(string, s);
        } else if (object instanceof Integer) {
            Integer n = (Integer)object;
            this.node.put(string, n);
        } else if (object instanceof Long) {
            Long l = (Long)object;
            this.node.put(string, l);
        } else if (object instanceof Float) {
            Float f = (Float)object;
            this.node.put(string, f);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            this.node.put(string, d);
        } else if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            this.node.put(string, bigDecimal);
        } else if (object instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)object;
            this.node.put(string, bigInteger);
        } else if (object instanceof String) {
            String string2 = (String)object;
            this.node.put(string, string2);
        } else if (object instanceof Boolean) {
            Boolean bl = (Boolean)object;
            this.node.put(string, bl);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.node.put(string, byArray);
        } else {
            this.node.putPOJO(string, object);
        }
    }

    public String getString(String string) {
        JsonNode jsonNode = this.node.get(string);
        return jsonNode != null ? jsonNode.asText() : "";
    }

    public int getIntValue(String string) {
        JsonNode jsonNode = this.node.get(string);
        return jsonNode != null ? jsonNode.asInt() : 0;
    }

    public long getLongValue(String string) {
        JsonNode jsonNode = this.node.get(string);
        return jsonNode != null ? jsonNode.asLong() : 0L;
    }

    public Boolean getBooleanValue(String string) {
        JsonNode jsonNode = this.node.get(string);
        return jsonNode != null ? jsonNode.asBoolean() : Boolean.FALSE.booleanValue();
    }

    public JSONObject getJSONObject(String string) {
        JsonNode jsonNode = this.node.get(string);
        if (jsonNode != null && jsonNode.isObject()) {
            return new JSONObject((ObjectNode)jsonNode);
        }
        return null;
    }

    public JSONArray getJSONArray(String string) {
        JsonNode jsonNode = this.node.get(string);
        if (jsonNode != null && jsonNode.isArray()) {
            return new JSONArray((ArrayNode)jsonNode);
        }
        return null;
    }

    public boolean containsKey(String string) {
        return this.node.has(string);
    }

    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        this.node.fieldNames().forEachRemaining(hashSet::add);
        return hashSet;
    }

    public String toJSONString() {
        return this.node.toString();
    }

    public boolean isEmpty() {
        return this.node.isEmpty();
    }

    public JSONObject fluentPut(String string, Object object) {
        this.put(string, object);
        return this;
    }
}

