/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;

public enum TvShowEpisodeScraperMetadataConfig implements ScraperMetadataConfig
{
    TITLE(ScraperMetadataConfig.Type.METADATA),
    ORIGINAL_TITLE(ScraperMetadataConfig.Type.METADATA, "metatag.originaltitle"),
    ENGLISH_TITLE(ScraperMetadataConfig.Type.METADATA, "metatag.title.english"),
    PLOT(ScraperMetadataConfig.Type.METADATA),
    SEASON_EPISODE(ScraperMetadataConfig.Type.METADATA, "tvshow.seasonepisode"),
    AIRED(ScraperMetadataConfig.Type.METADATA, "metatag.aired"),
    RATING(ScraperMetadataConfig.Type.METADATA),
    TAGS(ScraperMetadataConfig.Type.METADATA),
    RUNTIME(ScraperMetadataConfig.Type.METADATA),
    ACTORS(ScraperMetadataConfig.Type.CAST),
    CREW(ScraperMetadataConfig.Type.CAST),
    THUMB(ScraperMetadataConfig.Type.ARTWORK);

    private final ScraperMetadataConfig.Type type;
    private final String description;
    private final String tooltip;

    private TvShowEpisodeScraperMetadataConfig(ScraperMetadataConfig.Type type) {
        this(type, null, null);
    }

    private TvShowEpisodeScraperMetadataConfig(ScraperMetadataConfig.Type type, String description) {
        this(type, description, null);
    }

    private TvShowEpisodeScraperMetadataConfig(ScraperMetadataConfig.Type type, String description, String tooltip) {
        this.type = type;
        this.description = description;
        this.tooltip = tooltip;
    }

    @Override
    public ScraperMetadataConfig.Type getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        if (StringUtils.isBlank((CharSequence)this.description)) {
            try {
                if (this.type == ScraperMetadataConfig.Type.ARTWORK) {
                    return TmmResourceBundle.getString("mediafiletype." + this.name().toLowerCase(Locale.ROOT));
                }
                return TmmResourceBundle.getString("metatag." + this.name().toLowerCase(Locale.ROOT));
            }
            catch (Exception exception) {}
        } else {
            try {
                return TmmResourceBundle.getString(this.description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getToolTip() {
        if (StringUtils.isBlank((CharSequence)this.tooltip)) {
            return null;
        }
        try {
            return TmmResourceBundle.getString(this.tooltip);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<TvShowEpisodeScraperMetadataConfig> valuesForType(ScraperMetadataConfig.Type type) {
        ArrayList<TvShowEpisodeScraperMetadataConfig> values = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        for (TvShowEpisodeScraperMetadataConfig config : TvShowEpisodeScraperMetadataConfig.values()) {
            if (config.type != type) continue;
            values.add(config);
        }
        return values;
    }

    public static List<TvShowEpisodeScraperMetadataConfig> getValues() {
        ArrayList<TvShowEpisodeScraperMetadataConfig> values = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        for (TvShowEpisodeScraperMetadataConfig value : TvShowEpisodeScraperMetadataConfig.values()) {
            if (value.type == ScraperMetadataConfig.Type.DEPRECATED) continue;
            values.add(value);
        }
        return values;
    }

    public static List<TvShowEpisodeScraperMetadataConfig> getValuesWithout(TvShowEpisodeScraperMetadataConfig ... valuesToExclude) {
        ArrayList<TvShowEpisodeScraperMetadataConfig> values = new ArrayList<TvShowEpisodeScraperMetadataConfig>();
        List<TvShowEpisodeScraperMetadataConfig> exclude = Arrays.asList(valuesToExclude);
        for (TvShowEpisodeScraperMetadataConfig value : TvShowEpisodeScraperMetadataConfig.values()) {
            if (value.type == ScraperMetadataConfig.Type.DEPRECATED || exclude.contains(value)) continue;
            values.add(value);
        }
        return values;
    }

    @JsonCreator
    public static TvShowEpisodeScraperMetadataConfig forValue(String value) {
        return switch (value) {
            case "PRODUCERS", "DIRECTORS", "WRITERS" -> CREW;
            default -> TvShowEpisodeScraperMetadataConfig.valueOf(value.toUpperCase());
        };
    }
}

