/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.port;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.data.Device;
import com.ubnt.data.X;
import com.ubnt.net.Dto;
import jakarta.validation.constraints.NotNull;
import java.beans.ConstructorProperties;
import java.util.List;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class DeviceMacTablesDto
implements Dto {
    @JsonProperty(value="mac")
    @NotNull
    String mac;
    @JsonProperty(value="ports")
    List<PortMacTableDto> portMacTables;

    public static DeviceMacTablesDto of(Device device, List<Integer> list) {
        List<PortMacTableDto> list2 = DeviceMacTablesDto.extractMacTablesByPortIndex(device.getList("port_stats"), list);
        return DeviceMacTablesDto.builder().mac(device.getMAC()).portMacTables(list2).build();
    }

    private static List<PortMacTableDto> extractMacTablesByPortIndex(List<X> list, List<Integer> list2) {
        return list.stream().filter(x2 -> list2.contains(x2.getInt("port_idx"))).map(PortMacTableDto::of).toList();
    }

    @ConstructorProperties(value={"mac", "portMacTables"})
    @Generated
    DeviceMacTablesDto(@JsonProperty(value="mac") String string, @JsonProperty(value="ports") List<PortMacTableDto> list) {
        this.mac = string;
        this.portMacTables = list;
    }

    @Generated
    public static DeviceMacTablesDtoBuilder builder() {
        return new DeviceMacTablesDtoBuilder();
    }

    @Generated
    public static class DeviceMacTablesDtoBuilder {
        @Generated
        private String mac;
        @Generated
        private List<PortMacTableDto> portMacTables;

        @Generated
        DeviceMacTablesDtoBuilder() {
        }

        @JsonProperty(value="mac")
        @Generated
        public DeviceMacTablesDtoBuilder mac(@JsonProperty(value="mac") String string) {
            this.mac = string;
            return this;
        }

        @JsonProperty(value="ports")
        @Generated
        public DeviceMacTablesDtoBuilder portMacTables(@JsonProperty(value="ports") List<PortMacTableDto> list) {
            this.portMacTables = list;
            return this;
        }

        @Generated
        public DeviceMacTablesDto build() {
            return new DeviceMacTablesDto(this.mac, this.portMacTables);
        }

        @Generated
        public String toString() {
            return "DeviceMacTablesDto.DeviceMacTablesDtoBuilder(mac=" + this.mac + ", portMacTables=" + this.portMacTables + ")";
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public static class PortMacTableDto
    implements Dto {
        @JsonProperty(value="port_idx")
        int portIdx;
        @JsonProperty(value="mac_table")
        List<MacTableEntryDto> macTableEntries;

        public static PortMacTableDto of(X x2) {
            int n2 = x2.getInt("port_idx");
            List<MacTableEntryDto> list = x2.getList("mac_table").stream().map(MacTableEntryDto::of).toList();
            return PortMacTableDto.builder().portIdx(n2).macTableEntries(list).build();
        }

        @ConstructorProperties(value={"portIdx", "macTableEntries"})
        @Generated
        PortMacTableDto(@JsonProperty(value="port_idx") int n2, @JsonProperty(value="mac_table") List<MacTableEntryDto> list) {
            this.portIdx = n2;
            this.macTableEntries = list;
        }

        @Generated
        public static PortMacTableDtoBuilder builder() {
            return new PortMacTableDtoBuilder();
        }

        @Generated
        public static class PortMacTableDtoBuilder {
            @Generated
            private int portIdx;
            @Generated
            private List<MacTableEntryDto> macTableEntries;

            @Generated
            PortMacTableDtoBuilder() {
            }

            @JsonProperty(value="port_idx")
            @Generated
            public PortMacTableDtoBuilder portIdx(@JsonProperty(value="port_idx") int n2) {
                this.portIdx = n2;
                return this;
            }

            @JsonProperty(value="mac_table")
            @Generated
            public PortMacTableDtoBuilder macTableEntries(@JsonProperty(value="mac_table") List<MacTableEntryDto> list) {
                this.macTableEntries = list;
                return this;
            }

            @Generated
            public PortMacTableDto build() {
                return new PortMacTableDto(this.portIdx, this.macTableEntries);
            }

            @Generated
            public String toString() {
                return "DeviceMacTablesDto.PortMacTableDto.PortMacTableDtoBuilder(portIdx=" + this.portIdx + ", macTableEntries=" + this.macTableEntries + ")";
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
        public static class MacTableEntryDto
        implements Dto {
            @NotNull
            @JsonProperty(value="mac")
            String mac;
            @JsonProperty(value="vlan")
            Integer vlan;
            @JsonProperty(value="age")
            Integer age;

            public static MacTableEntryDto of(@NotNull X x2) {
                return MacTableEntryDto.builder().mac(x2.getString("mac")).vlan(x2.getOptionalInt("vlan").orElse(null)).age(x2.getOptionalInt("age").orElse(null)).build();
            }

            @ConstructorProperties(value={"mac", "vlan", "age"})
            @Generated
            MacTableEntryDto(@JsonProperty(value="mac") String string, @JsonProperty(value="vlan") Integer n2, @JsonProperty(value="age") Integer n3) {
                this.mac = string;
                this.vlan = n2;
                this.age = n3;
            }

            @Generated
            public static MacTableEntryDtoBuilder builder() {
                return new MacTableEntryDtoBuilder();
            }

            @Generated
            public static class MacTableEntryDtoBuilder {
                @Generated
                private String mac;
                @Generated
                private Integer vlan;
                @Generated
                private Integer age;

                @Generated
                MacTableEntryDtoBuilder() {
                }

                @JsonProperty(value="mac")
                @Generated
                public MacTableEntryDtoBuilder mac(@JsonProperty(value="mac") String string) {
                    this.mac = string;
                    return this;
                }

                @JsonProperty(value="vlan")
                @Generated
                public MacTableEntryDtoBuilder vlan(@JsonProperty(value="vlan") Integer n2) {
                    this.vlan = n2;
                    return this;
                }

                @JsonProperty(value="age")
                @Generated
                public MacTableEntryDtoBuilder age(@JsonProperty(value="age") Integer n2) {
                    this.age = n2;
                    return this;
                }

                @Generated
                public MacTableEntryDto build() {
                    return new MacTableEntryDto(this.mac, this.vlan, this.age);
                }

                @Generated
                public String toString() {
                    return "DeviceMacTablesDto.PortMacTableDto.MacTableEntryDto.MacTableEntryDtoBuilder(mac=" + this.mac + ", vlan=" + this.vlan + ", age=" + this.age + ")";
                }
            }
        }
    }
}

