/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.serialization;

public class Lifecycle {
    private static final Lifecycle STABLE = new Lifecycle(){

        public String toString() {
            return "Stable";
        }
    };
    private static final Lifecycle EXPERIMENTAL = new Lifecycle(){

        public String toString() {
            return "Experimental";
        }
    };

    private Lifecycle() {
    }

    public static Lifecycle experimental() {
        return EXPERIMENTAL;
    }

    public static Lifecycle stable() {
        return STABLE;
    }

    public static Lifecycle deprecated(int since) {
        return new Deprecated(since);
    }

    public Lifecycle add(Lifecycle other) {
        if (this == EXPERIMENTAL || other == EXPERIMENTAL) {
            return EXPERIMENTAL;
        }
        if (this instanceof Deprecated) {
            if (other instanceof Deprecated && ((Deprecated)other).since < ((Deprecated)this).since) {
                return other;
            }
            return this;
        }
        if (other instanceof Deprecated) {
            return other;
        }
        return STABLE;
    }

    public static final class Deprecated
    extends Lifecycle {
        private final int since;

        public Deprecated(int since) {
            this.since = since;
        }

        public int since() {
            return this.since;
        }
    }
}

