/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data.worldgen;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CopperBulbBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.AxisAlignedLinearPosTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockStateMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.CappedProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class ProcessorLists {
    private static final ResourceKey<StructureProcessorList> EMPTY = ProcessorLists.createKey("empty");
    public static final ResourceKey<StructureProcessorList> ZOMBIE_PLAINS = ProcessorLists.createKey("zombie_plains");
    public static final ResourceKey<StructureProcessorList> ZOMBIE_SAVANNA = ProcessorLists.createKey("zombie_savanna");
    public static final ResourceKey<StructureProcessorList> ZOMBIE_SNOWY = ProcessorLists.createKey("zombie_snowy");
    public static final ResourceKey<StructureProcessorList> ZOMBIE_TAIGA = ProcessorLists.createKey("zombie_taiga");
    public static final ResourceKey<StructureProcessorList> ZOMBIE_DESERT = ProcessorLists.createKey("zombie_desert");
    public static final ResourceKey<StructureProcessorList> MOSSIFY_10_PERCENT = ProcessorLists.createKey("mossify_10_percent");
    public static final ResourceKey<StructureProcessorList> MOSSIFY_20_PERCENT = ProcessorLists.createKey("mossify_20_percent");
    public static final ResourceKey<StructureProcessorList> MOSSIFY_70_PERCENT = ProcessorLists.createKey("mossify_70_percent");
    public static final ResourceKey<StructureProcessorList> STREET_PLAINS = ProcessorLists.createKey("street_plains");
    public static final ResourceKey<StructureProcessorList> STREET_SAVANNA = ProcessorLists.createKey("street_savanna");
    public static final ResourceKey<StructureProcessorList> STREET_SNOWY_OR_TAIGA = ProcessorLists.createKey("street_snowy_or_taiga");
    public static final ResourceKey<StructureProcessorList> FARM_PLAINS = ProcessorLists.createKey("farm_plains");
    public static final ResourceKey<StructureProcessorList> FARM_SAVANNA = ProcessorLists.createKey("farm_savanna");
    public static final ResourceKey<StructureProcessorList> FARM_SNOWY = ProcessorLists.createKey("farm_snowy");
    public static final ResourceKey<StructureProcessorList> FARM_TAIGA = ProcessorLists.createKey("farm_taiga");
    public static final ResourceKey<StructureProcessorList> FARM_DESERT = ProcessorLists.createKey("farm_desert");
    public static final ResourceKey<StructureProcessorList> OUTPOST_ROT = ProcessorLists.createKey("outpost_rot");
    public static final ResourceKey<StructureProcessorList> BOTTOM_RAMPART = ProcessorLists.createKey("bottom_rampart");
    public static final ResourceKey<StructureProcessorList> TREASURE_ROOMS = ProcessorLists.createKey("treasure_rooms");
    public static final ResourceKey<StructureProcessorList> HOUSING = ProcessorLists.createKey("housing");
    public static final ResourceKey<StructureProcessorList> SIDE_WALL_DEGRADATION = ProcessorLists.createKey("side_wall_degradation");
    public static final ResourceKey<StructureProcessorList> STABLE_DEGRADATION = ProcessorLists.createKey("stable_degradation");
    public static final ResourceKey<StructureProcessorList> BASTION_GENERIC_DEGRADATION = ProcessorLists.createKey("bastion_generic_degradation");
    public static final ResourceKey<StructureProcessorList> RAMPART_DEGRADATION = ProcessorLists.createKey("rampart_degradation");
    public static final ResourceKey<StructureProcessorList> ENTRANCE_REPLACEMENT = ProcessorLists.createKey("entrance_replacement");
    public static final ResourceKey<StructureProcessorList> BRIDGE = ProcessorLists.createKey("bridge");
    public static final ResourceKey<StructureProcessorList> ROOF = ProcessorLists.createKey("roof");
    public static final ResourceKey<StructureProcessorList> HIGH_WALL = ProcessorLists.createKey("high_wall");
    public static final ResourceKey<StructureProcessorList> HIGH_RAMPART = ProcessorLists.createKey("high_rampart");
    public static final ResourceKey<StructureProcessorList> FOSSIL_ROT = ProcessorLists.createKey("fossil_rot");
    public static final ResourceKey<StructureProcessorList> FOSSIL_COAL = ProcessorLists.createKey("fossil_coal");
    public static final ResourceKey<StructureProcessorList> FOSSIL_DIAMONDS = ProcessorLists.createKey("fossil_diamonds");
    public static final ResourceKey<StructureProcessorList> ANCIENT_CITY_START_DEGRADATION = ProcessorLists.createKey("ancient_city_start_degradation");
    public static final ResourceKey<StructureProcessorList> ANCIENT_CITY_GENERIC_DEGRADATION = ProcessorLists.createKey("ancient_city_generic_degradation");
    public static final ResourceKey<StructureProcessorList> ANCIENT_CITY_WALLS_DEGRADATION = ProcessorLists.createKey("ancient_city_walls_degradation");
    public static final ResourceKey<StructureProcessorList> TRAIL_RUINS_HOUSES_ARCHAEOLOGY = ProcessorLists.createKey("trail_ruins_houses_archaeology");
    public static final ResourceKey<StructureProcessorList> TRAIL_RUINS_ROADS_ARCHAEOLOGY = ProcessorLists.createKey("trail_ruins_roads_archaeology");
    public static final ResourceKey<StructureProcessorList> TRAIL_RUINS_TOWER_TOP_ARCHAEOLOGY = ProcessorLists.createKey("trail_ruins_tower_top_archaeology");
    public static final ResourceKey<StructureProcessorList> TRIAL_CHAMBERS_COPPER_BULB_DEGRADATION = ProcessorLists.createKey("trial_chambers_copper_bulb_degradation");

    private static ResourceKey<StructureProcessorList> createKey(String $$0) {
        return ResourceKey.create(Registries.PROCESSOR_LIST, ResourceLocation.withDefaultNamespace($$0));
    }

    private static void register(BootstrapContext<StructureProcessorList> $$0, ResourceKey<StructureProcessorList> $$1, List<StructureProcessor> $$2) {
        $$0.register($$1, new StructureProcessorList($$2));
    }

    public static void bootstrap(BootstrapContext<StructureProcessorList> $$0) {
        HolderGetter<Block> $$1 = $$0.lookup(Registries.BLOCK);
        ProcessorRule $$2 = new ProcessorRule(new RandomBlockMatchTest(Blocks.BLACKSTONE, 0.01f), AlwaysTrueTest.INSTANCE, Blocks.GILDED_BLACKSTONE.defaultBlockState());
        ProcessorRule $$3 = new ProcessorRule(new RandomBlockMatchTest(Blocks.GILDED_BLACKSTONE, 0.5f), AlwaysTrueTest.INSTANCE, Blocks.BLACKSTONE.defaultBlockState());
        ProcessorLists.register($$0, EMPTY, (List<StructureProcessor>)ImmutableList.of());
        ProcessorLists.register($$0, ZOMBIE_PLAINS, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.COBBLESTONE, 0.8f), AlwaysTrueTest.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState()), (Object)new ProcessorRule(new TagMatchTest(BlockTags.DOORS), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.WALL_TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.COBBLESTONE, 0.07f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.MOSSY_COBBLESTONE, 0.07f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHITE_TERRACOTTA, 0.07f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.OAK_LOG, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.OAK_PLANKS, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.OAK_STAIRS, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.STRIPPED_OAK_LOG, 0.02f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.GLASS_PANE, 0.5f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object[])new ProcessorRule[]{new ProcessorRule(new BlockStateMatchTest((BlockState)((BlockState)Blocks.GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)), AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)), new ProcessorRule(new BlockStateMatchTest((BlockState)((BlockState)Blocks.GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true)), AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true)), new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CARROTS.defaultBlockState()), new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.POTATOES.defaultBlockState()), new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.BEETROOTS.defaultBlockState())}))));
        ProcessorLists.register($$0, ZOMBIE_SAVANNA, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new TagMatchTest(BlockTags.DOORS), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.WALL_TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.ACACIA_PLANKS, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.ACACIA_STAIRS, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.ACACIA_LOG, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.ACACIA_WOOD, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.ORANGE_TERRACOTTA, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.YELLOW_TERRACOTTA, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.RED_TERRACOTTA, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.GLASS_PANE, 0.5f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new BlockStateMatchTest((BlockState)((BlockState)Blocks.GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)), AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)), (Object[])new ProcessorRule[]{new ProcessorRule(new BlockStateMatchTest((BlockState)((BlockState)Blocks.GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true)), AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true)), new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.MELON_STEM.defaultBlockState())}))));
        ProcessorLists.register($$0, ZOMBIE_SNOWY, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new TagMatchTest(BlockTags.DOORS), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.WALL_TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.LANTERN), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.SPRUCE_PLANKS, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.SPRUCE_SLAB, 0.4f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.STRIPPED_SPRUCE_LOG, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.STRIPPED_SPRUCE_WOOD, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.GLASS_PANE, 0.5f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new BlockStateMatchTest((BlockState)((BlockState)Blocks.GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)), AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)), (Object)new ProcessorRule(new BlockStateMatchTest((BlockState)((BlockState)Blocks.GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true)), AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true)), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.CARROTS.defaultBlockState()), (Object[])new ProcessorRule[]{new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.8f), AlwaysTrueTest.INSTANCE, Blocks.POTATOES.defaultBlockState())}))));
        ProcessorLists.register($$0, ZOMBIE_TAIGA, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.COBBLESTONE, 0.8f), AlwaysTrueTest.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState()), (Object)new ProcessorRule(new TagMatchTest(BlockTags.DOORS), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.WALL_TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.CAMPFIRE), AlwaysTrueTest.INSTANCE, (BlockState)Blocks.CAMPFIRE.defaultBlockState().setValue(CampfireBlock.LIT, false)), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.COBBLESTONE, 0.08f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.SPRUCE_LOG, 0.08f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.GLASS_PANE, 0.5f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new BlockStateMatchTest((BlockState)((BlockState)Blocks.GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)), AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.NORTH, true)).setValue(IronBarsBlock.SOUTH, true)), (Object)new ProcessorRule(new BlockStateMatchTest((BlockState)((BlockState)Blocks.GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true)), AlwaysTrueTest.INSTANCE, (BlockState)((BlockState)Blocks.BROWN_STAINED_GLASS_PANE.defaultBlockState().setValue(IronBarsBlock.EAST, true)).setValue(IronBarsBlock.WEST, true)), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.PUMPKIN_STEM.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.POTATOES.defaultBlockState()), (Object[])new ProcessorRule[0]))));
        ProcessorLists.register($$0, ZOMBIE_DESERT, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new TagMatchTest(BlockTags.DOORS), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.WALL_TORCH), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.SMOOTH_SANDSTONE, 0.08f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.CUT_SANDSTONE, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.TERRACOTTA, 0.08f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.SMOOTH_SANDSTONE_STAIRS, 0.08f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.SMOOTH_SANDSTONE_SLAB, 0.08f), AlwaysTrueTest.INSTANCE, Blocks.COBWEB.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.BEETROOTS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.MELON_STEM.defaultBlockState())))));
        ProcessorLists.register($$0, MOSSIFY_10_PERCENT, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.COBBLESTONE, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState())))));
        ProcessorLists.register($$0, MOSSIFY_20_PERCENT, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.COBBLESTONE, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState())))));
        ProcessorLists.register($$0, MOSSIFY_70_PERCENT, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.COBBLESTONE, 0.7f), AlwaysTrueTest.INSTANCE, Blocks.MOSSY_COBBLESTONE.defaultBlockState())))));
        ProcessorLists.register($$0, STREET_PLAINS, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new BlockMatchTest(Blocks.DIRT_PATH), new BlockMatchTest(Blocks.WATER), Blocks.OAK_PLANKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DIRT_PATH, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.GRASS_BLOCK.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.GRASS_BLOCK), new BlockMatchTest(Blocks.WATER), Blocks.WATER.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.DIRT), new BlockMatchTest(Blocks.WATER), Blocks.WATER.defaultBlockState())))));
        ProcessorLists.register($$0, STREET_SAVANNA, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new BlockMatchTest(Blocks.DIRT_PATH), new BlockMatchTest(Blocks.WATER), Blocks.ACACIA_PLANKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DIRT_PATH, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.GRASS_BLOCK.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.GRASS_BLOCK), new BlockMatchTest(Blocks.WATER), Blocks.WATER.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.DIRT), new BlockMatchTest(Blocks.WATER), Blocks.WATER.defaultBlockState())))));
        ProcessorLists.register($$0, STREET_SNOWY_OR_TAIGA, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new BlockMatchTest(Blocks.DIRT_PATH), new BlockMatchTest(Blocks.WATER), Blocks.SPRUCE_PLANKS.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.DIRT_PATH), new BlockMatchTest(Blocks.ICE), Blocks.SPRUCE_PLANKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DIRT_PATH, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.GRASS_BLOCK.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.GRASS_BLOCK), new BlockMatchTest(Blocks.WATER), Blocks.WATER.defaultBlockState()), (Object)new ProcessorRule(new BlockMatchTest(Blocks.DIRT), new BlockMatchTest(Blocks.WATER), Blocks.WATER.defaultBlockState())))));
        ProcessorLists.register($$0, FARM_PLAINS, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CARROTS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.POTATOES.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.BEETROOTS.defaultBlockState())))));
        ProcessorLists.register($$0, FARM_SAVANNA, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.MELON_STEM.defaultBlockState())))));
        ProcessorLists.register($$0, FARM_SNOWY, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.CARROTS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.8f), AlwaysTrueTest.INSTANCE, Blocks.POTATOES.defaultBlockState())))));
        ProcessorLists.register($$0, FARM_TAIGA, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.PUMPKIN_STEM.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.POTATOES.defaultBlockState())))));
        ProcessorLists.register($$0, FARM_DESERT, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.BEETROOTS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.WHEAT, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.MELON_STEM.defaultBlockState())))));
        ProcessorLists.register($$0, OUTPOST_ROT, (List<StructureProcessor>)ImmutableList.of((Object)new BlockRotProcessor(0.05f)));
        ProcessorLists.register($$0, BOTTOM_RAMPART, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.MAGMA_BLOCK, 0.75f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS, 0.15f), AlwaysTrueTest.INSTANCE, Blocks.POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)$$3, (Object)$$2))));
        ProcessorLists.register($$0, TREASURE_ROOMS, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.35f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.CHISELED_POLISHED_BLACKSTONE, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)$$3, (Object)$$2))));
        ProcessorLists.register($$0, HOUSING, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.BLACKSTONE, 1.0E-4f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)$$3, (Object)$$2))));
        ProcessorLists.register($$0, SIDE_WALL_DEGRADATION, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.CHISELED_POLISHED_BLACKSTONE, 0.5f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.GOLD_BLOCK, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)$$3, (Object)$$2))));
        ProcessorLists.register($$0, STABLE_DEGRADATION, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.BLACKSTONE, 1.0E-4f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)$$3, (Object)$$2))));
        ProcessorLists.register($$0, BASTION_GENERIC_DEGRADATION, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.BLACKSTONE, 1.0E-4f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.GOLD_BLOCK, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)$$3, (Object)$$2))));
        ProcessorLists.register($$0, RAMPART_DEGRADATION, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.4f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.BLACKSTONE, 0.01f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 1.0E-4f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.BLACKSTONE, 1.0E-4f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.GOLD_BLOCK, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)$$3, (Object)$$2))));
        ProcessorLists.register($$0, ENTRANCE_REPLACEMENT, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.CHISELED_POLISHED_BLACKSTONE, 0.5f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.GOLD_BLOCK, 0.6f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)$$3, (Object)$$2))));
        ProcessorLists.register($$0, BRIDGE, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.BLACKSTONE, 1.0E-4f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState())))));
        ProcessorLists.register($$0, ROOF, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.15f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.BLACKSTONE.defaultBlockState())))));
        ProcessorLists.register($$0, HIGH_WALL, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.01f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.5f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.POLISHED_BLACKSTONE_BRICKS, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.BLACKSTONE.defaultBlockState()), (Object)$$3))));
        ProcessorLists.register($$0, HIGH_RAMPART, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.GOLD_BLOCK, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(AlwaysTrueTest.INSTANCE, AlwaysTrueTest.INSTANCE, new AxisAlignedLinearPosTest(0.0f, 0.05f, 0, 100, Direction.Axis.Y), Blocks.AIR.defaultBlockState()), (Object)$$3))));
        ProcessorLists.register($$0, FOSSIL_ROT, (List<StructureProcessor>)ImmutableList.of((Object)new BlockRotProcessor(0.9f), (Object)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register($$0, FOSSIL_COAL, (List<StructureProcessor>)ImmutableList.of((Object)new BlockRotProcessor(0.1f), (Object)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register($$0, FOSSIL_DIAMONDS, (List<StructureProcessor>)ImmutableList.of((Object)new BlockRotProcessor(0.1f), (Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new BlockMatchTest(Blocks.COAL_ORE), AlwaysTrueTest.INSTANCE, Blocks.DEEPSLATE_DIAMOND_ORE.defaultBlockState()))), (Object)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register($$0, ANCIENT_CITY_START_DEGRADATION, (List<StructureProcessor>)ImmutableList.of((Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DEEPSLATE_BRICKS, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DEEPSLATE_TILES, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.SOUL_LANTERN, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()))), (Object)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register($$0, ANCIENT_CITY_GENERIC_DEGRADATION, (List<StructureProcessor>)ImmutableList.of((Object)new BlockRotProcessor($$1.getOrThrow(BlockTags.ANCIENT_CITY_REPLACEABLE), 0.95f), (Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DEEPSLATE_BRICKS, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DEEPSLATE_TILES, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.SOUL_LANTERN, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()))), (Object)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register($$0, ANCIENT_CITY_WALLS_DEGRADATION, (List<StructureProcessor>)ImmutableList.of((Object)new BlockRotProcessor($$1.getOrThrow(BlockTags.ANCIENT_CITY_REPLACEABLE), 0.95f), (Object)new RuleProcessor((List<? extends ProcessorRule>)ImmutableList.of((Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DEEPSLATE_BRICKS, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_DEEPSLATE_BRICKS.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DEEPSLATE_TILES, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.CRACKED_DEEPSLATE_TILES.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.DEEPSLATE_TILE_SLAB, 0.3f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()), (Object)new ProcessorRule(new RandomBlockMatchTest(Blocks.SOUL_LANTERN, 0.05f), AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()))), (Object)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)));
        ProcessorLists.register($$0, TRAIL_RUINS_HOUSES_ARCHAEOLOGY, List.of(new RuleProcessor(List.of(new ProcessorRule(new RandomBlockMatchTest(Blocks.GRAVEL, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.DIRT.defaultBlockState()), new ProcessorRule(new RandomBlockMatchTest(Blocks.GRAVEL, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.COARSE_DIRT.defaultBlockState()), new ProcessorRule(new RandomBlockMatchTest(Blocks.MUD_BRICKS, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.PACKED_MUD.defaultBlockState()))), ProcessorLists.trailsArchyLootProcessor(BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 6), ProcessorLists.trailsArchyLootProcessor(BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_RARE, 3)));
        ProcessorLists.register($$0, TRAIL_RUINS_ROADS_ARCHAEOLOGY, List.of(new RuleProcessor(List.of(new ProcessorRule(new RandomBlockMatchTest(Blocks.GRAVEL, 0.2f), AlwaysTrueTest.INSTANCE, Blocks.DIRT.defaultBlockState()), new ProcessorRule(new RandomBlockMatchTest(Blocks.GRAVEL, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.COARSE_DIRT.defaultBlockState()), new ProcessorRule(new RandomBlockMatchTest(Blocks.MUD_BRICKS, 0.1f), AlwaysTrueTest.INSTANCE, Blocks.PACKED_MUD.defaultBlockState()))), ProcessorLists.trailsArchyLootProcessor(BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 2)));
        ProcessorLists.register($$0, TRAIL_RUINS_TOWER_TOP_ARCHAEOLOGY, List.of(ProcessorLists.trailsArchyLootProcessor(BuiltInLootTables.TRAIL_RUINS_ARCHAEOLOGY_COMMON, 2)));
        ProcessorLists.register($$0, TRIAL_CHAMBERS_COPPER_BULB_DEGRADATION, List.of(new RuleProcessor(List.of(new ProcessorRule(new RandomBlockMatchTest(Blocks.WAXED_COPPER_BULB, 0.1f), AlwaysTrueTest.INSTANCE, (BlockState)Blocks.WAXED_OXIDIZED_COPPER_BULB.defaultBlockState().setValue(CopperBulbBlock.LIT, true)), new ProcessorRule(new RandomBlockMatchTest(Blocks.WAXED_COPPER_BULB, 0.33333334f), AlwaysTrueTest.INSTANCE, (BlockState)Blocks.WAXED_WEATHERED_COPPER_BULB.defaultBlockState().setValue(CopperBulbBlock.LIT, true)), new ProcessorRule(new RandomBlockMatchTest(Blocks.WAXED_COPPER_BULB, 0.5f), AlwaysTrueTest.INSTANCE, (BlockState)Blocks.WAXED_EXPOSED_COPPER_BULB.defaultBlockState().setValue(CopperBulbBlock.LIT, true)))), new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)));
    }

    private static CappedProcessor trailsArchyLootProcessor(ResourceKey<LootTable> $$0, int $$1) {
        return new CappedProcessor(new RuleProcessor(List.of(new ProcessorRule(new TagMatchTest(BlockTags.TRAIL_RUINS_REPLACEABLE), AlwaysTrueTest.INSTANCE, PosAlwaysTrueTest.INSTANCE, Blocks.SUSPICIOUS_GRAVEL.defaultBlockState(), new AppendLoot($$0)))), ConstantInt.of($$1));
    }
}

