/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.ParamInfo;
import net.minecraft.server.jsonrpc.api.ResultInfo;
import net.minecraft.server.jsonrpc.methods.IllegalMethodDefinitionException;

public interface OutgoingRpcMethod<Params, Result> {
    public static final String NOTIFICATION_PREFIX = "notification/";

    public MethodInfo info();

    public Attributes attributes();

    @Nullable
    default public JsonElement encodeParams(Params $$0) {
        return null;
    }

    @Nullable
    default public Result decodeResult(JsonElement $$0) {
        return null;
    }

    public static OutgoingRpcMethodBuilder<ParmeterlessNotification> notification() {
        return new OutgoingRpcMethodBuilder<ParmeterlessNotification>(($$0, $$1) -> {
            if ($$0.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if ($$0.result().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having result but is describing it");
            }
            return new ParmeterlessNotification($$0, $$1);
        });
    }

    public static <Params> OutgoingRpcMethodBuilder<Notification<Params>> notification(Codec<Params> $$0) {
        return new OutgoingRpcMethodBuilder<Notification<Params>>(($$1, $$2) -> {
            if ($$1.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if ($$1.result().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having result but is describing it");
            }
            return new Notification($$1, $$2, $$0);
        });
    }

    public static <Result> OutgoingRpcMethodBuilder<ParameterlessMethod<Result>> request(Codec<Result> $$0) {
        return new OutgoingRpcMethodBuilder<ParameterlessMethod<Result>>(($$1, $$2) -> {
            if ($$1.params().isPresent()) {
                throw new IllegalMethodDefinitionException("Method defined as not having parameters but is describing them");
            }
            if ($$1.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new ParameterlessMethod($$1, $$2, $$0);
        });
    }

    public static <Params, Result> OutgoingRpcMethodBuilder<Method<Params, Result>> request(Codec<Params> $$0, Codec<Result> $$1) {
        return new OutgoingRpcMethodBuilder<Method<Params, Result>>(($$2, $$3) -> {
            if ($$2.params().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method defined as having parameters without describing them");
            }
            if ($$2.result().isEmpty()) {
                throw new IllegalMethodDefinitionException("Method lacks result");
            }
            return new Method($$2, $$3, $$0, $$1);
        });
    }

    public static class OutgoingRpcMethodBuilder<T extends OutgoingRpcMethod<?, ?>> {
        public static final Attributes DEFAULT_ATTRIBUTES = new Attributes(true);
        private final Factory<T> method;
        private String description = "";
        @Nullable
        private ParamInfo paramInfo;
        @Nullable
        private ResultInfo resultInfo;

        public OutgoingRpcMethodBuilder(Factory<T> $$0) {
            this.method = $$0;
        }

        public OutgoingRpcMethodBuilder<T> description(String $$0) {
            this.description = $$0;
            return this;
        }

        public OutgoingRpcMethodBuilder<T> response(ResultInfo $$0) {
            this.resultInfo = $$0;
            return this;
        }

        public OutgoingRpcMethodBuilder<T> param(ParamInfo $$0) {
            this.paramInfo = $$0;
            return this;
        }

        private T build() {
            MethodInfo $$0 = new MethodInfo(this.description, this.paramInfo, this.resultInfo);
            return this.method.create($$0, DEFAULT_ATTRIBUTES);
        }

        public Holder.Reference<T> register(String $$0) {
            return this.register(ResourceLocation.withDefaultNamespace(OutgoingRpcMethod.NOTIFICATION_PREFIX + $$0));
        }

        private Holder.Reference<T> register(ResourceLocation $$0) {
            return Registry.registerForHolder(BuiltInRegistries.OUTGOING_RPC_METHOD, $$0, this.build());
        }
    }

    @FunctionalInterface
    public static interface Factory<T extends OutgoingRpcMethod<?, ?>> {
        public T create(MethodInfo var1, Attributes var2);
    }

    public record Method<Params, Result>(MethodInfo info, Attributes attributes, Codec<Params> paramsCodec, Codec<Result> resultCodec) implements OutgoingRpcMethod<Params, Result>
    {
        @Override
        @Nullable
        public JsonElement encodeParams(Params $$0) {
            return (JsonElement)this.paramsCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, $$0).getOrThrow();
        }

        @Override
        public Result decodeResult(JsonElement $$0) {
            return (Result)this.resultCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)$$0).getOrThrow();
        }
    }

    public record Attributes(boolean discoverable) {
    }

    public record ParameterlessMethod<Result>(MethodInfo info, Attributes attributes, Codec<Result> resultCodec) implements OutgoingRpcMethod<Void, Result>
    {
        @Override
        public Result decodeResult(JsonElement $$0) {
            return (Result)this.resultCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)$$0).getOrThrow();
        }
    }

    public record Notification<Params>(MethodInfo info, Attributes attributes, Codec<Params> paramsCodec) implements OutgoingRpcMethod<Params, Void>
    {
        @Override
        @Nullable
        public JsonElement encodeParams(Params $$0) {
            return (JsonElement)this.paramsCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, $$0).getOrThrow();
        }
    }

    public record ParmeterlessNotification(MethodInfo info, Attributes attributes) implements OutgoingRpcMethod<Void, Void>
    {
    }
}

