/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class Beardifier
implements DensityFunctions.BeardifierOrMarker {
    public static final int BEARD_KERNEL_RADIUS = 12;
    private static final int BEARD_KERNEL_SIZE = 24;
    private static final float[] BEARD_KERNEL = Util.make(new float[13824], $$0 -> {
        for (int $$1 = 0; $$1 < 24; ++$$1) {
            for (int $$2 = 0; $$2 < 24; ++$$2) {
                for (int $$3 = 0; $$3 < 24; ++$$3) {
                    $$0[$$1 * 24 * 24 + $$2 * 24 + $$3] = (float)Beardifier.computeBeardContribution($$2 - 12, $$3 - 12, $$1 - 12);
                }
            }
        }
    });
    public static final Beardifier EMPTY = new Beardifier(List.of(), List.of(), null);
    private final List<Rigid> pieces;
    private final List<JigsawJunction> junctions;
    @Nullable
    private final BoundingBox affectedBox;

    public static Beardifier forStructuresInChunk(StructureManager $$02, ChunkPos $$1) {
        List<StructureStart> $$2 = $$02.startsForStructure($$1, $$0 -> $$0.terrainAdaptation() != TerrainAdjustment.NONE);
        if ($$2.isEmpty()) {
            return EMPTY;
        }
        int $$3 = $$1.getMinBlockX();
        int $$4 = $$1.getMinBlockZ();
        ArrayList<Rigid> $$5 = new ArrayList<Rigid>();
        ArrayList<JigsawJunction> $$6 = new ArrayList<JigsawJunction>();
        BoundingBox $$7 = null;
        for (StructureStart $$8 : $$2) {
            TerrainAdjustment $$9 = $$8.getStructure().terrainAdaptation();
            for (StructurePiece $$10 : $$8.getPieces()) {
                if (!$$10.isCloseToChunk($$1, 12)) continue;
                if ($$10 instanceof PoolElementStructurePiece) {
                    PoolElementStructurePiece $$11 = (PoolElementStructurePiece)$$10;
                    StructureTemplatePool.Projection $$12 = $$11.getElement().getProjection();
                    if ($$12 == StructureTemplatePool.Projection.RIGID) {
                        $$5.add(new Rigid($$11.getBoundingBox(), $$9, $$11.getGroundLevelDelta()));
                        $$7 = Beardifier.includeBoundingBox($$7, $$10.getBoundingBox());
                    }
                    for (JigsawJunction $$13 : $$11.getJunctions()) {
                        int $$14 = $$13.getSourceX();
                        int $$15 = $$13.getSourceZ();
                        if ($$14 <= $$3 - 12 || $$15 <= $$4 - 12 || $$14 >= $$3 + 15 + 12 || $$15 >= $$4 + 15 + 12) continue;
                        $$6.add($$13);
                        BoundingBox $$16 = new BoundingBox(new BlockPos($$14, $$13.getSourceGroundY(), $$15));
                        $$7 = Beardifier.includeBoundingBox($$7, $$16);
                    }
                    continue;
                }
                $$5.add(new Rigid($$10.getBoundingBox(), $$9, 0));
                $$7 = Beardifier.includeBoundingBox($$7, $$10.getBoundingBox());
            }
        }
        if ($$7 == null) {
            return EMPTY;
        }
        BoundingBox $$17 = $$7.inflatedBy(24);
        return new Beardifier(List.copyOf($$5), List.copyOf($$6), $$17);
    }

    private static BoundingBox includeBoundingBox(@Nullable BoundingBox $$0, BoundingBox $$1) {
        if ($$0 == null) {
            return $$1;
        }
        return BoundingBox.encapsulating($$0, $$1);
    }

    @VisibleForTesting
    public Beardifier(List<Rigid> $$0, List<JigsawJunction> $$1, @Nullable BoundingBox $$2) {
        this.pieces = $$0;
        this.junctions = $$1;
        this.affectedBox = $$2;
    }

    @Override
    public void fillArray(double[] $$0, DensityFunction.ContextProvider $$1) {
        if (this.affectedBox == null) {
            Arrays.fill($$0, 0.0);
        } else {
            DensityFunctions.BeardifierOrMarker.super.fillArray($$0, $$1);
        }
    }

    @Override
    public double compute(DensityFunction.FunctionContext $$0) {
        int $$3;
        int $$2;
        if (this.affectedBox == null) {
            return 0.0;
        }
        int $$1 = $$0.blockX();
        if (!this.affectedBox.isInside($$1, $$2 = $$0.blockY(), $$3 = $$0.blockZ())) {
            return 0.0;
        }
        double $$4 = 0.0;
        for (Rigid $$5 : this.pieces) {
            BoundingBox $$6 = $$5.box();
            int $$7 = $$5.groundLevelDelta();
            int $$8 = Math.max(0, Math.max($$6.minX() - $$1, $$1 - $$6.maxX()));
            int $$9 = Math.max(0, Math.max($$6.minZ() - $$3, $$3 - $$6.maxZ()));
            int $$10 = $$6.minY() + $$7;
            int $$11 = $$2 - $$10;
            int $$12 = switch ($$5.terrainAdjustment()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN -> $$11;
                case TerrainAdjustment.BEARD_BOX -> Math.max(0, Math.max($$10 - $$2, $$2 - $$6.maxY()));
                case TerrainAdjustment.ENCAPSULATE -> Math.max(0, Math.max($$6.minY() - $$2, $$2 - $$6.maxY()));
            };
            $$4 += (switch ($$5.terrainAdjustment()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.NONE -> 0.0;
                case TerrainAdjustment.BURY -> Beardifier.getBuryContribution($$8, (double)$$12 / 2.0, $$9);
                case TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> Beardifier.getBeardContribution($$8, $$12, $$9, $$11) * 0.8;
                case TerrainAdjustment.ENCAPSULATE -> Beardifier.getBuryContribution((double)$$8 / 2.0, (double)$$12 / 2.0, (double)$$9 / 2.0) * 0.8;
            });
        }
        for (JigsawJunction $$13 : this.junctions) {
            int $$14 = $$1 - $$13.getSourceX();
            int $$15 = $$2 - $$13.getSourceGroundY();
            int $$16 = $$3 - $$13.getSourceZ();
            $$4 += Beardifier.getBeardContribution($$14, $$15, $$16, $$15) * 0.4;
        }
        return $$4;
    }

    @Override
    public double minValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double maxValue() {
        return Double.POSITIVE_INFINITY;
    }

    private static double getBuryContribution(double $$0, double $$1, double $$2) {
        double $$3 = Mth.length($$0, $$1, $$2);
        return Mth.clampedMap($$3, 0.0, 6.0, 1.0, 0.0);
    }

    private static double getBeardContribution(int $$0, int $$1, int $$2, int $$3) {
        int $$4 = $$0 + 12;
        int $$5 = $$1 + 12;
        int $$6 = $$2 + 12;
        if (!(Beardifier.isInKernelRange($$4) && Beardifier.isInKernelRange($$5) && Beardifier.isInKernelRange($$6))) {
            return 0.0;
        }
        double $$7 = (double)$$3 + 0.5;
        double $$8 = Mth.lengthSquared((double)$$0, $$7, (double)$$2);
        double $$9 = -$$7 * Mth.fastInvSqrt($$8 / 2.0) / 2.0;
        return $$9 * (double)BEARD_KERNEL[$$6 * 24 * 24 + $$4 * 24 + $$5];
    }

    private static boolean isInKernelRange(int $$0) {
        return $$0 >= 0 && $$0 < 24;
    }

    private static double computeBeardContribution(int $$0, int $$1, int $$2) {
        return Beardifier.computeBeardContribution($$0, (double)$$1 + 0.5, $$2);
    }

    private static double computeBeardContribution(int $$0, double $$1, int $$2) {
        double $$3 = Mth.lengthSquared((double)$$0, $$1, (double)$$2);
        double $$4 = Math.pow(Math.E, -$$3 / 16.0);
        return $$4;
    }

    @VisibleForTesting
    public record Rigid(BoundingBox box, TerrainAdjustment terrainAdjustment, int groundLevelDelta) {
    }
}

