/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.Environment;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.TransformStore;
import cpw.mods.modlauncher.TransformTargetLabel;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class TransformationServiceDecorator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ITransformationService service;
    private boolean isValid;

    TransformationServiceDecorator(ITransformationService service) {
        this.service = service;
    }

    void onLoad(IEnvironment env, Set<String> otherServices) {
        try {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = this.service::name;
            LOGGER.debug(LogMarkers.MODLAUNCHER, "Loading service {}", supplierArray);
            this.service.onLoad(env, otherServices);
            this.isValid = true;
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = this.service::name;
            LOGGER.debug(LogMarkers.MODLAUNCHER, "Loaded service {}", supplierArray2);
        }
        catch (IncompatibleEnvironmentException e) {
            LOGGER.error(LogMarkers.MODLAUNCHER, "Service failed to load {}", (Object)this.service.name(), (Object)e);
            this.isValid = false;
        }
    }

    boolean isValid() {
        return this.isValid;
    }

    void onInitialize(IEnvironment environment) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Initializing transformation service {}", supplierArray);
        this.service.initialize(environment);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Initialized transformation service {}", supplierArray2);
    }

    public void gatherTransformers(TransformStore transformStore) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Initializing transformers for transformation service {}", supplierArray);
        List<ITransformer> transformers = this.service.transformers();
        Objects.requireNonNull(transformers, "The transformers list should not be null");
        for (ITransformer transformer : transformers) {
            Type[] genericInterfaces;
            Type type = null;
            for (Type typ : genericInterfaces = transformer.getClass().getGenericInterfaces()) {
                ParameterizedType pt;
                Type type2 = typ;
                if (!(type2 instanceof ParameterizedType) || !(pt = (ParameterizedType)type2).getRawType().equals(ITransformer.class)) continue;
                type = pt.getActualTypeArguments()[0];
                break;
            }
            if (type == null) {
                LOGGER.error(LogMarkers.MODLAUNCHER, "Invalid Transformer, could not determine generic type {}", (Object)transformer.getClass().getSimpleName());
                throw new IllegalArgumentException("Invalid Transformer, could not determine generic type " + transformer.getClass().getSimpleName());
            }
            TransformTargetLabel.LabelType seen = null;
            for (ITransformer.Target target : transformer.targets()) {
                TransformTargetLabel label = new TransformTargetLabel(target);
                if (seen != null && label.getLabelType() != seen || !label.getLabelType().getNodeType().getName().equals(type.getTypeName())) {
                    LOGGER.info(LogMarkers.MODLAUNCHER, "Invalid target {} for transformer {}", (Object)label.getLabelType(), (Object)transformer);
                    throw new IllegalArgumentException("Invalid target " + label.getLabelType() + " for transformer " + transformer);
                }
                seen = label.getLabelType();
                transformStore.addTransformer(label, transformer, this.service);
            }
        }
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Initialized transformers for transformation service {}", supplierArray2);
    }

    ITransformationService getService() {
        return this.service;
    }

    List<ITransformationService.Resource> runScan(Environment environment) {
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Beginning scan trigger - transformation service {}", supplierArray);
        List<ITransformationService.Resource> scanResults = this.service.beginScanning(environment);
        Supplier[] supplierArray2 = new Supplier[1];
        supplierArray2[0] = this.service::name;
        LOGGER.debug(LogMarkers.MODLAUNCHER, "End scan trigger - transformation service {}", supplierArray2);
        return scanResults;
    }

    public List<ITransformationService.Resource> onCompleteScan(IModuleLayerManager moduleLayerManager) {
        return this.service.completeScan(moduleLayerManager);
    }
}

