/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<FriendlyByteBuf, RecipeBookSettings> STREAM_CODEC = StreamCodec.composite(TypeSettings.STREAM_CODEC, p_405231_ -> p_405231_.crafting, TypeSettings.STREAM_CODEC, p_405234_ -> p_405234_.furnace, TypeSettings.STREAM_CODEC, p_405229_ -> p_405229_.blastFurnace, TypeSettings.STREAM_CODEC, p_405228_ -> p_405228_.smoker, RecipeBookSettings::new);
    public static final MapCodec<RecipeBookSettings> MAP_CODEC = RecordCodecBuilder.mapCodec(p_405232_ -> p_405232_.group((App)TypeSettings.CRAFTING_MAP_CODEC.forGetter(p_405235_ -> p_405235_.crafting), (App)TypeSettings.FURNACE_MAP_CODEC.forGetter(p_405230_ -> p_405230_.furnace), (App)TypeSettings.BLAST_FURNACE_MAP_CODEC.forGetter(p_405233_ -> p_405233_.blastFurnace), (App)TypeSettings.SMOKER_MAP_CODEC.forGetter(p_405236_ -> p_405236_.smoker)).apply((Applicative)p_405232_, RecipeBookSettings::new));
    private TypeSettings crafting;
    private TypeSettings furnace;
    private TypeSettings blastFurnace;
    private TypeSettings smoker;

    public RecipeBookSettings() {
        this(TypeSettings.DEFAULT, TypeSettings.DEFAULT, TypeSettings.DEFAULT, TypeSettings.DEFAULT);
    }

    private RecipeBookSettings(TypeSettings p_408344_, TypeSettings p_409931_, TypeSettings p_406632_, TypeSettings p_410694_) {
        this.crafting = p_408344_;
        this.furnace = p_409931_;
        this.blastFurnace = p_406632_;
        this.smoker = p_410694_;
    }

    @VisibleForTesting
    public TypeSettings getSettings(RecipeBookType p_361337_) {
        return switch (p_361337_) {
            default -> throw new MatchException(null, null);
            case RecipeBookType.CRAFTING -> this.crafting;
            case RecipeBookType.FURNACE -> this.furnace;
            case RecipeBookType.BLAST_FURNACE -> this.blastFurnace;
            case RecipeBookType.SMOKER -> this.smoker;
        };
    }

    private void updateSettings(RecipeBookType p_363317_, UnaryOperator<TypeSettings> p_364138_) {
        switch (p_363317_) {
            case CRAFTING: {
                this.crafting = (TypeSettings)p_364138_.apply(this.crafting);
                break;
            }
            case FURNACE: {
                this.furnace = (TypeSettings)p_364138_.apply(this.furnace);
                break;
            }
            case BLAST_FURNACE: {
                this.blastFurnace = (TypeSettings)p_364138_.apply(this.blastFurnace);
                break;
            }
            case SMOKER: {
                this.smoker = (TypeSettings)p_364138_.apply(this.smoker);
            }
        }
    }

    public boolean isOpen(RecipeBookType p_12735_) {
        return this.getSettings((RecipeBookType)p_12735_).open;
    }

    public void setOpen(RecipeBookType p_12737_, boolean p_12738_) {
        this.updateSettings(p_12737_, p_358758_ -> p_358758_.setOpen(p_12738_));
    }

    public boolean isFiltering(RecipeBookType p_12755_) {
        return this.getSettings((RecipeBookType)p_12755_).filtering;
    }

    public void setFiltering(RecipeBookType p_12757_, boolean p_12758_) {
        this.updateSettings(p_12757_, p_358756_ -> p_358756_.setFiltering(p_12758_));
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(this.crafting, this.furnace, this.blastFurnace, this.smoker);
    }

    public void replaceFrom(RecipeBookSettings p_12733_) {
        this.crafting = p_12733_.crafting;
        this.furnace = p_12733_.furnace;
        this.blastFurnace = p_12733_.blastFurnace;
        this.smoker = p_12733_.smoker;
    }

    public static void register(RecipeBookType type) {
        String name = type.name().toLowerCase(Locale.ROOT).replace("_", "");
        MapCodec<TypeSettings> codec = TypeSettings.codec("is" + name + "GuiOpen", "is" + name + "FilteringCraftable");
        throw new IllegalStateException("This is not implemented yet, poke Forge if you actually use this");
    }

    public record TypeSettings(boolean open, boolean filtering) {
        public static final TypeSettings DEFAULT = new TypeSettings(false, false);
        public static final MapCodec<TypeSettings> CRAFTING_MAP_CODEC = TypeSettings.codec("isGuiOpen", "isFilteringCraftable");
        public static final MapCodec<TypeSettings> FURNACE_MAP_CODEC = TypeSettings.codec("isFurnaceGuiOpen", "isFurnaceFilteringCraftable");
        public static final MapCodec<TypeSettings> BLAST_FURNACE_MAP_CODEC = TypeSettings.codec("isBlastingFurnaceGuiOpen", "isBlastingFurnaceFilteringCraftable");
        public static final MapCodec<TypeSettings> SMOKER_MAP_CODEC = TypeSettings.codec("isSmokerGuiOpen", "isSmokerFilteringCraftable");
        public static final StreamCodec<ByteBuf, TypeSettings> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.BOOL, TypeSettings::open, ByteBufCodecs.BOOL, TypeSettings::filtering, TypeSettings::new);

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public TypeSettings setOpen(boolean p_363040_) {
            return new TypeSettings(p_363040_, this.filtering);
        }

        public TypeSettings setFiltering(boolean p_366242_) {
            return new TypeSettings(this.open, p_366242_);
        }

        private static MapCodec<TypeSettings> codec(String p_408682_, String p_410390_) {
            return RecordCodecBuilder.mapCodec(p_407394_ -> p_407394_.group((App)Codec.BOOL.optionalFieldOf(p_408682_, (Object)false).forGetter(TypeSettings::open), (App)Codec.BOOL.optionalFieldOf(p_410390_, (Object)false).forGetter(TypeSettings::filtering)).apply((Applicative)p_407394_, TypeSettings::new));
        }
    }
}

