/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.entity;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityLookup;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.LevelEntityGetterAdapter;
import net.minecraft.world.level.entity.Visibility;
import net.minecraftforge.event.ForgeEventFactory;
import org.slf4j.Logger;

public class TransientEntitySectionManager<T extends EntityAccess> {
    static final Logger LOGGER = LogUtils.getLogger();
    final LevelCallback<T> callbacks;
    final EntityLookup<T> entityStorage;
    final EntitySectionStorage<T> sectionStorage;
    private final LongSet tickingChunks = new LongOpenHashSet();
    private final LevelEntityGetter<T> entityGetter;

    public TransientEntitySectionManager(Class<T> p_157643_, LevelCallback<T> p_157644_) {
        this.entityStorage = new EntityLookup();
        this.sectionStorage = new EntitySectionStorage<T>(p_157643_, (Long2ObjectFunction<Visibility>)((Long2ObjectFunction)p_157647_ -> this.tickingChunks.contains(p_157647_) ? Visibility.TICKING : Visibility.TRACKED));
        this.callbacks = p_157644_;
        this.entityGetter = new LevelEntityGetterAdapter<T>(this.entityStorage, this.sectionStorage);
    }

    public void startTicking(ChunkPos p_157652_) {
        long i = p_157652_.toLong();
        this.tickingChunks.add(i);
        this.sectionStorage.getExistingSectionsInChunk(i).forEach(p_157663_ -> {
            Visibility visibility = p_157663_.updateChunkStatus(Visibility.TICKING);
            if (!visibility.isTicking()) {
                p_157663_.getEntities().filter(p_157666_ -> !p_157666_.isAlwaysTicking()).forEach(this.callbacks::onTickingStart);
            }
        });
    }

    public void stopTicking(ChunkPos p_157659_) {
        long i = p_157659_.toLong();
        this.tickingChunks.remove(i);
        this.sectionStorage.getExistingSectionsInChunk(i).forEach(p_157656_ -> {
            Visibility visibility = p_157656_.updateChunkStatus(Visibility.TRACKED);
            if (visibility.isTicking()) {
                p_157656_.getEntities().filter(p_157661_ -> !p_157661_.isAlwaysTicking()).forEach(this.callbacks::onTickingEnd);
            }
        });
    }

    public LevelEntityGetter<T> getEntityGetter() {
        return this.entityGetter;
    }

    public void addEntity(T p_157654_) {
        this.entityStorage.add(p_157654_);
        long i = SectionPos.asLong(p_157654_.blockPosition());
        EntitySection<T> entitysection = this.sectionStorage.getOrCreateSection(i);
        entitysection.add(p_157654_);
        p_157654_.setLevelCallback(new Callback(this, p_157654_, i, entitysection));
        this.callbacks.onCreated(p_157654_);
        this.callbacks.onTrackingStart(p_157654_);
        if (p_157654_.isAlwaysTicking() || entitysection.getStatus().isTicking()) {
            this.callbacks.onTickingStart(p_157654_);
        }
    }

    @VisibleForDebug
    public int count() {
        return this.entityStorage.count();
    }

    void removeSectionIfEmpty(long p_157649_, EntitySection<T> p_157650_) {
        if (p_157650_.isEmpty()) {
            this.sectionStorage.remove(p_157649_);
        }
    }

    @VisibleForDebug
    public String gatherStats() {
        return this.entityStorage.count() + "," + this.sectionStorage.count() + "," + this.tickingChunks.size();
    }

    class Callback
    implements EntityInLevelCallback {
        private final T entity;
        private final Entity realEntity;
        private long currentSectionKey;
        private EntitySection<T> currentSection;
        final /* synthetic */ TransientEntitySectionManager this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        Callback(T t, long p_157675_, EntitySection<T> entitySection) {
            void var3_3;
            void p_157673_;
            this.this$0 = (TransientEntitySectionManager)this$0;
            this.entity = p_157673_;
            this.realEntity = p_157673_ instanceof Entity ? (Entity)p_157673_ : null;
            this.currentSectionKey = var3_3;
            this.currentSection = (EntitySection)p_157675_;
        }

        @Override
        public void onMove() {
            BlockPos blockpos = this.entity.blockPosition();
            long i = SectionPos.asLong(blockpos);
            if (i != this.currentSectionKey) {
                Visibility visibility = this.currentSection.getStatus();
                if (!this.currentSection.remove(this.entity)) {
                    LOGGER.warn("Entity {} wasn't found in section {} (moving to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), i});
                }
                this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
                EntitySection entitysection = this.this$0.sectionStorage.getOrCreateSection(i);
                entitysection.add(this.entity);
                long oldSectionKey = this.currentSectionKey;
                this.currentSection = entitysection;
                this.currentSectionKey = i;
                this.this$0.callbacks.onSectionChange(this.entity);
                if (!this.entity.isAlwaysTicking()) {
                    boolean flag = visibility.isTicking();
                    boolean flag1 = entitysection.getStatus().isTicking();
                    if (flag && !flag1) {
                        this.this$0.callbacks.onTickingEnd(this.entity);
                    } else if (!flag && flag1) {
                        this.this$0.callbacks.onTickingStart(this.entity);
                    }
                }
                if (this.realEntity != null) {
                    ForgeEventFactory.onEntityEnterSection((Entity)this.realEntity, (long)oldSectionKey, (long)i);
                }
            }
        }

        @Override
        public void onRemove(Entity.RemovalReason p_157678_) {
            Visibility visibility;
            if (!this.currentSection.remove(this.entity)) {
                LOGGER.warn("Entity {} wasn't found in section {} (destroying due to {})", new Object[]{this.entity, SectionPos.of(this.currentSectionKey), p_157678_});
            }
            if ((visibility = this.currentSection.getStatus()).isTicking() || this.entity.isAlwaysTicking()) {
                this.this$0.callbacks.onTickingEnd(this.entity);
            }
            this.this$0.callbacks.onTrackingEnd(this.entity);
            this.this$0.callbacks.onDestroyed(this.entity);
            this.this$0.entityStorage.remove(this.entity);
            this.entity.setLevelCallback(NULL);
            this.this$0.removeSectionIfEmpty(this.currentSectionKey, this.currentSection);
        }
    }
}

