/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui;

import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.gui.widget.ExtendedButton;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.LoadingFailedException;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.loading.FMLPaths;

public class LoadingErrorScreen
extends ErrorScreen {
    private final Path modsDir;
    private final Path logFile;
    private final List<ModLoadingException> modLoadErrors;
    private final List<ModLoadingWarning> modLoadWarnings;
    private final Path dumpedLocation;
    private LoadingEntryList entryList;
    private Component errorHeader;
    private Component warningHeader;

    public LoadingErrorScreen(LoadingFailedException loadingException, List<ModLoadingWarning> warnings, File dumpedLocation) {
        super((Component)Component.literal((String)"Loading Error"), null);
        this.modLoadWarnings = warnings;
        this.modLoadErrors = loadingException == null ? Collections.emptyList() : loadingException.getErrors();
        this.modsDir = FMLPaths.MODSDIR.get();
        this.logFile = FMLPaths.GAMEDIR.get().resolve(Paths.get("logs", "latest.log"));
        this.dumpedLocation = dumpedLocation != null ? dumpedLocation.toPath() : null;
    }

    public void init() {
        super.init();
        this.clearWidgets();
        this.errorHeader = Component.literal((String)(String.valueOf(ChatFormatting.RED) + ForgeI18n.parseMessage("fml.loadingerrorscreen.errorheader", this.modLoadErrors.size()) + String.valueOf(ChatFormatting.RESET)));
        this.warningHeader = Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + ForgeI18n.parseMessage("fml.loadingerrorscreen.warningheader", this.modLoadErrors.size()) + String.valueOf(ChatFormatting.RESET)));
        int yOffset = 46;
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(50, this.height - yOffset, this.width / 2 - 55, 20, (Component)Component.literal((String)ForgeI18n.parseMessage("fml.button.open.mods.folder", new Object[0])), b -> Util.getPlatform().openFile(this.modsDir.toFile())));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 + 5, this.height - yOffset, this.width / 2 - 55, 20, (Component)Component.literal((String)ForgeI18n.parseMessage("fml.button.open.file", this.logFile.getFileName())), b -> Util.getPlatform().openFile(this.logFile.toFile())));
        if (this.modLoadErrors.isEmpty()) {
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 4, this.height - 24, this.width / 2, 20, (Component)Component.literal((String)ForgeI18n.parseMessage("fml.button.continue.launch", new Object[0])), b -> this.minecraft.setScreen(null)));
        } else {
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 4, this.height - 24, this.width / 2, 20, (Component)Component.literal((String)ForgeI18n.parseMessage("fml.button.open.file", this.dumpedLocation.getFileName())), b -> Util.getPlatform().openFile(this.dumpedLocation.toFile())));
        }
        this.entryList = new LoadingEntryList(this, this.modLoadErrors, this.modLoadWarnings);
        this.addWidget((GuiEventListener)this.entryList);
        this.setFocused((GuiEventListener)this.entryList);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.entryList.render(guiGraphics, mouseX, mouseY, partialTick);
        this.drawMultiLineCenteredString(guiGraphics, this.font, this.modLoadErrors.isEmpty() ? this.warningHeader : this.errorHeader, this.width / 2, 10);
        this.renderables.forEach(button -> button.render(guiGraphics, mouseX, mouseY, partialTick));
    }

    private void drawMultiLineCenteredString(GuiGraphics guiGraphics, Font fr, Component str, int x, int y) {
        for (FormattedCharSequence s : fr.split((FormattedText)str, this.width)) {
            guiGraphics.drawString(fr, s, x - fr.width(s) / 2, y, -1);
            Objects.requireNonNull(fr);
            y += 9;
        }
    }

    public static class LoadingEntryList
    extends ObjectSelectionList<LoadingMessageEntry> {
        LoadingEntryList(LoadingErrorScreen parent, List<ModLoadingException> errors, List<ModLoadingWarning> warnings) {
            boolean both;
            int n = parent.width;
            int n2 = parent.height;
            int n3 = Math.max(errors.stream().mapToInt(error -> parent.font.split((FormattedText)Component.literal((String)(error.getMessage() != null ? error.getMessage() : "")), parent.width - 20).size()).max().orElse(0), warnings.stream().mapToInt(warning -> parent.font.split((FormattedText)Component.literal((String)(warning.formatToString() != null ? warning.formatToString() : "")), parent.width - 20).size()).max().orElse(0));
            Objects.requireNonNull(((LoadingErrorScreen)parent).minecraft.font);
            super(Objects.requireNonNull(parent.minecraft), n, n2, 35, n3 * 9 + 8);
            boolean bl = both = !errors.isEmpty() && !warnings.isEmpty();
            if (both) {
                this.addEntry((AbstractSelectionList.Entry)new LoadingMessageEntry(parent.errorHeader, true));
            }
            errors.forEach(e -> this.addEntry((AbstractSelectionList.Entry)new LoadingMessageEntry((Component)Component.literal((String)e.formatToString()))));
            if (both) {
                int maxChars = (this.width - 10) / ((LoadingErrorScreen)parent).minecraft.font.width("-");
                this.addEntry((AbstractSelectionList.Entry)new LoadingMessageEntry((Component)Component.literal((String)("\n" + Strings.repeat((String)"-", (int)maxChars) + "\n"))));
                this.addEntry((AbstractSelectionList.Entry)new LoadingMessageEntry(parent.warningHeader, true));
            }
            warnings.forEach(w -> this.addEntry((AbstractSelectionList.Entry)new LoadingMessageEntry((Component)Component.literal((String)w.formatToString()))));
        }

        public int getRowWidth() {
            return this.width;
        }

        public class LoadingMessageEntry
        extends ObjectSelectionList.Entry<LoadingMessageEntry> {
            private final Component message;
            private final boolean center;

            LoadingMessageEntry(Component message) {
                this(message, false);
            }

            LoadingMessageEntry(Component message, boolean center) {
                this.message = Objects.requireNonNull(message);
                this.center = center;
            }

            public Component getNarration() {
                return Component.translatable((String)"narrator.select", (Object[])new Object[]{this.message});
            }

            public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                int top = this.getContentY();
                int left = this.getContentX();
                Minecraft mc = Minecraft.getInstance();
                Font font = mc.font;
                List strings = font.split((FormattedText)this.message, LoadingEntryList.this.width - 20);
                int y = top + 2;
                for (FormattedCharSequence string : strings) {
                    if (this.center) {
                        guiGraphics.drawString(font, string, left + LoadingEntryList.this.width / 2 - font.width(string) / 2, y, -1, false);
                    } else {
                        guiGraphics.drawString(font, string, left + 5, y, -1, false);
                    }
                    Objects.requireNonNull(font);
                    y += 9;
                }
            }
        }
    }
}

