/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import com.mojang.math.Quadrant;
import com.mojang.math.Transformation;
import java.util.BitSet;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.client.model.SimpleModelState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ApiStatus.Internal
public class UnbakedGeometryHelper {
    private static final Pattern FILESYSTEM_PATH_TO_RESLOC = Pattern.compile("(?:.*[\\\\/]assets[\\\\/](?<namespace>[a-z_-]+)[\\\\/]textures[\\\\/])?(?<path>[a-z_\\\\/-]+)\\.png");
    private static final Material MISSING_MATERIAL = UnbakedGeometryHelper.getMaterial(MissingTextureAtlasSprite.getLocation().toString());

    public static Material resolveDirtyMaterial(@Nullable String tex, TextureSlots textures) {
        if (tex == null) {
            return MISSING_MATERIAL;
        }
        if (tex.startsWith("#")) {
            return textures.getMaterial(tex);
        }
        Matcher match = FILESYSTEM_PATH_TO_RESLOC.matcher(tex);
        if (match.matches()) {
            String namespace = match.group("namespace");
            String path = match.group("path").replace("\\", "/");
            tex = namespace != null ? namespace + ":" + path : path;
        }
        return UnbakedGeometryHelper.getMaterial(tex);
    }

    public static List<BlockElement> createUnbakedItemElements(int layerIndex, SpriteContents spriteContents) {
        return ItemModelGenerator.processFrames((int)layerIndex, (String)("layer" + layerIndex), (SpriteContents)spriteContents);
    }

    public static List<BlockElement> createUnbakedItemMaskElements(int layerIndex, SpriteContents spriteContents) {
        List<BlockElement> elements = UnbakedGeometryHelper.createUnbakedItemElements(layerIndex, spriteContents);
        elements.remove(0);
        int width = spriteContents.width();
        int height = spriteContents.height();
        BitSet bits = new BitSet(width * height);
        spriteContents.getUniqueFrames().forEach(frame -> {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (spriteContents.isTransparent(frame, x, y)) continue;
                    bits.set(x + y * width);
                }
            }
        });
        for (int y = 0; y < height; ++y) {
            int xStart = -1;
            for (int x = 0; x < width; ++x) {
                int yEnd;
                boolean opaque = bits.get(x + y * width);
                if (opaque != (xStart == -1)) continue;
                if (xStart == -1) {
                    xStart = x;
                    continue;
                }
                block2: for (yEnd = y + 1; yEnd < height; ++yEnd) {
                    for (int x2 = xStart; x2 <= x; ++x2) {
                        if (!bits.get(x2 + yEnd * width)) break block2;
                    }
                }
                for (int i = xStart; i < x; ++i) {
                    for (int j = y; j < yEnd; ++j) {
                        bits.clear(i + j * width);
                    }
                }
                elements.add(new BlockElement((Vector3fc)new Vector3f((float)(16 * xStart) / (float)width, 16.0f - (float)(16 * yEnd) / (float)height, 7.5f), (Vector3fc)new Vector3f((float)(16 * x) / (float)width, 16.0f - (float)(16 * y) / (float)height, 8.5f), Util.makeEnumMap(Direction.class, dir -> new BlockElementFace(dir, layerIndex, "layer" + layerIndex, new BlockElementFace.UVs(0.0f, 0.0f, 16.0f, 16.0f), Quadrant.R0))));
                xStart = -1;
            }
        }
        return elements;
    }

    public static QuadCollection bakeElements(List<BlockElement> elements, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState) {
        return UnbakedGeometryHelper.bakeElements(elements, spriteGetter, modelState, QuadTransformers.empty());
    }

    public static QuadCollection bakeElements(List<BlockElement> elements, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, IQuadTransformer transformer) {
        QuadCollection.Builder builder = new QuadCollection.Builder();
        UnbakedGeometryHelper.bakeElements(elements, spriteGetter, modelState, builder);
        return builder.build();
    }

    public static void bakeElements(List<BlockElement> elements, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, QuadCollection.Builder builder) {
        UnbakedGeometryHelper.bakeElements(elements, spriteGetter, modelState, QuadTransformers.empty(), builder);
    }

    public static void bakeElements(List<BlockElement> elements, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, IQuadTransformer transformer, QuadCollection.Builder builder) {
        for (BlockElement element : elements) {
            element.faces().forEach((side, face) -> {
                TextureAtlasSprite sprite = (TextureAtlasSprite)spriteGetter.apply(UnbakedGeometryHelper.getMaterial(face.texture()));
                BakedQuad quad = UnbakedGeometryHelper.bakeElementFace(element, face, sprite, side, modelState, element.lightEmission());
                if (face.cullForDirection() == null) {
                    builder.addUnculledFace(quad);
                } else {
                    builder.addCulledFace(Direction.rotate((Matrix4fc)modelState.transformation().getMatrix(), (Direction)face.cullForDirection()), quad);
                }
            });
        }
    }

    private static Material getMaterial(String texture) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.parse((String)texture));
    }

    public static BakedQuad bakeElementFace(BlockElement element, BlockElementFace face, TextureAtlasSprite sprite, Direction direction, ModelState state, int lightEmission) {
        return FaceBakery.bakeQuad((Vector3fc)element.from(), (Vector3fc)element.to(), (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)direction, (ModelState)state, (BlockElementRotation)element.rotation(), (boolean)element.shade(), (int)lightEmission);
    }

    public static IQuadTransformer applyRootTransform(ModelState modelState, Transformation rootTransform) {
        Transformation transform = modelState.transformation().applyOrigin(new Vector3f(0.5f, 0.5f, 0.5f));
        return QuadTransformers.applying(transform.compose(rootTransform).compose(transform.inverse()));
    }

    public static ModelState composeRootTransformIntoModelState(ModelState modelState, Transformation rootTransform) {
        rootTransform = rootTransform.applyOrigin(new Vector3f(-0.5f, -0.5f, -0.5f));
        return new SimpleModelState(modelState.transformation().compose(rootTransform));
    }
}

