/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.FluidTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class ForgeFluidTagsProvider
extends FluidTagsProvider {
    public ForgeFluidTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    public void addTags(HolderLookup.Provider lookupProvider) {
        this.tag(Tags.Fluids.WATER).add((Object)Fluids.WATER).add((Object)Fluids.FLOWING_WATER);
        this.tag(Tags.Fluids.LAVA).add((Object)Fluids.LAVA).add((Object)Fluids.FLOWING_LAVA);
        this.tag(Tags.Fluids.MILK).addOptional(ForgeMod.MILK.getKey().location()).addOptional(ForgeMod.FLOWING_MILK.getKey().location());
        this.tag(Tags.Fluids.GASEOUS);
        this.tag(Tags.Fluids.HONEY);
        this.tag(Tags.Fluids.POTION);
        this.tag(Tags.Fluids.SUSPICIOUS_STEW);
        this.tag(Tags.Fluids.MUSHROOM_STEW);
        this.tag(Tags.Fluids.RABBIT_STEW);
        this.tag(Tags.Fluids.BEETROOT_SOUP);
        this.tag(Tags.Fluids.HIDDEN_FROM_RECIPE_VIEWERS);
        this.tag(ForgeFluidTagsProvider.forgeTagKey("milk")).addOptional(ForgeMod.MILK.getKey().location()).addOptional(ForgeMod.FLOWING_MILK.getKey().location());
    }

    private static TagKey<Fluid> forgeTagKey(String path) {
        return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"forge", (String)path));
    }

    public String getName() {
        return "Forge Fluid Tags";
    }
}

