/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp8;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.cc.AdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.RtpState;
import org.jitsi.videobridge.cc.vp8.VP8Frame;
import org.jitsi.videobridge.cc.vp8.VP8FrameMap;
import org.jitsi.videobridge.cc.vp8.VP8FrameProjection;
import org.jitsi.videobridge.cc.vp8.VP8QualityFilter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class VP8AdaptiveSourceProjectionContext
implements AdaptiveSourceProjectionContext {
    private final Logger logger;
    private final Map<Long, VP8FrameMap> vp8FrameMaps = new HashMap<Long, VP8FrameMap>();
    private final VP8QualityFilter vp8QualityFilter;
    private final DiagnosticContext diagnosticContext;
    private VP8FrameProjection lastVP8FrameProjection;

    public VP8AdaptiveSourceProjectionContext(@NotNull DiagnosticContext diagnosticContext, @NotNull RtpState rtpState, @NotNull Logger parentLogger) {
        this.diagnosticContext = diagnosticContext;
        this.logger = parentLogger.createChildLogger(VP8AdaptiveSourceProjectionContext.class.getName());
        this.vp8QualityFilter = new VP8QualityFilter(parentLogger);
        this.lastVP8FrameProjection = new VP8FrameProjection(diagnosticContext, rtpState.ssrc, rtpState.maxSequenceNumber, rtpState.maxTimestamp);
    }

    private VP8Frame lookupVP8Frame(@NotNull Vp8Packet vp8Packet) {
        VP8FrameMap frameMap = this.vp8FrameMaps.get(vp8Packet.getSsrc());
        if (frameMap == null) {
            return null;
        }
        return frameMap.findFrame(vp8Packet);
    }

    private VP8FrameMap.FrameInsertionResult insertPacketInMap(@NotNull Vp8Packet vp8Packet) {
        VP8FrameMap frameMap = this.vp8FrameMaps.computeIfAbsent(vp8Packet.getSsrc(), ssrc -> new VP8FrameMap(this.logger));
        return frameMap.insertPacket(vp8Packet);
    }

    @Nullable
    private synchronized VP8Frame prevFrame(@NotNull VP8Frame frame) {
        VP8FrameMap frameMap = this.vp8FrameMaps.get(frame.getSsrc());
        if (frameMap == null) {
            return null;
        }
        return frameMap.prevFrame(frame);
    }

    @Nullable
    private synchronized VP8Frame nextFrame(@NotNull VP8Frame frame) {
        VP8FrameMap frameMap = this.vp8FrameMaps.get(frame.getSsrc());
        if (frameMap == null) {
            return null;
        }
        return frameMap.nextFrame(frame);
    }

    @Nullable
    private VP8Frame findPrevAcceptedFrame(@NotNull VP8Frame frame) {
        VP8FrameMap frameMap = this.vp8FrameMaps.get(frame.getSsrc());
        if (frameMap == null) {
            return null;
        }
        return frameMap.findPrevAcceptedFrame(frame);
    }

    @Nullable
    private VP8Frame findNextAcceptedFrame(@NotNull VP8Frame frame) {
        VP8FrameMap frameMap = this.vp8FrameMaps.get(frame.getSsrc());
        if (frameMap == null) {
            return null;
        }
        return frameMap.findNextAcceptedFrame(frame);
    }

    @Nullable
    private VP8Frame findNextTl0(@NotNull VP8Frame frame) {
        VP8FrameMap frameMap = this.vp8FrameMaps.get(frame.getSsrc());
        if (frameMap == null) {
            return null;
        }
        return frameMap.findNextTl0(frame);
    }

    private int seqGap(@NotNull VP8Frame frame1, @NotNull VP8Frame frame2) {
        int seqGap = RtpUtils.getSequenceNumberDelta((int)frame2.getEarliestKnownSequenceNumber(), (int)frame1.getLatestKnownSequenceNumber());
        if (!frame1.isAccepted() && !frame2.isAccepted() && frame2.isImmediatelyAfter(frame1)) {
            seqGap = 0;
        } else {
            if (!frame1.isAccepted() && !frame1.hasSeenEndOfFrame() && seqGap > 1) {
                --seqGap;
            }
            if (!frame2.isAccepted() && !frame2.hasSeenStartOfFrame() && seqGap > 1) {
                --seqGap;
            }
            if (!frame1.isAccepted() && seqGap > 0) {
                --seqGap;
            }
        }
        return seqGap;
    }

    private int picGap(@NotNull VP8Frame frame1, @NotNull VP8Frame frame2) {
        int picGap = VpxUtils.getExtendedPictureIdDelta((int)frame2.getPictureId(), (int)frame1.getPictureId());
        if (!frame1.isAccepted() && picGap > 0) {
            --picGap;
        }
        return picGap;
    }

    private boolean frameIsNewSsrc(VP8Frame frame) {
        return this.lastVP8FrameProjection.getVP8Frame() == null || !frame.matchesSSRC(this.lastVP8FrameProjection.getVP8Frame());
    }

    @Override
    public synchronized boolean accept(@NotNull PacketInfo packetInfo, int targetIndex) {
        if (!(packetInfo.getPacket() instanceof Vp8Packet)) {
            this.logger.warn((Object)"Packet is not VP8 packet");
            return false;
        }
        Vp8Packet vp8Packet = (Vp8Packet)packetInfo.packetAs();
        int incomingEncoding = vp8Packet.getEncodingId();
        VP8FrameMap.FrameInsertionResult result = this.insertPacketInMap(vp8Packet);
        if (result == null) {
            return false;
        }
        VP8Frame frame = result.getFrame();
        if (result.isNewFrame()) {
            Instant receivedTime;
            boolean accepted;
            VP8Frame f;
            if (vp8Packet.isKeyframe() && this.frameIsNewSsrc(frame) && (f = this.findNextTl0(frame)) != null && !f.isAccepted()) {
                frame.setKeyframe(false);
            }
            if (accepted = this.vp8QualityFilter.acceptFrame(frame, incomingEncoding, targetIndex, receivedTime = packetInfo.getReceivedTime())) {
                accepted = this.checkDecodability(frame);
            }
            frame.setAccepted(accepted);
            if (accepted) {
                VP8FrameProjection projection;
                try {
                    projection = this.createProjection(frame, vp8Packet, result.isReset(), receivedTime);
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Failed to create frame projection", (Throwable)e);
                    frame.setAccepted(false);
                    return false;
                }
                frame.setProjection(projection);
                if (RtpUtils.isNewerSequenceNumberThan((int)projection.getEarliestProjectedSequence(), (int)this.lastVP8FrameProjection.getLatestProjectedSequence())) {
                    this.lastVP8FrameProjection = projection;
                }
            }
        }
        return frame.isAccepted() && frame.getProjection().accept(vp8Packet);
    }

    private boolean checkDecodability(@NotNull VP8Frame frame) {
        VP8Frame prev;
        if (frame.isKeyframe() || frame.getTemporalLayer() <= 0) {
            return true;
        }
        VP8Frame f = frame;
        while ((prev = this.prevFrame(f)) != null) {
            if (!f.isImmediatelyAfter(prev)) {
                return true;
            }
            if (prev.isKeyframe() || prev.getTemporalLayer() <= frame.getTemporalLayer()) {
                return prev.isAccepted();
            }
            f = prev;
        }
        return true;
    }

    @NotNull
    private VP8FrameProjection createProjection(@NotNull VP8Frame frame, @NotNull Vp8Packet initialPacket, boolean isReset, @Nullable Instant receivedTime) {
        if (this.frameIsNewSsrc(frame)) {
            return this.createLayerSwitchProjection(frame, initialPacket, receivedTime);
        }
        if (isReset) {
            return this.createResetProjection(frame, initialPacket, receivedTime);
        }
        return this.createInLayerProjection(frame, initialPacket, receivedTime);
    }

    @NotNull
    private VP8FrameProjection createLayerSwitchProjection(@NotNull VP8Frame frame, @NotNull Vp8Packet initialPacket, @Nullable Instant receivedTime) {
        int tl0PicIdx;
        int picId;
        assert (frame.isKeyframe());
        assert (initialPacket.isStartOfFrame());
        int projectedSeqGap = 1;
        if (this.lastVP8FrameProjection.getVP8Frame() != null && !this.lastVP8FrameProjection.getVP8Frame().hasSeenEndOfFrame()) {
            ++projectedSeqGap;
            this.lastVP8FrameProjection.close();
        }
        int projectedSeq = RtpUtils.applySequenceNumberDelta((int)this.lastVP8FrameProjection.getLatestProjectedSequence(), (int)projectedSeqGap);
        long tsDelta = receivedTime != null && this.lastVP8FrameProjection.getCreated() != null ? 3000L * Math.max(1L, Duration.between(this.lastVP8FrameProjection.getCreated(), receivedTime).dividedBy(33L).toMillis()) : 3000L;
        long projectedTs = RtpUtils.applyTimestampDelta((long)this.lastVP8FrameProjection.getTimestamp(), (long)tsDelta);
        if (this.lastVP8FrameProjection.getVP8Frame() != null) {
            picId = VpxUtils.applyExtendedPictureIdDelta((int)this.lastVP8FrameProjection.getPictureId(), (int)1);
            tl0PicIdx = VpxUtils.applyTl0PicIdxDelta((int)this.lastVP8FrameProjection.getTl0PICIDX(), (int)1);
        } else {
            picId = frame.getPictureId();
            tl0PicIdx = frame.getTl0PICIDX();
        }
        VP8FrameProjection projection = new VP8FrameProjection(this.diagnosticContext, frame, this.lastVP8FrameProjection.getSSRC(), projectedTs, RtpUtils.getSequenceNumberDelta((int)projectedSeq, (int)initialPacket.getSequenceNumber()), picId, tl0PicIdx, receivedTime);
        return projection;
    }

    @NotNull
    private VP8FrameProjection createResetProjection(@NotNull VP8Frame frame, @NotNull Vp8Packet initialPacket, @Nullable Instant receivedTime) {
        VP8Frame lastFrame = this.lastVP8FrameProjection.getVP8Frame();
        int seqDelta = RtpUtils.getSequenceNumberDelta((int)this.lastVP8FrameProjection.getLatestProjectedSequence(), (int)lastFrame.getLatestKnownSequenceNumber());
        long tsDelta = RtpUtils.getTimestampDiff((long)this.lastVP8FrameProjection.getTimestamp(), (long)lastFrame.getTimestamp());
        int picIdDelta = VpxUtils.getExtendedPictureIdDelta((int)this.lastVP8FrameProjection.getPictureId(), (int)lastFrame.getPictureId());
        int tl0PicIdxDelta = VpxUtils.getTl0PicIdxDelta((int)this.lastVP8FrameProjection.getTl0PICIDX(), (int)lastFrame.getTl0PICIDX());
        long projectedTs = RtpUtils.applyTimestampDelta((long)frame.getTimestamp(), (long)tsDelta);
        int projectedPicId = VpxUtils.applyExtendedPictureIdDelta((int)frame.getPictureId(), (int)picIdDelta);
        int projectedTl0PicIdx = VpxUtils.applyTl0PicIdxDelta((int)frame.getTl0PICIDX(), (int)tl0PicIdxDelta);
        VP8FrameProjection projection = new VP8FrameProjection(this.diagnosticContext, frame, this.lastVP8FrameProjection.getSSRC(), projectedTs, seqDelta, projectedPicId, projectedTl0PicIdx, receivedTime);
        return projection;
    }

    @NotNull
    private VP8FrameProjection createInLayerProjection(@NotNull VP8Frame frame, @NotNull VP8Frame refFrame, @NotNull Vp8Packet initialPacket, @Nullable Instant receivedTime) {
        int refSeq;
        long tsGap = RtpUtils.getTimestampDiff((long)frame.getTimestamp(), (long)refFrame.getTimestamp());
        int tl0Gap = VpxUtils.getTl0PicIdxDelta((int)frame.getTl0PICIDX(), (int)refFrame.getTl0PICIDX());
        int seqGap = 0;
        int picGap = 0;
        VP8Frame f1 = refFrame;
        int picIdDelta = VpxUtils.getExtendedPictureIdDelta((int)refFrame.getPictureId(), (int)frame.getPictureId());
        if (picIdDelta < 0) {
            VP8Frame f2;
            do {
                if ((f2 = this.nextFrame(f1)) == null) {
                    throw new IllegalStateException("No next frame found after frame with picId " + f1.getPictureId() + ", even though refFrame " + refFrame.getPictureId() + " is before frame " + frame.getPictureId() + "!");
                }
                seqGap += this.seqGap(f1, f2);
                picGap += this.picGap(f1, f2);
                f1 = f2;
            } while (f2 != frame);
            refSeq = refFrame.getProjection().getLatestProjectedSequence();
        } else {
            VP8Frame f2;
            do {
                if ((f2 = this.prevFrame(f1)) == null) {
                    throw new IllegalStateException("No previous frame found before frame with picId " + f1.getPictureId() + ", even though refFrame " + refFrame.getPictureId() + " is after frame " + frame.getPictureId() + "!");
                }
                seqGap += -this.seqGap(f2, f1);
                picGap += -this.picGap(f2, f1);
                f1 = f2;
            } while (f2 != frame);
            refSeq = refFrame.getProjection().getEarliestProjectedSequence();
        }
        int projectedSeq = RtpUtils.applySequenceNumberDelta((int)refSeq, (int)seqGap);
        long projectedTs = RtpUtils.applyTimestampDelta((long)refFrame.getProjection().getTimestamp(), (long)tsGap);
        int projectedPicId = VpxUtils.applyExtendedPictureIdDelta((int)refFrame.getProjection().getPictureId(), (int)picGap);
        int projectedTl0PicIdx = VpxUtils.applyTl0PicIdxDelta((int)refFrame.getProjection().getTl0PICIDX(), (int)tl0Gap);
        VP8FrameProjection projection = new VP8FrameProjection(this.diagnosticContext, frame, this.lastVP8FrameProjection.getSSRC(), projectedTs, RtpUtils.getSequenceNumberDelta((int)projectedSeq, (int)initialPacket.getSequenceNumber()), projectedPicId, projectedTl0PicIdx, receivedTime);
        return projection;
    }

    @NotNull
    private VP8FrameProjection createInLayerProjection(@NotNull VP8Frame frame, @NotNull Vp8Packet initialPacket, @Nullable Instant receivedTime) {
        VP8Frame prevFrame = this.findPrevAcceptedFrame(frame);
        if (prevFrame != null) {
            return this.createInLayerProjection(frame, prevFrame, initialPacket, receivedTime);
        }
        VP8Frame nextFrame = this.findNextAcceptedFrame(frame);
        if (nextFrame != null) {
            return this.createInLayerProjection(frame, nextFrame, initialPacket, receivedTime);
        }
        return this.createInLayerProjection(frame, this.lastVP8FrameProjection.getVP8Frame(), initialPacket, receivedTime);
    }

    @Override
    public boolean needsKeyframe() {
        if (this.vp8QualityFilter.needsKeyframe()) {
            return true;
        }
        return this.lastVP8FrameProjection.getVP8Frame() == null;
    }

    @Override
    public boolean rewriteRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        VP8FrameProjection lastVP8FrameProjectionCopy = this.lastVP8FrameProjection;
        if (lastVP8FrameProjectionCopy.getVP8Frame() == null || rtcpSrPacket.getSenderSsrc() != lastVP8FrameProjectionCopy.getVP8Frame().getSsrc()) {
            return false;
        }
        rtcpSrPacket.setSenderSsrc(lastVP8FrameProjectionCopy.getSSRC());
        long srcTs = rtcpSrPacket.getSenderInfo().getRtpTimestamp();
        long delta = RtpUtils.getTimestampDiff((long)lastVP8FrameProjectionCopy.getTimestamp(), (long)lastVP8FrameProjectionCopy.getVP8Frame().getTimestamp());
        long dstTs = RtpUtils.applyTimestampDelta((long)srcTs, (long)delta);
        if (srcTs != dstTs) {
            rtcpSrPacket.getSenderInfo().setRtpTimestamp(dstTs);
        }
        return true;
    }

    @Override
    public RtpState getRtpState() {
        return new RtpState(this.lastVP8FrameProjection.getSSRC(), this.lastVP8FrameProjection.getLatestProjectedSequence(), this.lastVP8FrameProjection.getTimestamp());
    }

    @Override
    public void rewriteRtp(@NotNull PacketInfo packetInfo) throws RewriteException {
        if (!(packetInfo.getPacket() instanceof Vp8Packet)) {
            this.logger.info((Object)"Got a non-VP8 packet.");
            throw new RewriteException("Non-VP8 packet in VP8 source projection");
        }
        Vp8Packet vp8Packet = (Vp8Packet)packetInfo.packetAs();
        if (vp8Packet.getPictureId() == -1) {
            this.logger.info((Object)"VP8 packet does not have picture ID, cannot track in frame map.");
            throw new RewriteException("VP8 packet without picture ID in VP8 source projection");
        }
        VP8Frame vp8Frame = this.lookupVP8Frame(vp8Packet);
        if (vp8Frame == null) {
            throw new RewriteException("Frame not in tracker (aged off?)");
        }
        if (vp8Frame.getProjection() == null) {
            throw new RewriteException("Frame does not have projection?");
        }
        vp8Frame.getProjection().rewriteRtp(vp8Packet);
    }

    @Override
    public synchronized JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        debugState.put((Object)"class", (Object)VP8AdaptiveSourceProjectionContext.class.getSimpleName());
        JSONArray mapSizes = new JSONArray();
        for (Map.Entry<Long, VP8FrameMap> entry : this.vp8FrameMaps.entrySet()) {
            JSONObject sizeInfo = new JSONObject();
            sizeInfo.put((Object)"ssrc", (Object)entry.getKey());
            sizeInfo.put((Object)"size", (Object)entry.getValue().size());
            mapSizes.add((Object)sizeInfo);
        }
        debugState.put((Object)"vp8FrameMaps", (Object)mapSizes);
        debugState.put((Object)"vp8QualityFilter", (Object)this.vp8QualityFilter.getDebugState());
        return debugState;
    }
}

