/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.colibri2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.colibri2.Colibri2ConferenceHandlerKt;
import org.jitsi.videobridge.colibri2.Colibri2UtilKt;
import org.jitsi.videobridge.colibri2.FeatureNotImplementedException;
import org.jitsi.videobridge.colibri2.IqProcessingException;
import org.jitsi.videobridge.colibri2.UnknownEndpointException;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.sctp.SctpConfig;
import org.jitsi.videobridge.util.PayloadTypeUtil;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;
import org.jitsi.videobridge.xmpp.MediaSourceFactory;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Endpoint;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Relay;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifyIQ;
import org.jitsi.xmpp.extensions.colibri2.Connects;
import org.jitsi.xmpp.extensions.colibri2.ForceMute;
import org.jitsi.xmpp.extensions.colibri2.InitialLastN;
import org.jitsi.xmpp.extensions.colibri2.Media;
import org.jitsi.xmpp.extensions.colibri2.MediaSource;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Sources;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.PayloadTypePacketExtension;
import org.jitsi.xmpp.extensions.jingle.RTPHdrExtPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.util.ErrorUtilKt;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.IqView;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.muc.MUCRole;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u0018H\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020!H\u0002J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\fH\u0002J$\u0010&\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020(0'\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0'0\n*\u00020\u0012H\u0002J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jitsi/videobridge/colibri2/Colibri2ConferenceHandler;", "", "conference", "Lorg/jitsi/videobridge/Conference;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/videobridge/Conference;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "handleConferenceModifyIQ", "Lkotlin/Pair;", "Lorg/jivesoftware/smack/packet/IQ;", "", "conferenceModifyIQ", "Lorg/jitsi/xmpp/extensions/colibri2/ConferenceModifyIQ;", "buildFeedbackSources", "Lorg/jitsi/xmpp/extensions/colibri2/Sources;", "handleColibri2Endpoint", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Endpoint;", "c2endpoint", "ignoreUnknownEndpoints", "addSsrcAssociation", "", "endpointId", "", "ssrcAssociation", "Lorg/jitsi/nlj/util/SsrcAssociation;", "toSsrcAssociation", "Lorg/jitsi/xmpp/extensions/jingle/SourceGroupPacketExtension;", "parseAssociationType", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "toRtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "Lorg/jitsi/xmpp/extensions/jingle/RTPHdrExtPacketExtension;", "handleColibri2Relay", "Lorg/jitsi/xmpp/extensions/colibri2/Colibri2Relay;", "c2relay", "ignoreUnknownRelays", "parseSourceDescs", "", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "Lorg/jitsi/nlj/MediaSourceDesc;", "validateRequest", "iq", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nColibri2ConferenceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Colibri2ConferenceHandler.kt\norg/jitsi/videobridge/colibri2/Colibri2ConferenceHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,540:1\n1#2:541\n1#2:568\n1#2:587\n1#2:615\n1761#3,3:542\n1869#3,2:545\n1869#3,2:547\n1761#3,3:549\n1761#3,3:552\n1869#3:555\n1869#3,2:556\n1617#3,9:558\n1869#3:567\n1870#3:569\n1626#3:570\n1869#3,2:571\n1870#3:573\n774#3:574\n865#3,2:575\n1617#3,9:577\n1869#3:586\n1870#3:588\n1626#3:589\n774#3:592\n865#3,2:593\n1869#3:595\n1869#3,2:596\n1870#3:598\n1869#3,2:599\n1869#3,2:601\n1869#3:603\n1869#3:604\n1617#3,9:605\n1869#3:614\n1870#3:616\n1626#3:617\n1869#3,2:618\n1870#3:620\n1870#3:621\n1869#3:622\n1869#3,2:623\n1870#3:625\n1761#3,3:626\n37#4,2:590\n*S KotlinDebug\n*F\n+ 1 Colibri2ConferenceHandler.kt\norg/jitsi/videobridge/colibri2/Colibri2ConferenceHandler\n*L\n284#1:568\n291#1:587\n460#1:615\n98#1:542,3\n230#1:545,2\n235#1:547,2\n245#1:549,3\n248#1:552,3\n279#1:555\n280#1:556,2\n284#1:558,9\n284#1:567\n284#1:569\n284#1:570\n284#1:571,2\n279#1:573\n291#1:574\n291#1:575,2\n291#1:577,9\n291#1:586\n291#1:588\n291#1:589\n297#1:592\n297#1:593,2\n297#1:595\n298#1:596,2\n297#1:598\n427#1:599,2\n432#1:601,2\n445#1:603\n459#1:604\n460#1:605,9\n460#1:614\n460#1:616\n460#1:617\n460#1:618,2\n459#1:620\n445#1:621\n476#1:622\n483#1:623,2\n476#1:625\n513#1:626,3\n294#1:590,2\n*E\n"})
public final class Colibri2ConferenceHandler {
    @NotNull
    private final Conference conference;
    @NotNull
    private final Logger logger;

    public Colibri2ConferenceHandler(@NotNull Conference conference, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.conference = conference;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
    }

    @NotNull
    public final Pair<IQ, Boolean> handleConferenceModifyIQ(@NotNull ConferenceModifyIQ conferenceModifyIQ) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)conferenceModifyIQ, (String)"conferenceModifyIQ");
        try {
            boolean expire;
            ConferenceModifiedIQ.Builder responseBuilder;
            block22: {
                block21: {
                    boolean bl;
                    block20: {
                        boolean bl2;
                        this.validateRequest(conferenceModifyIQ);
                        boolean ignoreUnknownEndpoints = Colibri2ConferenceHandlerKt.access$shouldIgnoreUnknownEndpoints(conferenceModifyIQ);
                        ConferenceModifiedIQ.Builder builder = ConferenceModifiedIQ.builder((IqData)ConferenceModifiedIQ.Builder.createResponse((IqView)((IqView)conferenceModifyIQ)));
                        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder(...)");
                        responseBuilder = builder;
                        boolean it = bl2 = conferenceModifyIQ.getExpire();
                        boolean bl3 = false;
                        if (it) {
                            this.logger.info((Object)"Received request to expire conference.");
                        }
                        expire = bl2;
                        for (Colibri2Endpoint e : conferenceModifyIQ.getEndpoints()) {
                            Intrinsics.checkNotNull((Object)e);
                            responseBuilder.addEndpoint(this.handleColibri2Endpoint(e, ignoreUnknownEndpoints));
                        }
                        Connects connects = conferenceModifyIQ.getConnects();
                        if (connects != null) {
                            Connects it2 = connects;
                            boolean bl4 = false;
                            this.conference.setConnects(it2.getConnects());
                        }
                        for (Colibri2Relay r : conferenceModifyIQ.getRelays()) {
                            if (!RelayConfig.config.getEnabled()) {
                                throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "Octo is disabled in configuration.");
                            }
                            if (!WebsocketServiceConfig.config.getEnabled() && !SctpConfig.config.getEnabled()) {
                                this.logger.warn((Object)"Can not use a colibri2 relay, because neither SCTP nor colibri web sockets are enabled. See https://github.com/jitsi/jitsi-videobridge/blob/master/doc/relay.md");
                                throw new UnsupportedOperationException("Colibri websockets or SCTP need to be enabled to use a colibri2 relay.");
                            }
                            Intrinsics.checkNotNull((Object)r);
                            responseBuilder.addRelay(this.handleColibri2Relay(r, ignoreUnknownEndpoints));
                        }
                        if (conferenceModifyIQ.getCreate()) break block21;
                        List list = conferenceModifyIQ.getEndpoints();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEndpoints(...)");
                        Iterable $this$any$iv = list;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                Colibri2Endpoint it3 = (Colibri2Endpoint)element$iv;
                                boolean bl5 = false;
                                if (!it3.getCreate()) continue;
                                bl = true;
                                break block20;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) break block22;
                }
                responseBuilder.setSources(this.buildFeedbackSources());
            }
            if (!conferenceModifyIQ.getCreate() && this.conference.getEndpointCount() == 0 && this.conference.getRelayCount() == 0) {
                this.logger.info((Object)"All endpoints and relays removed, expiring.");
                expire = true;
            }
            pair = new Pair((Object)responseBuilder.build(), (Object)expire);
        }
        catch (UnknownEndpointException e) {
            this.logger.warn((Object)("Unknown Endpoint during processing conference-modify IQ: " + e));
            IQ error = Colibri2UtilKt.createEndpointNotFoundError((IQ)conferenceModifyIQ, e.getEndpointId());
            pair = new Pair((Object)error, (Object)false);
        }
        catch (FeatureNotImplementedException e) {
            this.logger.warn((Object)("Unsupported request (" + e.getMessage() + "): " + conferenceModifyIQ.toXML()));
            pair = new Pair((Object)Colibri2UtilKt.createFeatureNotImplementedError((IQ)conferenceModifyIQ, e.getMessage()), (Object)false);
        }
        catch (IqProcessingException e) {
            if (StanzaError.Condition.item_not_found == e.getCondition()) {
                this.logger.warn((Object)("Error processing conference-modify IQ: " + e));
            } else {
                this.logger.error((Object)("Error processing conference-modify IQ: " + e));
            }
            pair = new Pair((Object)ErrorUtilKt.createError$default((IQ)((IQ)conferenceModifyIQ), (StanzaError.Condition)e.getCondition(), (String)e.getMessage(), null, (int)8, null), (Object)false);
        }
        return pair;
    }

    /*
     * WARNING - void declaration
     */
    private final Sources buildFeedbackSources() {
        void $this$buildFeedbackSources_u24lambda_u240_u241;
        SourcePacketExtension $this$buildFeedbackSources_u24lambda_u240_u240;
        SourcePacketExtension sourcePacketExtension;
        Sources.Builder builder;
        Sources.Builder $this$buildFeedbackSources_u24lambda_u240 = builder = Sources.getBuilder();
        boolean bl = false;
        SourcePacketExtension sourcePacketExtension2 = sourcePacketExtension = new SourcePacketExtension();
        MediaSource.Builder builder2 = MediaSource.getBuilder().setType(MediaType.AUDIO).setId("jvb-a0");
        Sources.Builder builder3 = $this$buildFeedbackSources_u24lambda_u240;
        boolean bl2 = false;
        $this$buildFeedbackSources_u24lambda_u240_u240.setSSRC(this.conference.getLocalAudioSsrc());
        $this$buildFeedbackSources_u24lambda_u240_u240.setName("jvb-a0");
        Unit unit = Unit.INSTANCE;
        builder3.addMediaSource(builder2.addSource(sourcePacketExtension).build());
        $this$buildFeedbackSources_u24lambda_u240_u240 = sourcePacketExtension = new SourcePacketExtension();
        builder2 = MediaSource.getBuilder().setType(MediaType.VIDEO).setId("jvb-v0");
        builder3 = $this$buildFeedbackSources_u24lambda_u240;
        boolean bl3 = false;
        $this$buildFeedbackSources_u24lambda_u240_u241.setSSRC(this.conference.getLocalVideoSsrc());
        $this$buildFeedbackSources_u24lambda_u240_u241.setName("jvb-v0");
        unit = Unit.INSTANCE;
        builder3.addMediaSource(builder2.addSource(sourcePacketExtension).build());
        Sources sources = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)sources, (String)"build(...)");
        return sources;
    }

    /*
     * WARNING - void declaration
     */
    private final Colibri2Endpoint handleColibri2Endpoint(Colibri2Endpoint c2endpoint, boolean ignoreUnknownEndpoints) throws IqProcessingException {
        Transport transport;
        boolean bl;
        boolean bl2;
        Endpoint endpoint;
        Endpoint endpoint2;
        Colibri2Endpoint.Builder respBuilder;
        block44: {
            PayloadType it;
            boolean bl3;
            Iterable $this$any$iv;
            boolean $i$f$any;
            block43: {
                Endpoint endpoint3;
                Object transport2;
                Colibri2Endpoint.Builder builder;
                Colibri2Endpoint.Builder $this$handleColibri2Endpoint_u24lambda_u240 = builder = Colibri2Endpoint.getBuilder();
                boolean bl4 = false;
                $this$handleColibri2Endpoint_u24lambda_u240.setId(c2endpoint.getId());
                Colibri2Endpoint.Builder builder2 = builder;
                Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
                respBuilder = builder2;
                if (c2endpoint.getExpire()) {
                    Endpoint endpoint4 = this.conference.getLocalEndpoint(c2endpoint.getId());
                    if (endpoint4 != null) {
                        endpoint4.expire();
                    }
                    respBuilder.setExpire(true);
                    Colibri2Endpoint colibri2Endpoint = respBuilder.build();
                    Intrinsics.checkNotNullExpressionValue((Object)colibri2Endpoint, (String)"build(...)");
                    return colibri2Endpoint;
                }
                if (c2endpoint.getCreate()) {
                    if (this.conference.getLocalEndpoint(c2endpoint.getId()) != null) {
                        throw new IqProcessingException(StanzaError.Condition.conflict, "Endpoint with ID " + c2endpoint.getId() + " already exists");
                    }
                    Transport transport3 = c2endpoint.getTransport();
                    if (transport3 == null) {
                        throw new IqProcessingException(StanzaError.Condition.bad_request, "Attempt to create endpoint " + c2endpoint.getId() + " with no <transport>");
                    }
                    transport2 = transport3;
                    if (!c2endpoint.hasCapability("source-names")) {
                        throw new IqProcessingException(StanzaError.Condition.bad_request, "Source name support is mandatory.");
                    }
                    boolean ssrcRewriting = c2endpoint.hasCapability("ssrc-rewriting");
                    boolean privateAddresses = c2endpoint.hasCapability("private-address-connectivity");
                    Endpoint endpoint5 = this.conference.createLocalEndpoint(c2endpoint.getId(), transport2.getIceControlling(), ssrcRewriting, c2endpoint.getMucRole() == MUCRole.visitor, privateAddresses);
                    Iterator $this$handleColibri2Endpoint_u24lambda_u241 = endpoint5;
                    boolean bl5 = false;
                    String string = c2endpoint.getStatsId();
                    if (string != null) {
                        String it2 = string;
                        boolean bl6 = false;
                        ((AbstractEndpoint)((Object)$this$handleColibri2Endpoint_u24lambda_u241)).setStatsId(it2);
                    }
                    Sctp sctp = transport2.getSctp();
                    if (sctp != null) {
                        Sctp sctp2 = sctp;
                        boolean bl7 = false;
                        if (!SctpConfig.config.getEnabled()) {
                            throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "SCTP support is not configured");
                        }
                        if (sctp2.getRole() != null && sctp2.getRole() != Sctp.Role.SERVER) {
                            throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "Unsupported SCTP role: " + sctp2.getRole());
                        }
                        if (sctp2.getPort() != null) {
                            Integer n = sctp2.getPort();
                            int n2 = 5000;
                            if (n == null || n != n2) {
                                throw new IqProcessingException(StanzaError.Condition.bad_request, "Specific SCTP port requested, not supported.");
                            }
                        }
                        ((Endpoint)((Object)$this$handleColibri2Endpoint_u24lambda_u241)).createSctpConnection();
                    }
                    endpoint3 = endpoint5;
                } else {
                    endpoint3 = endpoint2 = this.conference.getLocalEndpoint(c2endpoint.getId());
                }
                if (endpoint2 == null) {
                    if (ignoreUnknownEndpoints) {
                        Colibri2Endpoint colibri2Endpoint = respBuilder.build();
                        Intrinsics.checkNotNullExpressionValue((Object)colibri2Endpoint, (String)"build(...)");
                        return colibri2Endpoint;
                    }
                    String string = c2endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    throw new UnknownEndpointException(string);
                }
                for (Media media : c2endpoint.getMedia()) {
                    PayloadType it3;
                    List list = media.getPayloadTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPayloadTypes(...)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PayloadTypePacketExtension ptExt = (PayloadTypePacketExtension)element$iv;
                        boolean bl8 = false;
                        Intrinsics.checkNotNull((Object)ptExt);
                        MediaType mediaType = media.getType();
                        Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"getType(...)");
                        if (PayloadTypeUtil.Companion.create(ptExt, mediaType) != null) {
                            boolean bl9 = false;
                            endpoint2.addPayloadType(it3);
                            continue;
                        }
                        this.logger.warn((Object)("Ignoring unrecognized payload type extension: " + ptExt.toXML()));
                    }
                    List list2 = media.getRtpHdrExts();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRtpHdrExts(...)");
                    $this$forEach$iv = list2;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RTPHdrExtPacketExtension rtpHdrExt = (RTPHdrExtPacketExtension)element$iv;
                        boolean bl10 = false;
                        Intrinsics.checkNotNull((Object)rtpHdrExt);
                        if (this.toRtpExtension(rtpHdrExt) != null) {
                            boolean bl11 = false;
                            endpoint2.addRtpExtension((RtpExtension)it3);
                            continue;
                        }
                        this.logger.warn((Object)("Ignoring unrecognized RTP header extension: " + rtpHdrExt.toXML()));
                    }
                    endpoint2.setExtmapAllowMixed(media.getExtmapAllowMixed() != null);
                }
                transport2 = endpoint2.getTransceiver().getReadOnlyStreamInformationStore().getRtpPayloadTypes().values();
                endpoint = endpoint2;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (PayloadType)element$iv;
                        boolean bl12 = false;
                        if (!(it.getMediaType() == MediaType.AUDIO)) continue;
                        bl3 = true;
                        break block43;
                    }
                    bl3 = false;
                }
            }
            bl2 = bl3;
            endpoint.setAcceptAudio(bl2);
            $this$any$iv = endpoint2.getTransceiver().getReadOnlyStreamInformationStore().getRtpPayloadTypes().values();
            endpoint = endpoint2;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (PayloadType)element$iv;
                    boolean bl13 = false;
                    if (!(it.getMediaType() == MediaType.VIDEO)) continue;
                    bl = true;
                    break block44;
                }
                bl = false;
            }
        }
        bl2 = bl;
        endpoint.setAcceptVideo(bl2);
        InitialLastN initialLastN = c2endpoint.getInitialLastN();
        if (initialLastN != null) {
            int it = initialLastN.getValue();
            boolean bl14 = false;
            endpoint2.setInitialLastN(it);
        }
        if ((transport = c2endpoint.getTransport()) != null && (transport = transport.getIceUdpTransport()) != null) {
            Transport it = transport;
            boolean bl15 = false;
            endpoint2.setTransportInfo((IceUdpTransportPacketExtension)it);
        }
        if (c2endpoint.getCreate()) {
            Transport.Builder builder = Transport.getBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"getBuilder(...)");
            Transport.Builder transBuilder = builder;
            transBuilder.setIceUdpExtension(endpoint2.describeTransport());
            Transport transport4 = c2endpoint.getTransport();
            if ((transport4 != null ? transport4.getSctp() : null) != null) {
                transBuilder.setSctp(new Sctp.Builder().setPort(5000).setRole(Sctp.Role.SERVER).build());
            }
            respBuilder.setTransport(transBuilder.build());
        }
        Sources sources = c2endpoint.getSources();
        if (sources != null) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object it;
            void $this$filterTo$iv$iv2;
            Sources sources2 = sources;
            boolean bl16 = false;
            if (endpoint2.getVisitor()) {
                List list = sources2.getMediaSources();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMediaSources(...)");
                if (!((Collection)list).isEmpty()) {
                    throw new IqProcessingException(StanzaError.Condition.bad_request, "Attempt to set sources for visitor endpoint " + c2endpoint.getId());
                }
            }
            List list = sources2.getMediaSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMediaSources(...)");
            Iterable $this$forEach$iv2 = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                Iterator $this$mapNotNullTo$iv$iv2;
                MediaSource mediaSource = (MediaSource)element$iv;
                boolean bl17 = false;
                List list3 = mediaSource.getSources();
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getSources(...)");
                Iterable $this$forEach$iv3 = list3;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    SourcePacketExtension it4 = (SourcePacketExtension)element$iv2;
                    boolean bl18 = false;
                    long l = it4.getSSRC();
                    MediaType mediaType = mediaSource.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"getType(...)");
                    endpoint2.addReceiveSsrc(l, mediaType);
                }
                List list4 = mediaSource.getSsrcGroups();
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getSsrcGroups(...)");
                Iterable $this$mapNotNull$iv2 = list4;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                boolean $i$f$forEach3 = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    SsrcAssociation it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl19 = false;
                    SourceGroupPacketExtension it5 = (SourceGroupPacketExtension)element$iv$iv;
                    boolean bl20 = false;
                    Intrinsics.checkNotNull((Object)it5);
                    if (this.toSsrcAssociation(it5) == null) continue;
                    boolean bl21 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv2 = (List)destination$iv$iv;
                $i$f$forEach2 = false;
                $this$mapNotNullTo$iv$iv2 = $this$forEach$iv3.iterator();
                while ($this$mapNotNullTo$iv$iv2.hasNext()) {
                    Object element$iv2;
                    element$iv2 = $this$mapNotNullTo$iv$iv2.next();
                    SsrcAssociation it6 = (SsrcAssociation)element$iv2;
                    boolean bl22 = false;
                    this.addSsrcAssociation(endpoint2.getId(), it6);
                }
            }
            List list5 = sources2.getMediaSources();
            Intrinsics.checkNotNullExpressionValue((Object)list5, (String)"getMediaSources(...)");
            Iterable $this$filter$iv = list5;
            boolean $i$f$filter = false;
            Iterable element$iv = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (MediaSource)element$iv$iv;
                boolean bl23 = false;
                if (!(it.getType() == MediaType.VIDEO)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv2 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach4 = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                MediaSourceDesc it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl24 = false;
                MediaSource it7 = (MediaSource)element$iv$iv;
                boolean bl25 = false;
                if (MediaSourceFactory.createMediaSource(it7.getSources(), it7.getSsrcGroups(), c2endpoint.getId(), it7.getId()) == null) continue;
                boolean bl26 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List newMediaSources = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = newMediaSources;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            endpoint2.setMediaSources(thisCollection$iv.toArray(new MediaSourceDesc[0]));
            ArrayList<AudioSourceDesc> audioSources = new ArrayList<AudioSourceDesc>();
            List list6 = sources2.getMediaSources();
            Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"getMediaSources(...)");
            Iterable $this$filter$iv2 = list6;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MediaSource it8 = (MediaSource)element$iv$iv;
                boolean bl27 = false;
                if (!(it8.getType() == MediaType.AUDIO)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$forEach5 = false;
            for (Object element$iv3 : $this$forEach$iv) {
                MediaSource it9 = (MediaSource)element$iv3;
                boolean bl28 = false;
                List list7 = it9.getSources();
                Intrinsics.checkNotNullExpressionValue((Object)list7, (String)"getSources(...)");
                Iterable $this$forEach$iv4 = list7;
                boolean $i$f$forEach6 = false;
                for (Object element$iv4 : $this$forEach$iv4) {
                    SourcePacketExtension s = (SourcePacketExtension)element$iv4;
                    boolean bl29 = false;
                    audioSources.add(new AudioSourceDesc(s.getSSRC(), c2endpoint.getId(), it9.getId()));
                }
            }
            endpoint2.setAudioSources((List<AudioSourceDesc>)audioSources);
        }
        ForceMute forceMute = c2endpoint.getForceMute();
        if (forceMute != null) {
            ForceMute it = forceMute;
            boolean bl30 = false;
            endpoint2.updateForceMute(it.getAudio(), it.getVideo());
        }
        Colibri2Endpoint colibri2Endpoint = respBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)colibri2Endpoint, (String)"build(...)");
        return colibri2Endpoint;
    }

    private final void addSsrcAssociation(String endpointId, SsrcAssociation ssrcAssociation) {
        this.conference.getEncodingsManager().addSsrcAssociation(endpointId, ssrcAssociation.getPrimarySsrc(), ssrcAssociation.getSecondarySsrc(), ssrcAssociation.getType());
    }

    private final SsrcAssociation toSsrcAssociation(SourceGroupPacketExtension $this$toSsrcAssociation) {
        if ($this$toSsrcAssociation.getSources().size() < 2) {
            this.logger.warn((Object)("Ignoring source group with <2 sources: " + $this$toSsrcAssociation.toXML()));
            return null;
        }
        String string = $this$toSsrcAssociation.getSemantics();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSemantics(...)");
        SsrcAssociationType ssrcAssociationType = this.parseAssociationType(string);
        if (ssrcAssociationType == null) {
            return null;
        }
        SsrcAssociationType type = ssrcAssociationType;
        if (type == SsrcAssociationType.SIM) {
            return null;
        }
        return (SsrcAssociation)new LocalSsrcAssociation(((SourcePacketExtension)$this$toSsrcAssociation.getSources().get(0)).getSSRC(), ((SourcePacketExtension)$this$toSsrcAssociation.getSources().get(1)).getSSRC(), type);
    }

    private final SsrcAssociationType parseAssociationType(String $this$parseAssociationType) {
        return StringsKt.equals((String)$this$parseAssociationType, (String)"FID", (boolean)true) ? SsrcAssociationType.RTX : (StringsKt.equals((String)$this$parseAssociationType, (String)"SIM", (boolean)true) ? SsrcAssociationType.SIM : (StringsKt.equals((String)$this$parseAssociationType, (String)"FEC-FR", (boolean)true) ? SsrcAssociationType.FEC : null));
    }

    private final RtpExtension toRtpExtension(RTPHdrExtPacketExtension $this$toRtpExtension) {
        String string = $this$toRtpExtension.getURI().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        RtpExtensionType rtpExtensionType = RtpExtensionType.Companion.createFromUri(string);
        if (rtpExtensionType == null) {
            return null;
        }
        RtpExtensionType type = rtpExtensionType;
        Byte by = Byte.valueOf($this$toRtpExtension.getID());
        Intrinsics.checkNotNullExpressionValue((Object)by, (String)"valueOf(...)");
        return new RtpExtension(((Number)by).byteValue(), type);
    }

    /*
     * WARNING - void declaration
     */
    private final Colibri2Relay handleColibri2Relay(Colibri2Relay c2relay, boolean ignoreUnknownRelays) throws IqProcessingException {
        Transport transport;
        Colibri2Relay.Builder builder = Colibri2Relay.getBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"getBuilder(...)");
        Colibri2Relay.Builder respBuilder = builder;
        respBuilder.setId(c2relay.getId());
        if (c2relay.getExpire()) {
            Relay relay = this.conference.getRelay(c2relay.getId());
            if (relay != null) {
                relay.expire();
            }
            respBuilder.setExpire(true);
            Colibri2Relay colibri2Relay = respBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)colibri2Relay, (String)"build(...)");
            return colibri2Relay;
        }
        Relay relay = null;
        if (c2relay.getCreate()) {
            if (this.conference.getRelay(c2relay.getId()) != null) {
                throw new IqProcessingException(StanzaError.Condition.conflict, "Relay with ID " + c2relay.getId() + " already exists");
            }
            Transport transport2 = c2relay.getTransport();
            if (transport2 == null) {
                throw new IqProcessingException(StanzaError.Condition.bad_request, "Attempt to create relay " + c2relay.getId() + " with no <transport>");
            }
            Transport transport3 = transport2;
            relay = this.conference.createRelay(c2relay.getId(), c2relay.getMeshId(), transport3.getIceControlling(), transport3.getUseUniquePort());
        } else {
            relay = this.conference.getRelay(c2relay.getId());
        }
        if (relay == null) {
            if (ignoreUnknownRelays) {
                Colibri2Relay colibri2Relay = respBuilder.build();
                Intrinsics.checkNotNullExpressionValue((Object)colibri2Relay, (String)"build(...)");
                return colibri2Relay;
            }
            throw new IqProcessingException(StanzaError.Condition.bad_request, "Unknown relay " + c2relay.getId());
        }
        Transport transport4 = c2relay.getTransport();
        if (transport4 != null && (transport4 = transport4.getSctp()) != null) {
            Transport sctp = transport4;
            boolean bl = false;
            if (!SctpConfig.config.getEnabled()) {
                throw new IqProcessingException(StanzaError.Condition.feature_not_implemented, "SCTP support is not configured");
            }
            if (sctp.getPort() != null) {
                Integer n = sctp.getPort();
                int n2 = 5000;
                if (n == null || n != n2) {
                    throw new IqProcessingException(StanzaError.Condition.bad_request, "Specific SCTP port requested, not supported.");
                }
            }
            relay.createSctpConnection((Sctp)sctp);
        }
        if ((transport = c2relay.getTransport()) != null && (transport = transport.getIceUdpTransport()) != null) {
            Transport it = transport;
            boolean bl = false;
            relay.setTransportInfo((IceUdpTransportPacketExtension)it);
        }
        if (c2relay.getCreate()) {
            Transport.Builder builder2 = Transport.getBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"getBuilder(...)");
            Transport.Builder transBuilder = builder2;
            transBuilder.setIceUdpExtension(relay.describeTransport());
            Transport transport5 = c2relay.getTransport();
            if (transport5 != null && (transport5 = transport5.getSctp()) != null) {
                Transport it = transport5;
                boolean bl = false;
                Sctp.Role role = it.getRole() == Sctp.Role.CLIENT ? Sctp.Role.SERVER : Sctp.Role.CLIENT;
                transBuilder.setSctp(new Sctp.Builder().setPort(5000).setRole(role).build());
            }
            respBuilder.setTransport(transBuilder.build());
        }
        for (Object e : c2relay.getMedia()) {
            PayloadType it;
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Media media = (Media)e;
            List list = media.getPayloadTypes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPayloadTypes(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PayloadTypePacketExtension ptExt = (PayloadTypePacketExtension)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)ptExt);
                MediaType mediaType = media.getType();
                Intrinsics.checkNotNullExpressionValue((Object)mediaType, (String)"getType(...)");
                if (PayloadTypeUtil.Companion.create(ptExt, mediaType) != null) {
                    boolean bl2 = false;
                    relay.addPayloadType(it);
                    continue;
                }
                this.logger.warn((Object)("Ignoring unrecognized payload type extension: " + ptExt.toXML()));
            }
            List list2 = media.getRtpHdrExts();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getRtpHdrExts(...)");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RTPHdrExtPacketExtension rtpHdrExt = (RTPHdrExtPacketExtension)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)rtpHdrExt);
                if (this.toRtpExtension(rtpHdrExt) != null) {
                    boolean bl3 = false;
                    relay.addRtpExtension((RtpExtension)it);
                    continue;
                }
                this.logger.warn((Object)("Ignoring unrecognized RTP header extension: " + rtpHdrExt.toXML()));
            }
            relay.setExtmapAllowMixed(media.getExtmapAllowMixed() != null);
        }
        Set newEndpoints = new LinkedHashSet();
        Object object = c2relay.getEndpoints();
        if (object != null && (object = object.getEndpoints()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object2;
                Colibri2Endpoint endpoint = (Colibri2Endpoint)element$iv;
                boolean bl = false;
                if (endpoint.getExpire()) {
                    String string = endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    relay.removeRemoteEndpoint(string);
                    continue;
                }
                Intrinsics.checkNotNull((Object)endpoint);
                Pair<List<AudioSourceDesc>, List<MediaSourceDesc>> sources = this.parseSourceDescs(endpoint);
                if (endpoint.getCreate()) {
                    String string = endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    if (relay.addRemoteEndpoint(string, endpoint.getStatsId(), (Collection)sources.getFirst(), (Collection)sources.getSecond()) != null) {
                        RelayedEndpoint it;
                        boolean bl4 = false;
                        newEndpoints.add(it);
                    }
                } else {
                    String string = endpoint.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    relay.updateRemoteEndpoint(string, (Collection)sources.getFirst(), (Collection)sources.getSecond());
                }
                if ((object2 = endpoint.getSources()) == null || (object2 = object2.getMediaSources()) == null) continue;
                Iterable $this$forEach$iv2 = (Iterable)object2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    void $this$forEach$iv3;
                    void $this$mapNotNullTo$iv$iv;
                    MediaSource mediaSource = (MediaSource)element$iv2;
                    boolean bl5 = false;
                    List list = mediaSource.getSsrcGroups();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSsrcGroups(...)");
                    Iterable $this$mapNotNull$iv = list;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        SsrcAssociation it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl6 = false;
                        SourceGroupPacketExtension it = (SourceGroupPacketExtension)element$iv$iv;
                        boolean bl7 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (this.toSsrcAssociation(it) == null) continue;
                        boolean bl8 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        SsrcAssociation it = (SsrcAssociation)element$iv3;
                        boolean bl9 = false;
                        String string = endpoint.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        this.addSsrcAssociation(string, it);
                    }
                }
            }
        }
        this.conference.addEndpoints(newEndpoints);
        Colibri2Relay colibri2Relay = respBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)colibri2Relay, (String)"build(...)");
        return colibri2Relay;
    }

    private final Pair<List<AudioSourceDesc>, List<MediaSourceDesc>> parseSourceDescs(Colibri2Endpoint $this$parseSourceDescs) {
        List videoSources;
        List audioSources;
        block5: {
            audioSources = new ArrayList();
            videoSources = new ArrayList();
            Sources sources = $this$parseSourceDescs.getSources();
            if (sources == null) break block5;
            Sources it = sources;
            boolean bl = false;
            List list = it.getMediaSources();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMediaSources(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaSource m = (MediaSource)element$iv;
                boolean bl2 = false;
                if (m.getType() == MediaType.AUDIO) {
                    if (m.getSources().isEmpty()) {
                        this.logger.warn((Object)("Ignoring audio source " + m.getId() + " in endpoint " + $this$parseSourceDescs.getId() + " of a relay (no SSRCs): " + $this$parseSourceDescs.toXML()));
                        continue;
                    }
                    List list2 = m.getSources();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSources(...)");
                    Iterable $this$forEach$iv2 = list2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        SourcePacketExtension it2 = (SourcePacketExtension)element$iv2;
                        boolean bl3 = false;
                        audioSources.add(new AudioSourceDesc(it2.getSSRC(), $this$parseSourceDescs.getId(), m.getId()));
                    }
                    continue;
                }
                if (m.getType() == MediaType.VIDEO) {
                    MediaSourceDesc desc = MediaSourceFactory.createMediaSource(m.getSources(), m.getSsrcGroups(), $this$parseSourceDescs.getId(), m.getId());
                    if (desc == null) continue;
                    videoSources.add(desc);
                    continue;
                }
                this.logger.warn((Object)("Ignoring source " + m.getId() + " in endpoint " + $this$parseSourceDescs.getId() + " of a relay: unsupported type " + m.getType()));
            }
        }
        return new Pair((Object)audioSources, (Object)videoSources);
    }

    private final void validateRequest(ConferenceModifyIQ iq) throws FeatureNotImplementedException {
        if (iq.getEndpoints().size() > 0 && iq.getRelays().size() > 0) {
            throw new FeatureNotImplementedException("Using both 'relay' and 'endpoint' in a request");
        }
        if (iq.getEndpoints().size() > 1) {
            boolean bl;
            block7: {
                List list = iq.getEndpoints();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEndpoints(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Colibri2Endpoint it = (Colibri2Endpoint)element$iv;
                        boolean bl2 = false;
                        if (!(it.getCreate() || it.getMedia().size() > 0 || it.getTransport() != null || it.getSources() != null)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new FeatureNotImplementedException("Creating or updating media, sources or transport for more than one endpoint in a request.");
            }
        }
        if (iq.getRelays().size() > 1) {
            throw new FeatureNotImplementedException("Updating more than one 'relay' in a request.");
        }
    }
}

