/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.srtp;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.srtp.AbstractSrtpTransformer;
import org.jitsi.rtp.rtcp.RtcpHeader;
import org.jitsi.srtp.SrtcpCryptoContext;
import org.jitsi.srtp.SrtpContextFactory;
import org.jitsi.utils.logging2.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/nlj/srtp/SrtcpTransformer;", "Lorg/jitsi/nlj/srtp/AbstractSrtpTransformer;", "Lorg/jitsi/srtp/SrtcpCryptoContext;", "contextFactory", "Lorg/jitsi/srtp/SrtpContextFactory;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/srtp/SrtpContextFactory;Lorg/jitsi/utils/logging2/Logger;)V", "deriveContext", "ssrc", "", "index", "getContext", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "jitsi-media-transform"})
public abstract class SrtcpTransformer
extends AbstractSrtpTransformer<SrtcpCryptoContext> {
    public SrtcpTransformer(@NotNull SrtpContextFactory contextFactory, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)contextFactory, (String)"contextFactory");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(contextFactory, logger);
    }

    @Override
    @Nullable
    protected SrtcpCryptoContext deriveContext(long ssrc, long index) {
        SrtcpCryptoContext srtcpCryptoContext = this.getContextFactory().deriveControlContext((int)ssrc);
        if (srtcpCryptoContext == null) {
            srtcpCryptoContext = null;
        }
        return srtcpCryptoContext;
    }

    @Override
    @Nullable
    protected SrtcpCryptoContext getContext(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        byte[] byArray = packetInfo.getPacket().getBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBuffer(...)");
        long senderSsrc = RtcpHeader.Companion.getSenderSsrc(byArray, packetInfo.getPacket().getOffset());
        return (SrtcpCryptoContext)this.getContext(senderSsrc, 0L);
    }
}

