/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.io;

import java.util.StringTokenizer;

import blues.Blob;
import blues.Server;

public class BluesDir extends FsDir {

    public BluesDir(String path, String nativePath) {
        setPath(path, nativePath);
    }

    public BluesDir(FsDir parent, String name, String nativePath) {
        setPath(parent, name, nativePath);
    }

    @Override
    protected void populateEntries() {
        Blob request = new Blob(53);
        request.strings = new String[] { getNativePath() };
        Blob response = Server.callRequest(request);
        if (response == null) {
            return;
        }
        StringTokenizer sk = new StringTokenizer(response.strings[0], ":", false);
        while (sk.hasMoreTokens()) {
            char type = sk.nextToken().charAt(0);
            String name = sk.nextToken();
            String nativePath = null;
            if ((type == 'N') || (type == 'F')) {
                nativePath = sk.nextToken();
            }
            createEntry(type, name, nativePath);
        }
    }

    private void createEntry(char type, String name, String nativePath) {
        FsObject entry = null;
        switch (type) {
        case 'D':
            entry = new BluesDir(this, name, null);
            break;
        case 'N':
            entry = new BluesDir(this, name, nativePath);
            break;
        case 'R':
            entry = new BluesFile(this, name, null);
            break;
        case 'F':
            entry = new BluesFile(this, name, nativePath);
            break;
        }
        if (entry != null) {
            entries.put(name, entry);
        }
    }

    @Override
    protected void populateAttributes() {
        accessFlags = ACCESS_READ;

        Blob request = new Blob(50);
        request.strings = new String[] { getNativePath() };
        request.args = new int[] { 0 };
        Blob response = Server.callRequest(request);
        if (response == null) {
            return;
        }
        lastModifiedTime = response.getLong(0);
    }

    @Override
    protected boolean deleteObject(FsObject obj) {
        return false;
    }

    @Override
    protected FsDir createDirectoryObject(String name) {
        return null;
    }

    @Override
    protected FsFile createFileObject(String name) {
        return null;
    }

    @Override
    public void closeThis() {
    }

}
