/*
    BLUES - BD-Java emulation server

    Copyright (C) 2007-2025 GuinpinSoft inc <blues@makemkv.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

*/
package impl.java.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class UrlStreamHandlerPeer extends URLStreamHandler {

    private static UrlStreamHandlerPeer instance = null;

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return null;
    }

    public static synchronized UrlStreamHandlerPeer getInstance() {
        if (instance == null) {
            instance = new UrlStreamHandlerPeer();
        }
        return instance;
    }

    public static URL createPeerURL(final String protocol, final String host, final int port, String authority, String userInfo,
            String path, String query, String ref) {
        URL u;

        u = (URL)AccessController.doPrivileged(new PrivilegedAction(){
            public Object run() {
                try {
                    return new URL(protocol, host, port, "file", getInstance());
                } catch (MalformedURLException e) {
                    return null;
                }
            }
        });
        if (u==null) {
            blues.Log.unimplemented();
            return null;
        }

        getInstance().setURL(u, protocol, host, port, authority, userInfo, path, query, ref);

        return u;
    }
}
