/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.downloader.request;

import com.github.kiulian.downloader.downloader.YoutubeCallback;
import com.github.kiulian.downloader.downloader.client.ClientType;
import com.github.kiulian.downloader.downloader.client.Clients;
import com.github.kiulian.downloader.downloader.proxy.ProxyAuthenticator;
import com.github.kiulian.downloader.downloader.proxy.ProxyCredentialsImpl;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public abstract class Request<T extends Request<T, S>, S> {
    protected Map<String, String> headers;
    private YoutubeCallback<S> callback;
    private boolean async;
    private Integer maxRetries;
    private Proxy proxy;
    private ClientType clientType = Clients.highestPriorityClientType();

    public T proxy(String string, int n) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        return (T)this;
    }

    public T proxy(String string, int n, String string2, String string3) {
        if (ProxyAuthenticator.getDefault() == null) {
            ProxyAuthenticator.setDefault(new ProxyAuthenticator(new ProxyCredentialsImpl()));
        }
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        ProxyAuthenticator.addAuthentication(string, n, string2, string3);
        return (T)this;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public T maxRetries(int n) {
        this.maxRetries = n;
        return (T)this;
    }

    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public T callback(YoutubeCallback<S> youtubeCallback) {
        this.callback = youtubeCallback;
        return (T)this;
    }

    public YoutubeCallback<S> getCallback() {
        return this.callback;
    }

    public T header(String string, String string2) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(string, string2);
        return (T)this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public T async() {
        this.async = true;
        return (T)this;
    }

    public boolean isAsync() {
        return this.async;
    }

    public T clientType(ClientType clientType) {
        this.clientType = clientType;
        return (T)this;
    }

    public ClientType getClientType() {
        return this.clientType;
    }
}

