/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.movieobject;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.tinymediamanager.library.bluray.movieobject.ExtensionData;
import org.tinymediamanager.library.bluray.movieobject.MovieObjectWriter;
import org.tinymediamanager.library.bluray.movieobject.MovieObjects;
import org.tinymediamanager.library.bluray.movieobject.StringIOHelper;

@XmlRootElement
@XmlType(propOrder={"version", "movieObjects", "extensionData", "paddingsN1", "paddingsN2"})
public class MovieObjectFile {
    static final String FILETYPE = "MOBJ";
    String version;
    int padding_N1;
    int padding_N2;
    MovieObjects movieObjects = new MovieObjects();
    ExtensionData extensionData = new ExtensionData();

    public MovieObjects getMovieObjects() {
        return this.movieObjects;
    }

    public void setMovieObjects(MovieObjects movieObjects) {
        this.movieObjects = movieObjects;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public ExtensionData getExtensionData() {
        return this.extensionData;
    }

    public void setExtensionData(ExtensionData extensionData) {
        this.extensionData = extensionData;
    }

    public void setPaddingsN1(int n) {
        this.padding_N1 = n;
    }

    public int getPaddingsN1() {
        return this.padding_N1;
    }

    public void setPaddingsN2(int n) {
        this.padding_N2 = n;
    }

    public int getPaddingsN2() {
        return this.padding_N2;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        String string = StringIOHelper.readISO646String(dataInputStream, 4);
        String string2 = StringIOHelper.readISO646String(dataInputStream, 4);
        if (!FILETYPE.equals(string)) {
            throw new IOException("Type indicator mismatch, read " + string);
        }
        if (!("0100".equals(string2) || "0200".equals(string2) || "0300".equals(string2))) {
            throw new IOException("Unexpected version number read, " + string2);
        }
        this.setVersion(string2);
        int n = dataInputStream.readInt();
        dataInputStream.skipBytes(28);
        if (n == 0) {
            this.movieObjects.readObject(dataInputStream);
            int n2 = this.seekPaddings(dataInputStream);
            this.setPaddingsN1(n2);
            this.setPaddingsN2(0);
        } else {
            byte[] byArray = new byte[n - 40];
            dataInputStream.read(byArray);
            DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray));
            this.movieObjects.readObject(dataInputStream2);
            int n3 = this.seekPaddings(dataInputStream2);
            this.setPaddingsN1(n3);
            dataInputStream2.close();
            this.extensionData.readObject(dataInputStream);
            n3 = this.seekPaddings(dataInputStream);
            this.setPaddingsN2(n3);
        }
    }

    public String toXML() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            new MovieObjectWriter().writeXml(this, dataOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = new byte[28];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.write(StringIOHelper.getISO646Bytes(FILETYPE));
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getVersion()));
        this.movieObjects.writeObject(dataOutputStream2);
        for (int i = 0; i < this.getPaddingsN1(); ++i) {
            dataOutputStream2.writeShort(0);
        }
        dataOutputStream2.flush();
        dataOutputStream2.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        int n = this.extensionData.getData() == null ? 0 : byArray2.length + 40;
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray2);
        if (n != 0) {
            this.extensionData.writeObject(dataOutputStream);
            for (int i = 0; i < this.getPaddingsN2(); ++i) {
                dataOutputStream.writeShort(0);
            }
        }
    }

    private int seekPaddings(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        try {
            while (true) {
                dataInputStream.readUnsignedShort();
                ++n;
            }
        }
        catch (EOFException eOFException) {
            return n;
        }
    }
}

