/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;

public record MediaEpisodeNumber(@JsonProperty @NotNull MediaEpisodeGroup episodeGroup, @JsonProperty int season, @JsonProperty int episode) implements Comparable<MediaEpisodeNumber>
{
    public boolean isValid() {
        return this.season > -1 && this.episode > -1;
    }

    public boolean containsAnyNumber() {
        return this.season > -1 || this.episode > -1;
    }

    @Override
    public int compareTo(@NotNull MediaEpisodeNumber o) {
        int result = Integer.compare(this.season, o.season);
        if (result == 0) {
            result = Integer.compare(this.episode, o.episode);
        }
        return result;
    }
}

