/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tmdb;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.HttpException;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.IMediaIdProvider;
import org.tinymediamanager.scraper.interfaces.IRatingProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTmdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTvdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbMetadataProvider;
import org.tinymediamanager.scraper.tmdb.TmdbUtils;
import org.tinymediamanager.scraper.tmdb.entities.AppendToResponse;
import org.tinymediamanager.scraper.tmdb.entities.BaseCompany;
import org.tinymediamanager.scraper.tmdb.entities.BaseKeyword;
import org.tinymediamanager.scraper.tmdb.entities.BaseTvEpisode;
import org.tinymediamanager.scraper.tmdb.entities.BaseTvShow;
import org.tinymediamanager.scraper.tmdb.entities.CastMember;
import org.tinymediamanager.scraper.tmdb.entities.ContentRating;
import org.tinymediamanager.scraper.tmdb.entities.CrewMember;
import org.tinymediamanager.scraper.tmdb.entities.FindResults;
import org.tinymediamanager.scraper.tmdb.entities.Genre;
import org.tinymediamanager.scraper.tmdb.entities.Image;
import org.tinymediamanager.scraper.tmdb.entities.Network;
import org.tinymediamanager.scraper.tmdb.entities.Translations;
import org.tinymediamanager.scraper.tmdb.entities.TvEpisode;
import org.tinymediamanager.scraper.tmdb.entities.TvEpisodeGroup;
import org.tinymediamanager.scraper.tmdb.entities.TvEpisodeGroupEpisode;
import org.tinymediamanager.scraper.tmdb.entities.TvEpisodeGroupSeason;
import org.tinymediamanager.scraper.tmdb.entities.TvSeason;
import org.tinymediamanager.scraper.tmdb.entities.TvShow;
import org.tinymediamanager.scraper.tmdb.entities.TvShowResultsPage;
import org.tinymediamanager.scraper.tmdb.enumerations.AppendToResponseItem;
import org.tinymediamanager.scraper.tmdb.enumerations.ExternalSource;
import org.tinymediamanager.scraper.util.CacheMap;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

public class TmdbTvShowMetadataProvider
extends TmdbMetadataProvider
implements ITvShowMetadataProvider,
ITvShowTmdbMetadataProvider,
ITvShowImdbMetadataProvider,
ITvShowTvdbMetadataProvider,
IRatingProvider,
IMediaIdProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmdbTvShowMetadataProvider.class);
    private static final CacheMap<String, List<MediaMetadata>> EPISODE_LIST_CACHE_MAP = new CacheMap(600L, 5L);

    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo info = super.createMediaProviderInfo();
        info.getConfig().addBoolean("includeAdultShows", false);
        info.getConfig().addBoolean("scrapeLanguageNames", true);
        info.getConfig().addBoolean("titleFallback", false);
        info.getConfig().addSelect("titleFallbackLanguage", PT, "en-US");
        info.getConfig().load();
        return info;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public SortedSet<MediaSearchResult> search(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Response httpResponse;
        LOGGER.debug("search(): {}", (Object)options);
        this.initAPI();
        Exception savedException = null;
        TreeSet<MediaSearchResult> results = new TreeSet<MediaSearchResult>();
        String searchString = "";
        if (StringUtils.isNotEmpty((CharSequence)options.getSearchQuery())) {
            searchString = Utils.removeSortableName(options.getSearchQuery());
        }
        searchString = MetadataUtil.removeNonSearchCharacters(searchString);
        String imdbId = options.getImdbId();
        if (!MediaIdUtil.isValidImdbId(imdbId)) {
            imdbId = "";
        }
        if (MediaIdUtil.isValidImdbId(searchString)) {
            imdbId = searchString;
        }
        int tmdbId = options.getTmdbId();
        int tvdbId = options.getIdAsInt("tvdb");
        boolean adult = this.getProviderInfo().getConfig().getValueAsBool("includeAdultShows");
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        LOGGER.debug("========= BEGIN TMDB Scraper Search for: {}", (Object)searchString);
        if (tmdbId != 0) {
            LOGGER.debug("found TMDB ID {} - getting direct", (Object)tmdbId);
            try {
                httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                Iterator<BaseTvShow> show = (TvShow)httpResponse.body();
                this.injectTranslations(Locale.forLanguageTag(language), (TvShow)((Object)show));
                results.add(this.morphTvShowToSearchResult((BaseTvShow)((Object)show), options));
                LOGGER.debug("found {} results with TMDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && StringUtils.isNotEmpty((CharSequence)imdbId)) {
            LOGGER.debug("found IMDB ID {} - getting direct", (Object)imdbId);
            try {
                httpResponse = this.api.findService().find(imdbId, ExternalSource.IMDB_ID, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                for (BaseTvShow show : ((FindResults)httpResponse.body()).tv_results) {
                    this.injectTranslations(Locale.forLanguageTag(language), show);
                    results.add(this.morphTvShowToSearchResult(show, options));
                }
                LOGGER.debug("found {} results with IMDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && tvdbId > 0) {
            LOGGER.debug("found TVDB ID {} - getting direct", (Object)tvdbId);
            try {
                httpResponse = this.api.findService().find(tvdbId, ExternalSource.TVDB_ID, language).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                for (BaseTvShow show : ((FindResults)httpResponse.body()).tv_results) {
                    this.injectTranslations(options.getLanguage().toLocale(), show);
                    results.add(this.morphTvShowToSearchResult(show, options));
                }
                LOGGER.debug("found {} results with TVDB id", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.debug("problem getting data from tvdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty()) {
            try {
                Response httpResponse2;
                int page = 1;
                int maxPage = 1;
                do {
                    if (!(httpResponse2 = this.api.searchService().tv(searchString, page, language, null, adult).execute()).isSuccessful() || httpResponse2.body() == null) {
                        throw new HttpException(httpResponse2.code(), httpResponse2.message());
                    }
                    for (BaseTvShow show : ListUtils.nullSafe(((TvShowResultsPage)httpResponse2.body()).results)) {
                        this.injectTranslations(Locale.forLanguageTag(language), show);
                        results.add(this.morphTvShowToSearchResult(show, options));
                    }
                } while (++page <= (maxPage = ((TvShowResultsPage)httpResponse2.body()).total_pages.intValue()));
                LOGGER.debug("found {} results with search string", (Object)results.size());
            }
            catch (Exception e) {
                LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (results.isEmpty() && savedException != null) {
            throw new ScrapeException(savedException);
        }
        return results;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeList(): {} ", (Object)options);
        this.initAPI();
        int tmdbId = options.getTmdbId();
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, options.getImdbId());
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0 && options.getIdAsIntOrDefault("tvdb", 0) > 0) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, options.getIdAsInteger("tvdb"));
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            throw new MissingIdException(new String[]{"tmdb"});
        }
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        List<MediaMetadata> episodes = EPISODE_LIST_CACHE_MAP.get(tmdbId + "_" + language);
        if (ListUtils.isNotEmpty(episodes)) {
            return episodes;
        }
        episodes = new ArrayList<MediaMetadata>();
        try {
            Response showResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS, AppendToResponseItem.CREDITS, AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CONTENT_RATINGS, AppendToResponseItem.KEYWORDS, AppendToResponseItem.EPISODE_GROUPS)).execute();
            if (!showResponse.isSuccessful() || showResponse.body() == null) {
                throw new HttpException(showResponse.code(), showResponse.message());
            }
            HashMap<MediaEpisodeGroup, List<TvEpisodeGroupSeason>> episodeGroups = new HashMap<MediaEpisodeGroup, List<TvEpisodeGroupSeason>>();
            for (TvEpisodeGroup episodeGroup : ListUtils.nullSafe(((TvShow)showResponse.body()).episodeGroups.episodeGroups)) {
                if (episodeGroup.episodeCount == 0) continue;
                try {
                    Response episodeGroupsResponse = this.api.tvEpisodeGroupsService().episodeGroup(episodeGroup.id, language).execute();
                    if (!episodeGroupsResponse.isSuccessful() || episodeGroupsResponse.body() == null) {
                        throw new HttpException(episodeGroupsResponse.code(), episodeGroupsResponse.message());
                    }
                    MediaEpisodeGroup.EpisodeGroupType eg = this.mapEpisodeGroup(episodeGroup.type);
                    if (eg == null) continue;
                    List<TvEpisodeGroupSeason> seasons = ((TvEpisodeGroup)episodeGroupsResponse.body()).groups;
                    for (int i = seasons.size() - 1; i >= 0; --i) {
                        if (!seasons.get((int)i).episodes.isEmpty()) continue;
                        seasons.remove(i);
                    }
                    if (!seasons.isEmpty()) {
                        episodeGroups.put(new MediaEpisodeGroup(eg, episodeGroup.name), seasons);
                        continue;
                    }
                    LOGGER.debug("EpisodeGroup '{}' without episodes! {} ", (Object)((TvEpisodeGroup)episodeGroupsResponse.body()).name, (Object)((TvShow)showResponse.body()).name);
                }
                catch (Exception e) {
                    LOGGER.debug("Could not fetch episode group data - '{}'", (Object)e.getMessage());
                }
            }
            String originalLanguage = ((TvShow)showResponse.body()).original_language;
            for (TvSeason season : ListUtils.nullSafe(((TvShow)showResponse.body()).seasons)) {
                List<MediaMetadata> seasonEpisodes = this.getSeasonEpisodes(tmdbId, season.season_number, options, originalLanguage, episodeGroups);
                episodes.addAll(seasonEpisodes);
            }
        }
        catch (Exception e) {
            LOGGER.debug("failed to get episode list: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (!episodes.isEmpty()) {
            EPISODE_LIST_CACHE_MAP.put(tmdbId + "_" + language, episodes);
        }
        return episodes;
    }

    private List<MediaMetadata> getSeasonEpisodes(int tmdbId, Integer seasonNumber, TvShowSearchAndScrapeOptions options, String originalLanguage, Map<MediaEpisodeGroup, List<TvEpisodeGroupSeason>> episodeGroups) throws IOException {
        Map map;
        Map episodesInOriginalLanguage;
        MediaMetadata ep;
        Map episodesInFallbackLanguage;
        String requestedLanguage = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        TreeMap<Integer, MediaMetadata> episodesInRequestedLanguage = new TreeMap<Integer, MediaMetadata>();
        LinkedHashMap localizedEpisodeData = new LinkedHashMap();
        localizedEpisodeData.put(requestedLanguage, episodesInRequestedLanguage);
        localizedEpisodeData.putIfAbsent(originalLanguage, new HashMap());
        boolean titleFallback = this.getProviderInfo().getConfig().getValueAsBool("titleFallback");
        String fallbackLanguage = this.getProviderInfo().getConfig().getValue("titleFallbackLanguage");
        if (titleFallback) {
            localizedEpisodeData.putIfAbsent(fallbackLanguage, new HashMap());
        }
        String englishLanguage = TmdbTvShowMetadataProvider.getRequestLanguage(MediaLanguages.en);
        localizedEpisodeData.putIfAbsent(englishLanguage, new HashMap());
        Response seasonResponse = this.api.tvSeasonsService().season(tmdbId, seasonNumber, requestedLanguage, new AppendToResponse(AppendToResponseItem.CREDITS)).execute();
        if (!seasonResponse.isSuccessful()) {
            throw new HttpException(seasonResponse.code(), seasonResponse.message());
        }
        for (TvEpisode tvEpisode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
            MediaMetadata mediaMetadata = this.morphTvEpisodeToMediaMetadata(tvEpisode, (TvSeason)seasonResponse.body(), episodeGroups, options);
            episodesInRequestedLanguage.put(tvEpisode.episode_number, mediaMetadata);
        }
        if (titleFallback && (episodesInFallbackLanguage = (Map)localizedEpisodeData.get(fallbackLanguage)).isEmpty() && (seasonResponse = this.api.tvSeasonsService().season(tmdbId, seasonNumber, fallbackLanguage).execute()).isSuccessful()) {
            for (TvEpisode tvEpisode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
                ep = this.morphTvEpisodeToMediaMetadata(tvEpisode, null, null, options);
                episodesInFallbackLanguage.put(tvEpisode.episode_number, ep);
            }
        }
        if ((episodesInOriginalLanguage = (Map)localizedEpisodeData.get(originalLanguage)).isEmpty() && (seasonResponse = this.api.tvSeasonsService().season(tmdbId, seasonNumber, originalLanguage).execute()).isSuccessful()) {
            for (TvEpisode tvEpisode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
                ep = this.morphTvEpisodeToMediaMetadata(tvEpisode, null, null, options);
                episodesInOriginalLanguage.put(tvEpisode.episode_number, ep);
            }
        }
        if ((map = (Map)localizedEpisodeData.get(englishLanguage)).isEmpty() && (seasonResponse = this.api.tvSeasonsService().season(tmdbId, seasonNumber, englishLanguage).execute()).isSuccessful()) {
            for (TvEpisode episode : ListUtils.nullSafe(((TvSeason)seasonResponse.body()).episodes)) {
                MediaMetadata ep3 = this.morphTvEpisodeToMediaMetadata(episode, null, null, options);
                map.put(episode.episode_number, ep3);
            }
        }
        ArrayList<MediaMetadata> arrayList = new ArrayList<MediaMetadata>();
        for (MediaMetadata md : episodesInRequestedLanguage.values()) {
            String scrapedTitle = md.getTitle();
            int episode = md.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED).episode();
            MediaMetadata fallback = (MediaMetadata)localizedEpisodeData.getOrDefault(fallbackLanguage, Collections.emptyMap()).get(episode);
            MediaMetadata original = (MediaMetadata)localizedEpisodeData.getOrDefault(originalLanguage, Collections.emptyMap()).get(episode);
            MediaMetadata english = (MediaMetadata)localizedEpisodeData.getOrDefault(englishLanguage, Collections.emptyMap()).get(episode);
            boolean generic = this.isGenericTitle(md.getTitle());
            if (fallback != null && (generic || StringUtils.isBlank((CharSequence)md.getTitle()) && StringUtils.isNotBlank((CharSequence)fallback.getTitle()))) {
                md.setTitle(fallback.getTitle());
            }
            generic = this.isGenericTitle(md.getTitle());
            if (original != null && (generic || StringUtils.isBlank((CharSequence)md.getTitle()) && StringUtils.isNotBlank((CharSequence)original.getTitle()))) {
                md.setTitle(original.getTitle());
            }
            generic = this.isGenericTitle(md.getTitle());
            if (english != null && (generic || StringUtils.isBlank((CharSequence)md.getTitle()) && StringUtils.isNotBlank((CharSequence)english.getTitle()))) {
                md.setTitle(english.getTitle());
            }
            if (generic = this.isGenericTitle(md.getTitle())) {
                md.setTitle(scrapedTitle);
            }
            if (original != null && StringUtils.isNotBlank((CharSequence)original.getTitle())) {
                md.setOriginalTitle(original.getTitle());
                if (StringUtils.isBlank((CharSequence)md.getTitle())) {
                    md.setTitle(original.getTitle());
                }
            }
            if (english != null && StringUtils.isNotBlank((CharSequence)english.getTitle())) {
                md.setEnglishTitle(english.getTitle());
            }
            if (StringUtils.isBlank((CharSequence)md.getPlot()) && fallback != null && StringUtils.isNotBlank((CharSequence)fallback.getPlot())) {
                md.setPlot(fallback.getPlot());
            }
            if (StringUtils.isBlank((CharSequence)md.getPlot()) && original != null && StringUtils.isNotBlank((CharSequence)original.getPlot())) {
                md.setPlot(original.getPlot());
            }
            arrayList.add(md);
        }
        return arrayList;
    }

    private boolean isGenericTitle(String title) {
        title = title.replaceAll("\\d", "");
        for (String lang : EPISODE_TRANS) {
            if (!title.contains(lang)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        CountryCode countryCode;
        TvShow complete;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        int tmdbId = options.getTmdbId();
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, options.getImdbId());
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0 && options.getIdAsIntOrDefault("tvdb", 0) > 0) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, options.getIdAsInteger("tvdb"));
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        try {
            Response httpResponse = this.api.tvService().tv(tmdbId, language, new AppendToResponse(AppendToResponseItem.TRANSLATIONS, AppendToResponseItem.CREDITS, AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CONTENT_RATINGS, AppendToResponseItem.KEYWORDS, AppendToResponseItem.EPISODE_GROUPS)).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            complete = (TvShow)httpResponse.body();
            this.injectTranslations(Locale.forLanguageTag(language), complete);
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (complete == null) {
            throw new NothingFoundException();
        }
        md.setId(this.getId(), tmdbId);
        md.setTitle(complete.name);
        String englishTitle = this.getValuesFromTranslation(complete.translations, MediaLanguages.en.toLocale())[0];
        if (StringUtils.isBlank((CharSequence)englishTitle) && "en".equals(complete.original_language)) {
            englishTitle = complete.original_name;
        }
        md.setEnglishTitle(englishTitle);
        md.setOriginalTitle(complete.original_name);
        try {
            MediaRating rating = new MediaRating("tmdb");
            rating.setRating(complete.vote_average);
            rating.setVotes(complete.vote_count);
            rating.setMaxValue(10);
            md.addRating(rating);
        }
        catch (Exception e) {
            LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
        }
        md.setReleaseDate(complete.first_air_date);
        md.setPlot(complete.overview);
        for (String string : ListUtils.nullSafe(complete.origin_country)) {
            if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("scrapeLanguageNames"))) {
                md.addCountry(LanguageUtils.getLocalizedCountryForLanguage(options.getLanguage().toLocale(), string));
                continue;
            }
            md.addCountry(string);
        }
        if (complete.episode_run_time != null && !complete.episode_run_time.isEmpty()) {
            md.setRuntime(complete.episode_run_time.get(0));
        }
        if (StringUtils.isNotBlank((CharSequence)complete.poster_path)) {
            Iterator<BaseCompany> ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.POSTER);
            ((MediaArtwork)((Object)ma)).setPreviewUrl(this.artworkBaseUrl + "w342" + complete.poster_path);
            ((MediaArtwork)((Object)ma)).setOriginalUrl(this.artworkBaseUrl + "original" + complete.poster_path);
            ((MediaArtwork)((Object)ma)).setLanguage(options.getLanguage().getLanguage());
            ((MediaArtwork)((Object)ma)).setTmdbId(complete.id);
            ((MediaArtwork)((Object)ma)).addImageSize(0, 0, this.artworkBaseUrl + "original" + complete.poster_path, 0);
            md.addMediaArt((MediaArtwork)((Object)ma));
        }
        for (Network network : ListUtils.nullSafe(complete.networks)) {
            md.addProductionCompany(network.name.strip());
        }
        for (BaseCompany baseCompany : ListUtils.nullSafe(complete.production_companies)) {
            md.addProductionCompany(baseCompany.name.strip());
        }
        md.setStatus(complete.status);
        if (complete.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(complete.first_air_date);
            md.setYear(calendar.get(1));
        }
        if (complete.credits != null) {
            for (CastMember castMember : ListUtils.nullSafe(complete.credits.cast)) {
                Person cm = new Person(Person.Type.ACTOR);
                cm.setId(this.getProviderInfo().getId(), castMember.id);
                cm.setName(castMember.name);
                cm.setRole(castMember.character);
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
                }
                md.addCastMember(cm);
            }
        }
        this.parseExternalIDs(complete.external_ids).forEach(md::setId);
        if (complete.content_ratings != null && (countryCode = options.getCertificationCountry()) != null) {
            for (ContentRating country : ListUtils.nullSafe(complete.content_ratings.results)) {
                if (!StringUtils.isNotBlank((CharSequence)country.rating) || !country.iso_3166_1.equalsIgnoreCase(countryCode.getAlpha2())) continue;
                md.addCertification(MediaCertification.getCertification(country.iso_3166_1, country.rating));
            }
        }
        for (Genre genre : ListUtils.nullSafe(complete.genres)) {
            md.addGenre(TmdbMetadataProvider.getTmmGenre(genre));
        }
        md.addEpisodeGroup(MediaEpisodeGroup.DEFAULT_AIRED);
        if (complete.episodeGroups != null) {
            for (TvEpisodeGroup tvEpisodeGroup : ListUtils.nullSafe(complete.episodeGroups.episodeGroups)) {
                MediaEpisodeGroup.EpisodeGroupType eg;
                if (tvEpisodeGroup.episodeCount == 0) continue;
                try {
                    Response httpResponse = this.api.tvEpisodeGroupsService().episodeGroup(tvEpisodeGroup.id, language).execute();
                    if (!httpResponse.isSuccessful()) {
                        throw new HttpException(httpResponse.code(), httpResponse.message());
                    }
                    TvEpisodeGroup fullEG = (TvEpisodeGroup)httpResponse.body();
                    tvEpisodeGroup.groups = fullEG.groups;
                }
                catch (Exception e) {
                    LOGGER.debug("failed to get episode group details: {}", (Object)e.getMessage());
                }
                if ((eg = this.mapEpisodeGroup(tvEpisodeGroup.type)) == null) continue;
                MediaEpisodeGroup mediaEpisodeGroup = new MediaEpisodeGroup(eg, tvEpisodeGroup.name);
                md.addEpisodeGroup(mediaEpisodeGroup);
                for (TvEpisodeGroupSeason season : ListUtils.nullSafe(tvEpisodeGroup.groups)) {
                    if (!StringUtils.isNotBlank((CharSequence)season.name)) continue;
                    md.addSeasonName(mediaEpisodeGroup, season.order, season.name);
                }
            }
        }
        for (TvSeason tvSeason : ListUtils.nullSafe(complete.seasons)) {
            if (tvSeason.season_number == null) continue;
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tvSeason.name, tvSeason.overview})) {
                try {
                    Response translationsResponse = this.api.tvSeasonsService().translations(tmdbId, tvSeason.season_number).execute();
                    if (!translationsResponse.isSuccessful()) {
                        throw new HttpException(translationsResponse.code(), translationsResponse.message());
                    }
                    this.injectTranslations(Locale.forLanguageTag(language), complete, tvSeason, (Translations)translationsResponse.body());
                }
                catch (Exception e) {
                    LOGGER.debug("Could not get season translations - '{}'", (Object)e.getMessage());
                }
            }
            md.addSeasonName(MediaEpisodeGroup.DEFAULT_AIRED, tvSeason.season_number, tvSeason.name);
            md.addSeasonOverview(MediaEpisodeGroup.DEFAULT_AIRED, tvSeason.season_number, tvSeason.overview);
        }
        if (complete.keywords != null) {
            for (BaseKeyword baseKeyword : ListUtils.nullSafe(complete.keywords.keywords)) {
                md.addTag(baseKeyword.name);
            }
        }
        return md;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        Person cm;
        TvEpisode tvEpisode;
        BaseTvEpisode baseTvEpisode;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        int showTmdbId = 0;
        if (options.getIds().get("tvShowIds") instanceof Map) {
            Map tvShowIds = (Map)options.getIds().get("tvShowIds");
            showTmdbId = tvShowIds.getOrDefault("tmdb", 0);
        }
        int episodeTmdbId = options.getIdAsIntOrDefault("tmdb", 0);
        int seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
        int episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        if ((seasonNr == -1 || episodeNr == -1) && MediaIdUtil.isValidImdbId(options.getImdbId())) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByImdbId(options.getImdbId());
                if (baseTvEpisode != null) {
                    showTmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by imdb id - {}", (Object)e.getMessage());
            }
        }
        if ((seasonNr == -1 || episodeNr == -1) && options.getIds().containsKey("tvdb")) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByTvdbId(options.getIdAsInt("tvdb"));
                if (baseTvEpisode != null) {
                    showTmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (showTmdbId == 0) {
            TvShowSearchAndScrapeOptions tvShowSearchAndScrapeOptions = options.createTvShowSearchAndScrapeOptions();
            showTmdbId = tvShowSearchAndScrapeOptions.getTmdbId();
            if (showTmdbId == 0 && MediaIdUtil.isValidImdbId(tvShowSearchAndScrapeOptions.getImdbId())) {
                try {
                    showTmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, tvShowSearchAndScrapeOptions.getImdbId());
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
                }
            }
            if (showTmdbId == 0 && tvShowSearchAndScrapeOptions.getIdAsIntOrDefault("tvdb", 0) > 0) {
                try {
                    showTmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, tvShowSearchAndScrapeOptions.getIdAsInteger("tvdb"));
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
                }
            }
        }
        if (showTmdbId == 0) {
            LOGGER.debug("not possible to scrape from TMDB - no TMDB/IMDB id found");
            throw new MissingIdException("tmdb", "imdb");
        }
        MediaMetadata episodeMediaMetadata = null;
        List<MediaMetadata> episodes = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
        if (episodeTmdbId > 0) {
            for (MediaMetadata mediaMetadata : episodes) {
                if ((Integer)mediaMetadata.getId("tmdb") != episodeTmdbId) continue;
                episodeMediaMetadata = mediaMetadata;
                break;
            }
        }
        if (episodeMediaMetadata == null && seasonNr > -1 && episodeNr > -1) {
            for (MediaMetadata mediaMetadata : episodes) {
                Object episodeNumber = mediaMetadata.getEpisodeNumber(options.getEpisodeGroup());
                if (episodeNumber == null && options.getEpisodeGroup().getEpisodeGroupType() == MediaEpisodeGroup.EpisodeGroupType.AIRED) {
                    episodeNumber = mediaMetadata.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                }
                if (episodeNumber == null || seasonNr != ((MediaEpisodeNumber)episodeNumber).season() || episodeNr != ((MediaEpisodeNumber)episodeNumber).episode()) continue;
                episodeMediaMetadata = mediaMetadata;
                break;
            }
        }
        if (episodeMediaMetadata == null && options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String string = formatter.format((Object)options.getMetadata().getReleaseDate());
                for (MediaMetadata episode3 : episodes) {
                    String airedEp;
                    if (episode3.getReleaseDate() == null || !string.equals(airedEp = formatter.format((Object)episode3.getReleaseDate()))) continue;
                    episodeMediaMetadata = episode3;
                    break;
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not parse aired date - '{}'", (Object)e.getMessage());
            }
        }
        if (episodeMediaMetadata == null) {
            throw new NothingFoundException();
        }
        String language = TmdbTvShowMetadataProvider.getRequestLanguage(options.getLanguage());
        seasonNr = episodeMediaMetadata.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED).season();
        episodeNr = episodeMediaMetadata.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED).episode();
        try {
            Response episodeResponse = this.api.tvEpisodesService().episode(showTmdbId, seasonNr, episodeNr, language, new AppendToResponse(AppendToResponseItem.EXTERNAL_IDS, AppendToResponseItem.CREDITS, AppendToResponseItem.IMAGES), Collections.singletonMap("include_image_language", "null")).execute();
            if (!episodeResponse.isSuccessful()) {
                throw new HttpException(episodeResponse.code(), episodeResponse.message());
            }
            tvEpisode = (TvEpisode)episodeResponse.body();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (tvEpisode == null) {
            throw new NothingFoundException();
        }
        md.setEpisodeNumbers(episodeMediaMetadata.getEpisodeNumbers());
        md.setId(this.getId(), tvEpisode.id);
        md.setRuntime(tvEpisode.runtime);
        this.parseExternalIDs(tvEpisode.external_ids).forEach(md::setId);
        md.setTitle(episodeMediaMetadata.getTitle());
        md.setOriginalTitle(episodeMediaMetadata.getOriginalTitle());
        md.setEnglishTitle(episodeMediaMetadata.getEnglishTitle());
        md.setPlot(episodeMediaMetadata.getPlot());
        if (MetadataUtil.unboxInteger(tvEpisode.vote_count, 0) > 0) {
            try {
                MediaRating rating = new MediaRating("tmdb");
                rating.setRating(MetadataUtil.unboxDouble(tvEpisode.vote_average));
                rating.setVotes(MetadataUtil.unboxInteger(tvEpisode.vote_count));
                rating.setMaxValue(10);
                md.addRating(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
        }
        md.setReleaseDate(tvEpisode.air_date);
        md.setCastMembers(episodeMediaMetadata.getCastMembers());
        for (CastMember castMember : ListUtils.nullSafe(tvEpisode.guest_stars)) {
            cm = new Person(Person.Type.GUEST);
            cm.setId(this.getProviderInfo().getId(), castMember.id);
            cm.setName(castMember.name);
            cm.setRole(castMember.character);
            if (castMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
            }
            if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
            }
            md.addCastMember(cm);
        }
        for (CrewMember crewMember : ListUtils.nullSafe(tvEpisode.crew)) {
            cm = new Person();
            if ("Director".equals(crewMember.job)) {
                cm.setType(Person.Type.DIRECTOR);
            } else if ("Writing".equals(crewMember.department)) {
                cm.setType(Person.Type.WRITER);
            } else {
                if (!"Production".equals(crewMember.department)) continue;
                cm.setType(Person.Type.PRODUCER);
            }
            cm.setRole(crewMember.job);
            cm.setId(this.getProviderInfo().getId(), crewMember.id);
            cm.setName(crewMember.name);
            if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                cm.setThumbUrl(this.artworkBaseUrl + "h632" + crewMember.profile_path);
            }
            if (crewMember.id != null) {
                cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
            }
            md.addCastMember(cm);
        }
        if (tvEpisode.images != null && ListUtils.isNotEmpty(tvEpisode.images.stills)) {
            for (Image image : tvEpisode.images.stills) {
                MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
                ma.setPreviewUrl(this.artworkBaseUrl + "w300" + image.file_path);
                ma.setOriginalUrl(this.artworkBaseUrl + "original" + image.file_path);
                ma.addImageSize(image.width, image.height, this.artworkBaseUrl + "original" + image.file_path, MediaArtwork.ThumbSizes.getSizeOrder(image.width));
                if (1280 < image.width) {
                    ma.addImageSize(1280, image.height * 1280 / image.width, this.artworkBaseUrl + "w1280" + image.file_path, MediaArtwork.ThumbSizes.getSizeOrder(1280));
                }
                if (300 < image.width) {
                    ma.addImageSize(300, image.height * 300 / image.width, this.artworkBaseUrl + "w300" + image.file_path, MediaArtwork.ThumbSizes.getSizeOrder(300));
                }
                md.addMediaArt(ma);
            }
        } else if (StringUtils.isNotBlank((CharSequence)tvEpisode.still_path)) {
            MediaArtwork ma = new MediaArtwork(this.getId(), MediaArtwork.MediaArtworkType.THUMB);
            ma.setPreviewUrl(this.artworkBaseUrl + "w300" + tvEpisode.still_path);
            ma.setOriginalUrl(this.artworkBaseUrl + "original" + tvEpisode.still_path);
            ma.addImageSize(0, 0, this.artworkBaseUrl + "original" + tvEpisode.still_path, 0);
            md.addMediaArt(ma);
        }
        return md;
    }

    @Override
    public List<MediaRating> getRatings(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        if (mediaType == MediaType.TV_SHOW) {
            return this.getTvShowRatings(ids);
        }
        if (mediaType == MediaType.TV_EPISODE) {
            return this.getEpisodeRatings(ids);
        }
        return Collections.emptyList();
    }

    private List<MediaRating> getTvShowRatings(Map<String, Object> ids) throws ScrapeException {
        TvShow complete;
        LOGGER.debug("getRatings(): {}", ids);
        this.initAPI();
        int tmdbId = MediaIdUtil.getIdAsInt(ids, "tmdb");
        String imdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(imdbId)) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0 && MediaIdUtil.getIdAsInt(ids, "tvdb") > 0) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, MediaIdUtil.getIdAsInt(ids, "tvdb"));
            }
            catch (Exception e) {
                LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        try {
            Response httpResponse = this.api.tvService().tv(tmdbId, "en", null).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            complete = (TvShow)httpResponse.body();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get meta data: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (complete == null) {
            throw new NothingFoundException();
        }
        if (complete.vote_average != null && complete.vote_count != null) {
            try {
                MediaRating rating = new MediaRating("tmdb");
                rating.setRating(complete.vote_average);
                rating.setVotes(complete.vote_count);
                rating.setMaxValue(10);
                return Collections.singletonList(rating);
            }
            catch (Exception e) {
                LOGGER.trace("could not parse rating/vote count: {}", (Object)e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    private List<MediaRating> getEpisodeRatings(Map<String, Object> ids) throws ScrapeException {
        BaseTvEpisode baseTvEpisode;
        LOGGER.debug("getRatings(): {}", ids);
        HashMap<String, Object> showIds = new HashMap<String, Object>();
        int showTmdbId = 0;
        int episodeTmdbId = MediaIdUtil.getIdAsIntOrDefault(ids, "tmdb", 0);
        try {
            showIds.putAll((Map)ids.get("tvShowIds"));
        }
        catch (Exception e) {
            LOGGER.debug("could not get TV show ids - '{}'", (Object)e.getMessage());
        }
        int seasonNr = MediaIdUtil.getIdAsIntOrDefault(ids, "seasonNr", -1);
        int episodeNr = MediaIdUtil.getIdAsIntOrDefault(ids, "episodeNr", -1);
        if ((seasonNr == -1 || episodeNr == -1) && MediaIdUtil.isValidImdbId(MediaIdUtil.getIdAsString(ids, "imdb"))) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByImdbId(MediaIdUtil.getIdAsString(ids, "imdb"));
                if (baseTvEpisode != null) {
                    showTmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by imdb id - {}", (Object)e.getMessage());
            }
        }
        if ((seasonNr == -1 || episodeNr == -1) && MediaIdUtil.getIdAsInt(ids, "tvdb") > 0) {
            try {
                baseTvEpisode = this.getBaseTvEpisodeByTvdbId(MediaIdUtil.getIdAsInt(ids, "tvdb"));
                if (baseTvEpisode != null) {
                    showTmdbId = MetadataUtil.unboxInteger(baseTvEpisode.show_id);
                    seasonNr = MetadataUtil.unboxInteger(baseTvEpisode.season_number, -1);
                    episodeNr = MetadataUtil.unboxInteger(baseTvEpisode.episode_number, -1);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Could not get episode number by tvdb id - {}", (Object)e.getMessage());
            }
        }
        if (showTmdbId == 0 && ids.get("tvShowIds") instanceof Map) {
            showTmdbId = MediaIdUtil.getIdAsInt(showIds, "tmdb");
            if (showTmdbId == 0 && MediaIdUtil.isValidImdbId(MediaIdUtil.getIdAsString(showIds, "imdb"))) {
                try {
                    showTmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, MediaIdUtil.getIdAsString(showIds, "imdb"));
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via imdb id - {}", (Object)e.getMessage());
                }
            }
            if (showTmdbId == 0 && MediaIdUtil.getIdAsInt(showIds, "tvdb") > 0) {
                try {
                    showTmdbId = TmdbUtils.getTmdbIdFromTvdbId(this.api, MediaIdUtil.getIdAsInt(showIds, "tvdb"));
                }
                catch (Exception e) {
                    LOGGER.debug("could not get tmdb id via tvdb id - {}", (Object)e.getMessage());
                }
            }
        }
        if (showTmdbId == 0) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        MediaMetadata episodeFromListing = null;
        TvShowSearchAndScrapeOptions options = new TvShowSearchAndScrapeOptions();
        options.setIds(showIds);
        List<MediaMetadata> episodes = this.getEpisodeList(options);
        if (episodeTmdbId > 0) {
            for (MediaMetadata episode : episodes) {
                if (episodeTmdbId != episode.getIdAsIntOrDefault("tmdb", 0)) continue;
                episodeFromListing = episode;
                break;
            }
        }
        if (episodeFromListing == null) {
            for (MediaMetadata episode : episodes) {
                MediaEpisodeNumber episodeNumber = episode.getEpisodeNumber(MediaEpisodeGroup.EpisodeGroupType.AIRED);
                if (episodeNumber == null || seasonNr != episodeNumber.season() || episodeNr != episodeNumber.episode()) continue;
                episodeFromListing = episode;
                break;
            }
        }
        if (episodeFromListing == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(episodeFromListing.getRatings());
    }

    @Override
    public Map<String, Object> getMediaIds(Map<String, Object> ids, MediaType mediaType) throws ScrapeException {
        TvShow tvShow;
        if (mediaType != MediaType.TV_SHOW) {
            return Collections.emptyMap();
        }
        LOGGER.debug("getMediaIds(): {}", ids);
        this.initAPI();
        int tmdbId = MediaIdUtil.getIdAsInt(ids, "tmdb");
        String imdbId = MediaIdUtil.getIdAsString(ids, "imdb");
        if (tmdbId == 0 && !MediaIdUtil.isValidImdbId(imdbId)) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        HashMap<String, Object> scrapedIds = new HashMap<String, Object>();
        if (tmdbId == 0 && MediaIdUtil.isValidImdbId(imdbId)) {
            try {
                tmdbId = TmdbUtils.getTmdbIdFromImdbId(this.api, MediaType.TV_SHOW, imdbId);
            }
            catch (Exception e) {
                LOGGER.debug("problem getting tmdbId from imdbId: {}", (Object)e.getMessage());
            }
        }
        if (tmdbId == 0) {
            LOGGER.debug("not possible to scrape from TMDB - no tmdbId/imdbId found");
            throw new MissingIdException("tmdb", "imdb");
        }
        try {
            Response httpResponse = this.api.tvService().tv(tmdbId, "en", new AppendToResponse(AppendToResponseItem.EXTERNAL_IDS)).execute();
            if (!httpResponse.isSuccessful()) {
                throw new HttpException(httpResponse.code(), httpResponse.message());
            }
            tvShow = (TvShow)httpResponse.body();
        }
        catch (Exception e) {
            LOGGER.debug("problem getting data from tmdb: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (tvShow == null) {
            throw new NothingFoundException();
        }
        scrapedIds.put("tmdb", tvShow.id);
        this.parseExternalIDs(tvShow.external_ids).forEach(scrapedIds::put);
        return scrapedIds;
    }

    private BaseTvEpisode getBaseTvEpisodeByImdbId(String imdbId) throws IOException {
        FindResults findResults = (FindResults)this.api.findService().find(imdbId, ExternalSource.IMDB_ID, null).execute().body();
        if (findResults != null && ListUtils.isNotEmpty(findResults.tv_episode_results)) {
            return findResults.tv_episode_results.get(0);
        }
        return null;
    }

    private BaseTvEpisode getBaseTvEpisodeByTvdbId(int tvdbId) throws IOException {
        FindResults findResults = (FindResults)this.api.findService().find(tvdbId, ExternalSource.TVDB_ID, null).execute().body();
        if (findResults != null && ListUtils.isNotEmpty(findResults.tv_episode_results)) {
            return findResults.tv_episode_results.get(0);
        }
        return null;
    }

    private void injectTranslations(Locale language, TvShow show) {
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback"))) {
            Locale fallbackLanguage = Locale.forLanguageTag(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage"));
            String[] val = this.getValuesFromTranslation(show.translations, language);
            if (StringUtils.isBlank((CharSequence)val[0]) && language.getLanguage().equals(show.original_language)) {
                val[0] = show.original_name;
            }
            String[] temp = this.getValuesFromTranslation(show.translations, fallbackLanguage);
            if (StringUtils.isBlank((CharSequence)val[0])) {
                val[0] = temp[0];
            }
            if (StringUtils.isBlank((CharSequence)val[1])) {
                val[1] = temp[1];
            }
            if (StringUtils.isNotBlank((CharSequence)val[0])) {
                show.name = val[0];
            }
            if (StringUtils.isNotBlank((CharSequence)val[1])) {
                show.overview = val[1];
            }
        }
    }

    private void injectTranslations(Locale language, TvShow tvShow, TvSeason tvSeason, Translations translations) {
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback"))) {
            Locale fallbackLanguage = Locale.forLanguageTag(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage"));
            String[] val = this.getValuesFromTranslation(translations, language);
            if (StringUtils.isBlank((CharSequence)val[0]) && language.getLanguage().equals(tvShow.original_language)) {
                val[0] = tvSeason.name;
            }
            String[] temp = this.getValuesFromTranslation(translations, fallbackLanguage);
            if (StringUtils.isBlank((CharSequence)val[0])) {
                val[0] = temp[0];
            }
            if (StringUtils.isBlank((CharSequence)val[1])) {
                val[1] = temp[1];
            }
            if (StringUtils.isNotBlank((CharSequence)val[0])) {
                tvSeason.name = val[0];
            }
            if (StringUtils.isNotBlank((CharSequence)val[1])) {
                tvSeason.overview = val[1];
            }
        }
    }

    private void injectTranslations(Locale language, BaseTvShow show) throws IOException {
        if (Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("titleFallback"))) {
            Locale fallbackLanguage = Locale.forLanguageTag(this.getProviderInfo().getConfig().getValue("titleFallbackLanguage"));
            if (show.name.equals(show.original_name) && !show.original_language.equals(language.getLanguage()) && !language.equals(fallbackLanguage)) {
                LOGGER.debug("checking for title fallback {}", (Object)fallbackLanguage);
                String lang = this.getProviderInfo().getConfig().getValue("titleFallbackLanguage").replace("_", "-");
                Response httpResponse = this.api.tvService().tv(show.id, lang, new AppendToResponse(AppendToResponseItem.TRANSLATIONS)).execute();
                if (!httpResponse.isSuccessful()) {
                    throw new HttpException(httpResponse.code(), httpResponse.message());
                }
                TvShow s = (TvShow)httpResponse.body();
                String[] val = this.getValuesFromTranslation(s.translations, language);
                String[] temp = this.getValuesFromTranslation(s.translations, fallbackLanguage);
                if (StringUtils.isBlank((CharSequence)val[0])) {
                    val[0] = temp[0];
                }
                if (StringUtils.isBlank((CharSequence)val[1])) {
                    val[1] = temp[1];
                }
                if (StringUtils.isNotBlank((CharSequence)val[0])) {
                    show.name = val[0];
                }
                if (StringUtils.isNotBlank((CharSequence)val[1])) {
                    show.overview = val[1];
                }
            }
        }
    }

    private MediaMetadata morphTvEpisodeToMediaMetadata(BaseTvEpisode episode, TvSeason tvSeason, Map<MediaEpisodeGroup, List<TvEpisodeGroupSeason>> episodeGroups, MediaSearchAndScrapeOptions options) {
        MediaMetadata ep = new MediaMetadata(this.getId());
        ep.setScrapeOptions(options);
        ep.setId(this.getProviderInfo().getId(), episode.id);
        ep.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, episode.season_number, episode.episode_number);
        ep.addEpisodeGroup(MediaEpisodeGroup.DEFAULT_AIRED);
        ep.setTitle(episode.name);
        ep.setPlot(episode.overview);
        if (episodeGroups != null) {
            block0: for (Map.Entry<MediaEpisodeGroup, List<TvEpisodeGroupSeason>> entry : episodeGroups.entrySet()) {
                boolean found = false;
                for (TvEpisodeGroupSeason episodeGroup : entry.getValue()) {
                    for (TvEpisodeGroupEpisode episodeInGroup : ListUtils.nullSafe(episodeGroup.episodes)) {
                        if (!Objects.equals(episode.id, episodeInGroup.id)) continue;
                        ep.setEpisodeNumber(entry.getKey(), episodeGroup.order, episodeInGroup.order + 1);
                        ep.addEpisodeGroup(entry.getKey());
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block0;
                }
            }
        }
        if (episode.vote_average != null && MetadataUtil.unboxInteger(episode.vote_count, 0) > 0) {
            MediaRating rating = new MediaRating(this.getProviderInfo().getId());
            rating.setRating(episode.vote_average);
            rating.setVotes(episode.vote_count);
            rating.setMaxValue(10);
            ep.addRating(rating);
        }
        ep.setReleaseDate(episode.air_date);
        if (tvSeason != null && tvSeason.credits != null) {
            for (CastMember castMember : ListUtils.nullSafe(tvSeason.credits.cast)) {
                Person cm = new Person(Person.Type.ACTOR);
                cm.setId(this.getProviderInfo().getId(), castMember.id);
                cm.setName(castMember.name);
                cm.setRole(castMember.character);
                if (castMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + castMember.id);
                }
                if (StringUtils.isNotBlank((CharSequence)castMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + castMember.profile_path);
                }
                ep.addCastMember(cm);
            }
            for (CrewMember crewMember : ListUtils.nullSafe(tvSeason.credits.crew)) {
                Person cm = new Person();
                if ("Director".equals(crewMember.job)) {
                    cm.setType(Person.Type.DIRECTOR);
                } else if ("Writing".equals(crewMember.department)) {
                    cm.setType(Person.Type.WRITER);
                } else {
                    if (!"Production".equals(crewMember.department)) continue;
                    cm.setType(Person.Type.PRODUCER);
                }
                cm.setRole(crewMember.job);
                cm.setId(this.getProviderInfo().getId(), crewMember.id);
                cm.setName(crewMember.name);
                if (StringUtils.isNotBlank((CharSequence)crewMember.profile_path)) {
                    cm.setThumbUrl(this.artworkBaseUrl + "h632" + crewMember.profile_path);
                }
                if (crewMember.id != null) {
                    cm.setProfileUrl("https://www.themoviedb.org/person/" + crewMember.id);
                }
                ep.addCastMember(cm);
            }
        }
        return ep;
    }

    private MediaSearchResult morphTvShowToSearchResult(BaseTvShow tvShow, TvShowSearchAndScrapeOptions query) {
        MediaSearchResult result = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
        result.setId(Integer.toString(tvShow.id));
        result.setTitle(tvShow.name);
        result.setOriginalTitle(tvShow.original_name);
        result.setOverview(tvShow.overview);
        if (tvShow.poster_path != null && !tvShow.poster_path.isEmpty()) {
            result.setPosterUrl(this.artworkBaseUrl + "w342" + tvShow.poster_path);
        }
        if (tvShow.first_air_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(tvShow.first_air_date);
            result.setYear(calendar.get(1));
        }
        if (StringUtils.isNotBlank((CharSequence)query.getImdbId()) && query.getImdbId().equals(result.getIMDBId()) || String.valueOf(query.getTmdbId()).equals(result.getId())) {
            LOGGER.debug("perfect match by ID - set score to 1");
            result.setScore(1.0f);
        } else {
            result.calculateScore(query);
        }
        return result;
    }

    private MediaEpisodeGroup.EpisodeGroupType mapEpisodeGroup(int type) {
        return switch (type) {
            case 1 -> MediaEpisodeGroup.EpisodeGroupType.ALTERNATE;
            case 2 -> MediaEpisodeGroup.EpisodeGroupType.ABSOLUTE;
            case 3 -> MediaEpisodeGroup.EpisodeGroupType.DVD;
            case 4, 5, 6, 7 -> MediaEpisodeGroup.EpisodeGroupType.ALTERNATE;
            default -> null;
        };
    }
}

