/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.tvshows.TvShowSelectionModel;
import org.tinymediamanager.ui.tvshows.TvShowUIModule;

public class TvShowTitleToEntityMatcher
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowTitleToEntityMatcher.class);

    public TvShowTitleToEntityMatcher() {
        this.putValue("Name", TmmResourceBundle.getString("tvshowepisode.titlematching"));
        this.putValue("ShortDescription", TmmResourceBundle.getString("tvshowepisode.titlematching.desc"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        TvShowSelectionModel.SelectedObjects sel = TvShowUIModule.getInstance().getSelectionModel().getSelectedObjects(false, false);
        if (sel.getEpisodes().isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getInstance(), TmmResourceBundle.getString("tmm.nothingselected"));
            return;
        }
        for (TvShowEpisode ep : sel.getEpisodes()) {
            if (ep.isDummy()) {
                LOGGER.debug("Cannot operate on dummy episode '{}'", (Object)ep.getTitle());
                continue;
            }
            List<TvShowEpisode> eps = ep.getTvShow().getDummyEpisodes().stream().filter(dummy -> dummy.getTitle().equalsIgnoreCase(ep.getTitle())).toList();
            if (eps.isEmpty() && ep.getFirstAired() != null) {
                eps = ep.getTvShow().getDummyEpisodes().stream().filter(dummy -> dummy.getFirstAired() != null && dummy.getFirstAired().equals(ep.getFirstAired())).toList();
            }
            if (eps.isEmpty()) {
                LOGGER.warn("Did not find an episode named '{}' in TV show '{}'", (Object)ep.getTitle(), (Object)ep.getTvShow().getTitle());
                continue;
            }
            if (eps.size() == 1) {
                TvShowEpisode wanted = eps.get(0);
                List<TvShowEpisode> assigned = ep.getTvShow().getEpisode(wanted.getSeason(), wanted.getEpisode());
                if (assigned.isEmpty()) {
                    ep.merge(wanted);
                    ep.saveToDb();
                    ep.writeNFO();
                    ep.firePropertyChange("episode", null, ep);
                    LOGGER.info("Episode '{}' has been matched to S{} E{}", new Object[]{ep.getTitle(), ep.getSeason(), ep.getEpisode()});
                    continue;
                }
                LOGGER.info("Episode '{}' is already assigned - skipping", (Object)ep.getTitle());
                continue;
            }
            LOGGER.warn("Found multiple episodes named '{}' in TV show '{}' - skipping", (Object)ep.getTitle(), (Object)ep.getTvShow().getTitle());
        }
    }
}

