/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.util.NanoClock;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.function.LongSupplier;

final class Timer {
    private final LongSupplier _nanoClock;
    private long _start;
    private long _stop;

    private Timer(LongSupplier nanoClock) {
        this._nanoClock = Objects.requireNonNull(nanoClock);
    }

    public Timer start() {
        this._start = this._nanoClock.getAsLong();
        return this;
    }

    public Timer stop() {
        this._stop = this._nanoClock.getAsLong();
        return this;
    }

    public Duration getTime() {
        return Duration.ofNanos(this._stop - this._start);
    }

    public static Timer of(Clock clock) {
        Objects.requireNonNull(clock);
        return clock instanceof NanoClock ? new Timer(System::nanoTime) : new Timer(() -> Timer.nanos(clock));
    }

    private static long nanos(Clock clock) {
        Instant now = clock.instant();
        return now.getEpochSecond() * 1000000000L + (long)now.getNano();
    }

    public static Timer of() {
        return new Timer(System::nanoTime);
    }
}

