/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.AbstractGraphIterator;

public class RandomWalkIterator<V, E>
extends AbstractGraphIterator<V, E> {
    private V currentVertex;
    private final Graph<V, E> graph;
    private final boolean isWeighted;
    private boolean sinkReached;
    private long maxSteps;
    private Random random;

    public RandomWalkIterator(Graph<V, E> graph) {
        this(graph, null);
    }

    public RandomWalkIterator(Graph<V, E> graph, V startVertex) {
        this(graph, startVertex, true);
    }

    public RandomWalkIterator(Graph<V, E> graph, V startVertex, boolean isWeighted) {
        this(graph, startVertex, isWeighted, Long.MAX_VALUE);
    }

    public RandomWalkIterator(Graph<V, E> graph, V startVertex, boolean isWeighted, long maxSteps) {
        if (graph == null) {
            throw new IllegalArgumentException("graph must not be null");
        }
        this.setCrossComponentTraversal(false);
        this.graph = graph;
        this.isWeighted = isWeighted;
        this.maxSteps = maxSteps;
        this.specifics = RandomWalkIterator.createGraphSpecifics(graph);
        if (startVertex == null) {
            if (graph.vertexSet().size() > 0) {
                this.currentVertex = graph.vertexSet().iterator().next();
            }
        } else if (graph.containsVertex(startVertex)) {
            this.currentVertex = startVertex;
        } else {
            throw new IllegalArgumentException("graph must contain the start vertex");
        }
        this.sinkReached = false;
        this.random = new Random();
    }

    protected boolean isExhausted() {
        return this.maxSteps == 0L;
    }

    protected void encounterVertex(V vertex, E edge) {
        --this.maxSteps;
    }

    @Override
    public boolean hasNext() {
        return this.currentVertex != null && !this.isExhausted() && !this.sinkReached;
    }

    @Override
    public V next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Set potentialEdges = this.specifics.edgesOf(this.currentVertex);
        Object nextEdge = this.drawEdge(potentialEdges);
        if (nextEdge != null) {
            V nextVertex = Graphs.getOppositeVertex(this.graph, nextEdge, this.currentVertex);
            this.encounterVertex(nextVertex, nextEdge);
            this.fireEdgeTraversed(this.createEdgeTraversalEvent(nextEdge));
            this.fireVertexTraversed(this.createVertexTraversalEvent(nextVertex));
            this.currentVertex = nextVertex;
            return nextVertex;
        }
        this.sinkReached = true;
        return this.currentVertex;
    }

    private E drawEdge(Set<? extends E> edges) {
        int drawn;
        if (edges.isEmpty()) {
            return null;
        }
        ArrayList<E> list = new ArrayList<E>(edges);
        if (this.isWeighted) {
            Iterator safeIter = list.iterator();
            double border = this.random.nextDouble() * this.getTotalWeight(list);
            double d = 0.0;
            drawn = -1;
            do {
                ++drawn;
            } while ((d += this.graph.getEdgeWeight(safeIter.next())) < border);
        } else {
            drawn = this.random.nextInt(list.size());
        }
        return list.get(drawn);
    }

    private EdgeTraversalEvent<E> createEdgeTraversalEvent(E edge) {
        if (this.isReuseEvents()) {
            this.reusableEdgeEvent.setEdge(edge);
            return this.reusableEdgeEvent;
        }
        return new EdgeTraversalEvent<E>(this, edge);
    }

    private VertexTraversalEvent<V> createVertexTraversalEvent(V vertex) {
        if (this.isReuseEvents()) {
            this.reusableVertexEvent.setVertex(vertex);
            return this.reusableVertexEvent;
        }
        return new VertexTraversalEvent<V>(this, vertex);
    }

    private double getTotalWeight(Collection<E> edges) {
        double total = 0.0;
        for (E e : edges) {
            total += this.graph.getEdgeWeight(e);
        }
        return total;
    }
}

