/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.device;

import com.ubnt.ace.class;
import com.ubnt.data.Admin;
import com.ubnt.data.Device;
import com.ubnt.data.Site;
import com.ubnt.data.X;
import com.ubnt.model.OO0O.G;
import com.ubnt.model.api.device.DeviceBleSettingsUpdateDto;
import com.ubnt.model.api.device.DeviceListDto;
import com.ubnt.model.api.device.UnifiDeviceDetailsDto;
import com.ubnt.net.security.role.A;
import com.ubnt.net.security.role.D;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.net.v2.config.security.annotation.AllowUCoreLocal;
import com.ubnt.service.device.I;
import com.ubnt.service.device.Q;
import com.ubnt.service.device.float;
import com.ubnt.service.device.ooOO.oOOO;
import com.ubnt.service.devmgr.OoOo0;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@V2RestController
@Tag(name="Devices")
public class DeviceController {
    private final float String;
    private final Q \u00d600000;
    private final A \u00d200000;
    private final OoOo0 \u00d800000;
    private final I \u00d300000;
    private final com.ubnt.service.devmgr.device.E.A \u00d500000;
    private final com.ubnt.net.security.G o00000;

    @GetMapping(value={"/api/site/{siteName}/device"})
    @Operation(summary="List devices from all UniFi controllers", description="\"separateUnmanaged\" query param available since 7.1.46")
    public DeviceListDto listDevices(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="siteName") Site site, @RequestParam(value="separateUnmanaged", defaultValue="false") boolean bl, @RequestParam(value="includeTrafficUsage", defaultValue="false") boolean bl2) {
        String string = site.getId();
        D d2 = this.\u00d200000.\u00d300000(httpServletRequest, httpServletResponse, string);
        return this.\u00d300000.String(this.String.O\u00f60000(string, d2, bl2), bl);
    }

    @PutMapping(value={"/api/site/{siteName}/device/{mac}/ble"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Update device BLE settings")
    public void updateBleSettings(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string, @RequestBody DeviceBleSettingsUpdateDto deviceBleSettingsUpdateDto) {
        deviceBleSettingsUpdateDto.useBleSetupConfiguration().ifPresent(bl -> this.o00000(string, site, (Boolean)bl));
    }

    @PostMapping(value={"/api/site/{siteName}/device/{mac}/gateway/adopt-as-secondary"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @Operation(summary="Adopt gateway device as secondary one")
    public void adoptSecondaryGateway(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string) {
        Optional<X> optional = this.o00000.o00000(httpServletRequest, httpServletResponse);
        Admin admin = this.Object(optional);
        String string2 = optional.flatMap(x2 -> x2.getOptionalString("name")).orElse("");
        this.\u00d500000.super(site, string, admin, string2);
    }

    @GetMapping(value={"/api/site/{siteName}/device/{mac}/wireless-links"})
    public G getDeviceWirelessLinks(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string) {
        return G.new(this.\u00d600000.void(site.getId(), string));
    }

    @GetMapping(value={"/api/site/{siteName}/device/wireless-links"})
    public List<G> getSiteDevicesWirelessLinks(@PathVariable(value="siteName") Site site) {
        return class.oO0000(this.\u00d600000.Object(site.getId()), G::new);
    }

    @AllowUCoreLocal
    @GetMapping(value={"/api/devices/{deviceMac}/details"})
    @Operation(summary="Get details for a Unifi device")
    public UnifiDeviceDetailsDto getUnifiDeviceDetails(@PathVariable(value="deviceMac") String string) {
        return this.String.o\u00d60000(string).orElseThrow(oOOO::new);
    }

    private Admin Object(Optional<X> optional) {
        return optional.map(x2 -> x2.getX("admin")).filter(Admin.class::isInstance).map(Admin.class::cast).orElse(new Admin());
    }

    private void o00000(String string, Site site, Boolean bl) {
        this.\u00d800000.\u00f6\u00d2oO00(site.getId(), string).ifPresent(device -> {
            this.\u00d800000.\u00f4\u00d3OO00((Device)device, "use_ble_setup_configuration", bl);
            this.\u00d800000.O\u00d6OO00((Device)device);
        });
    }

    @ConstructorProperties(value={"deviceService", "deviceWirelessLinkService", "roleManager", "deviceManager", "deviceListDtoFormatter", "gatewayRedundancyAdoptionService", "loginInfoService"})
    @Generated
    public DeviceController(float float_, Q q2, A a2, OoOo0 ooOo0, I i2, com.ubnt.service.devmgr.device.E.A a3, com.ubnt.net.security.G g2) {
        this.String = float_;
        this.\u00d600000 = q2;
        this.\u00d200000 = a2;
        this.\u00d800000 = ooOo0;
        this.\u00d300000 = i2;
        this.\u00d500000 = a3;
        this.o00000 = g2;
    }
}

