/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.apps;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.verapdf.ReleaseDetails;
import org.verapdf.apps.Applications;
import org.verapdf.apps.SoftwareUpdater;
import org.verapdf.version.SemanticVersionNumber;
import org.verapdf.version.Versions;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SoftwareUpdaterImpl
implements SoftwareUpdater {
    private static final Logger logger = Logger.getLogger(SoftwareUpdaterImpl.class.getCanonicalName());
    private static final String latestGF = "https://search.maven.org/solrsearch/select?q=g:org.verapdf.apps+AND+a:greenfield-apps&core=gav&rows=1&wt=xml";
    private static final String latestPDFBox = "https://search.maven.org/solrsearch/select?q=g:org.verapdf.apps+AND+a:pdfbox-apps&core=gav&rows=1&wt=xml";
    private final String currentVersion = Applications.getAppDetails().getVersion();

    SoftwareUpdaterImpl() {
    }

    @Override
    public boolean isOnline() {
        String stringURL = SoftwareUpdaterImpl.getEndpointForVersion(this.currentVersion);
        try {
            URL url = new URL(stringURL);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            huc.setRequestMethod("GET");
            huc.connect();
            if (huc.getResponseCode() == 200) {
                url.openStream();
                return true;
            }
        }
        catch (MalformedURLException excep) {
            throw new IllegalStateException(String.format("Problem parsing hard coded URL %s", stringURL), excep);
        }
        catch (IOException excep) {
            logger.log(Level.INFO, "Couldn't get latest version info from Jenkins.", excep);
        }
        return false;
    }

    @Override
    public SemanticVersionNumber getLatestAppsVersion() {
        return SoftwareUpdaterImpl.getLatestVersionFromUrl(latestGF);
    }

    @Override
    public SemanticVersionNumber getLatestPdfBoxAppsVersion() {
        return SoftwareUpdaterImpl.getLatestVersionFromUrl(latestPDFBox);
    }

    @Override
    public boolean isUpdateAvailable() {
        return this.isUpdateAvailable(Applications.getAppDetails());
    }

    @Override
    public boolean isUpdateAvailable(String versionString) {
        String endpoint;
        SemanticVersionNumber available;
        if (!this.isOnline()) {
            return false;
        }
        SemanticVersionNumber current = Versions.fromString(versionString);
        return current.compareTo(available = SoftwareUpdaterImpl.getLatestVersionFromUrl(endpoint = SoftwareUpdaterImpl.getEndpointForVersion(versionString))) < 0;
    }

    @Override
    public boolean isUpdateAvailable(ReleaseDetails details) {
        return this.isUpdateAvailable(details.getVersion());
    }

    @Override
    public String getLatestVersion(String versionString) {
        if (!this.isOnline()) {
            return versionString;
        }
        String endpoint = SoftwareUpdaterImpl.getEndpointForVersion(versionString);
        SemanticVersionNumber available = SoftwareUpdaterImpl.getLatestVersionFromUrl(endpoint);
        return available.getVersionString();
    }

    @Override
    public String getLatestVersion(ReleaseDetails details) {
        return this.getLatestVersion(details.getVersion());
    }

    private static SemanticVersionNumber getLatestVersionFromUrl(String endpoint) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            builder.setErrorHandler(null);
            URL url = new URL(endpoint);
            Document doc = builder.parse(new InputSource(url.openStream()));
            XPath path = XPathFactory.newInstance().newXPath();
            NodeList versions = (NodeList)path.evaluate("//str[@name='v']", doc, XPathConstants.NODESET);
            return Versions.fromString(versions.item(0).getFirstChild().getNodeValue());
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException excep) {
            excep.printStackTrace();
            throw new IllegalStateException(String.format("Problem parsing version number from URL %s", endpoint), excep);
        }
    }

    private static String getEndpointForVersion(String versionString) {
        return versionString.endsWith("PDFBOX") ? latestPDFBox : latestGF;
    }
}

