/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.blaze3d.framegraph.FrameGraphBuilder;
import com.mojang.blaze3d.framegraph.FramePass;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LevelTargetBundle;
import net.minecraft.client.renderer.state.LevelRenderState;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class FramePassManager {
    private static final List<PassInfo> addedPasses = new ArrayList<PassInfo>();

    protected static void addPass(ResourceLocation name, PassDefinition pass) {
        if (!addedPasses.stream().noneMatch(info -> info.name.equals(name.toString()))) {
            throw new IllegalArgumentException("Cannot create a frame pass with a duplicate name: " + String.valueOf(name));
        }
        addedPasses.add(new PassInfo(name.toString(), pass));
    }

    @ApiStatus.Internal
    public static void insertForgePasses(FrameGraphBuilder graphBuilder, LevelTargetBundle bundle, LevelRenderState state) {
        for (PassInfo info : addedPasses) {
            FramePass pass = graphBuilder.addPass(info.name);
            PassDefinition forgePass = info.pass;
            forgePass.extracts(bundle, pass);
            pass.executes(() -> forgePass.executes(state));
        }
    }

    private record PassInfo(String name, PassDefinition pass) {
    }

    public static interface PassDefinition {
        default public void extracts(LevelTargetBundle bundle, FramePass pass) {
            this.targets(bundle, pass);
        }

        @Deprecated(forRemoval=true, since="1.21.10")
        default public void targets(LevelTargetBundle bundle, FramePass pass) {
        }

        default public void executes(LevelRenderState state) {
            this.executes();
        }

        @Deprecated(forRemoval=true, since="1.21.10")
        default public void executes() {
        }
    }
}

