/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.forge.transformers;

import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.coremod.api.ASMAPI;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;

record FieldToMethodTransformer(String className, Map<String, String> fields) implements ITransformer<ClassNode>
{
    static final Map<String, Map<String, String>> TARGETS = Map.of("net.minecraft.world.level.biome.Biome", Map.of("climateSettings", "getModifiedClimateSettings", "specialEffects", "getModifiedSpecialEffects"), "net.minecraft.world.effect.MobEffectInstance", Map.of("effect", "getEffect"), "net.minecraft.world.level.block.LiquidBlock", Map.of("fluid", "getFluid"), "net.minecraft.world.item.BucketItem", Map.of("content", "getFluid"), "net.minecraft.world.level.block.FlowerPotBlock", Map.of("potted", "getPotted"));

    static List<ITransformer> getAll() {
        ArrayList<ITransformer> ret = new ArrayList<ITransformer>(TARGETS.size());
        for (Map.Entry<String, Map<String, String>> entry : TARGETS.entrySet()) {
            ret.add(new FieldToMethodTransformer(entry.getKey(), entry.getValue()));
        }
        return ret;
    }

    @NotNull
    public ClassNode transform(ClassNode input, ITransformerVotingContext context) {
        for (Map.Entry<String, String> entry : this.fields.entrySet()) {
            ASMAPI.redirectFieldToMethod((ClassNode)input, (String)entry.getKey(), (String)entry.getValue());
        }
        return input;
    }

    @NotNull
    public TransformerVoteResult castVote(ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    @NotNull
    public Set<ITransformer.Target> targets() {
        return Set.of(ITransformer.Target.targetClass((String)this.className));
    }
}

