/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jwt;

import java.io.FileReader;
import java.io.Reader;
import java.security.PrivateKey;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a8\u0006\u0007"}, d2={"parseKeyFile", "Ljava/security/PrivateKey;", "keyFilePath", "", "withMinimum", "Ljava/time/Duration;", "min", "jicoco-jwt"})
public final class JwtInfoKt {
    private static final PrivateKey parseKeyFile(String keyFilePath) {
        PEMParser parser = new PEMParser((Reader)new FileReader(keyFilePath));
        Object object = parser.readObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bouncycastle.openssl.PEMKeyPair");
        PEMKeyPair pemKeyPair = (PEMKeyPair)object;
        boolean bl = false;
        PrivateKey privateKey = new JcaPEMKeyConverter().getKeyPair(pemKeyPair).getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"let(...)");
        return privateKey;
    }

    private static final Duration withMinimum(Duration $this$withMinimum, Duration min) {
        return (Duration)ComparisonsKt.maxOf((Comparable)$this$withMinimum, (Comparable)min);
    }

    public static final /* synthetic */ PrivateKey access$parseKeyFile(String keyFilePath) {
        return JwtInfoKt.parseKeyFile(keyFilePath);
    }

    public static final /* synthetic */ Duration access$withMinimum(Duration $receiver, Duration min) {
        return JwtInfoKt.withMinimum($receiver, min);
    }
}

