/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class CacheMap<K, T> {
    protected long timeToLive;
    protected Map<K, CacheObject> cachedObjects;
    protected ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public CacheMap(long timeToLive, long cleanupInterval) {
        this.timeToLive = timeToLive;
        this.cachedObjects = new HashMap<K, CacheObject>();
        if (timeToLive > 0L && cleanupInterval > 0L) {
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    CacheMap.this.cleanup();
                }
            }, cleanupInterval * 1000L, cleanupInterval * 1000L);
        }
    }

    public void put(K key, T value) {
        this.readWriteLock.writeLock().lock();
        this.cachedObjects.put(key, new CacheObject(value));
        this.readWriteLock.writeLock().unlock();
    }

    public T get(K key) {
        this.readWriteLock.readLock().lock();
        CacheObject c = this.cachedObjects.get(key);
        this.readWriteLock.readLock().unlock();
        if (c == null) {
            return null;
        }
        c.lastAccessed = System.currentTimeMillis();
        return c.value;
    }

    public Set<K> keySet() {
        return this.cachedObjects.keySet();
    }

    public void remove(K key) {
        this.readWriteLock.writeLock().lock();
        this.cachedObjects.remove(key);
        this.readWriteLock.writeLock().unlock();
    }

    public int size() {
        this.readWriteLock.readLock().lock();
        int size = this.cachedObjects.size();
        this.readWriteLock.readLock().unlock();
        return size;
    }

    public void cleanup() {
        this.cleanup(false);
    }

    public void cleanup(boolean force) {
        long now = System.currentTimeMillis();
        this.readWriteLock.writeLock().lock();
        this.cachedObjects.entrySet().removeIf(entry -> now > this.timeToLive * 1000L + ((CacheObject)entry.getValue()).lastAccessed || force);
        this.readWriteLock.writeLock().unlock();
    }

    protected class CacheObject {
        public long lastAccessed = System.currentTimeMillis();
        public T value;

        protected CacheObject(T value) {
            this.value = value;
        }
    }
}

