/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public class RegexInputPanel
extends AbstractModalInputPanel {
    private String regularExpression;
    private final JTextField tfExpression;
    private final JLabel lblInvalidExpression;

    public RegexInputPanel() {
        this.setLayout((LayoutManager)new MigLayout("", "[300lp,grow]", "[][][]"));
        JLabel lblDescription = new JLabel(TmmResourceBundle.getString("tmm.regexp"));
        this.add((Component)lblDescription, "cell 0 0");
        this.tfExpression = new JTextField();
        this.add((Component)this.tfExpression, "cell 0 1,growx");
        this.tfExpression.setColumns(10);
        this.lblInvalidExpression = new JLabel(TmmResourceBundle.getString("tmm.regexp.invalid"));
        this.add((Component)this.lblInvalidExpression, "cell 0 2");
        this.lblInvalidExpression.setVisible(false);
        this.btnClose.setEnabled(false);
        this.tfExpression.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                this.checkExpression();
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                this.checkExpression();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                this.checkExpression();
            }

            private void checkExpression() {
                String text = RegexInputPanel.this.tfExpression.getText();
                if (StringUtils.isBlank((CharSequence)text)) {
                    RegexInputPanel.this.lblInvalidExpression.setVisible(false);
                    RegexInputPanel.this.btnClose.setEnabled(false);
                } else {
                    try {
                        Pattern.compile(text);
                        RegexInputPanel.this.lblInvalidExpression.setVisible(false);
                        RegexInputPanel.this.btnClose.setEnabled(true);
                    }
                    catch (Exception e) {
                        RegexInputPanel.this.lblInvalidExpression.setVisible(true);
                        RegexInputPanel.this.btnClose.setEnabled(false);
                    }
                }
            }
        });
        SwingUtilities.invokeLater(this.tfExpression::requestFocus);
    }

    @Override
    protected void onClose() {
        this.regularExpression = this.tfExpression.getText();
        this.setVisible(false);
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }
}

