/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf;

import com.github.stephenc.javaisotools.loopfs.udf.UDFFileEntry;
import com.github.stephenc.javaisotools.loopfs.udf.UDFFileSystem;
import java.io.IOException;
import java.io.InputStream;

public class UDFEntryInputStream
extends InputStream {
    private UDFFileEntry entry;
    private UDFFileSystem fs;
    private long pos;
    private long rem;

    public UDFEntryInputStream(UDFFileEntry uDFFileEntry, UDFFileSystem uDFFileSystem) {
        this.fs = uDFFileSystem;
        this.entry = uDFFileEntry;
        this.pos = 0L;
        this.rem = this.entry.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        this.ensureOpen();
        if (this.rem <= 0L) {
            return -1;
        }
        if (n2 <= 0) {
            return 0;
        }
        int n4 = n2;
        if ((long)n4 > this.rem) {
            n4 = (int)this.rem;
        }
        UDFFileSystem uDFFileSystem = this.fs;
        synchronized (uDFFileSystem) {
            if (this.fs.isClosed()) {
                throw new IOException("ISO file closed.");
            }
            n3 = this.fs.readFileContent(this.entry, this.pos, byArray, n, n4);
        }
        if (n3 > 0) {
            this.pos += (long)n3;
            this.rem -= (long)n3;
        }
        return n3;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) == 1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public long skip(long l) {
        this.ensureOpen();
        int n = l > this.rem ? (int)this.rem : (int)l;
        this.pos += (long)n;
        this.rem -= (long)n;
        if (this.rem <= 0L) {
            this.close();
        }
        return n;
    }

    @Override
    public int available() {
        return Math.max((int)this.rem, 0);
    }

    public long size() {
        this.ensureOpen();
        return this.entry.getSize();
    }

    @Override
    public void close() {
        this.rem = 0L;
        this.entry = null;
        this.fs = null;
    }

    private void ensureOpen() {
        if (null == this.entry) {
            throw new IllegalStateException("stream has been closed");
        }
    }
}

