/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.awt.Color;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class TmmUILogAppender
extends AppenderBase<ILoggingEvent> {
    private static final int MAX_LOG_SIZE = 100;
    private final Deque<LogEntry> logBuffer = new LinkedList<LogEntry>();
    private final List<Level> levels;
    private TmmLogTextPane textPane;

    public TmmUILogAppender(Level level) {
        this(List.of(level));
    }

    public TmmUILogAppender(List<Level> levels) {
        this.levels = new ArrayList<Level>(levels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextPane(TmmLogTextPane textPane) {
        this.textPane = textPane;
        if (this.textPane != null) {
            Deque<LogEntry> deque = this.logBuffer;
            synchronized (deque) {
                this.textPane.setText("");
                for (LogEntry logEntry : this.logBuffer) {
                    this.textPane.appendFormatted(logEntry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void append(ILoggingEvent eventObject) {
        if (!eventObject.getLoggerName().startsWith("org.tinymediamanager")) {
            return;
        }
        if (!this.levels.contains(eventObject.getLevel())) {
            return;
        }
        LogEntry logEntry = new LogEntry(new SimpleDateFormat("HH:mm:ss").format(new Date(eventObject.getTimeStamp())), eventObject.getLevel().toString(), eventObject.getFormattedMessage());
        Deque<LogEntry> deque = this.logBuffer;
        synchronized (deque) {
            if (this.logBuffer.size() >= 100) {
                this.logBuffer.removeFirst();
            }
            this.logBuffer.addLast(logEntry);
        }
        if (this.textPane != null) {
            SwingUtilities.invokeLater(() -> this.textPane.appendFormatted(logEntry));
        }
    }

    public static class TmmLogTextPane
    extends JTextPane {
        private final StyledDocument doc;
        private final Style defaultStyle;
        private final Style dateStyle;
        private final Map<String, Style> levelStyles = new HashMap<String, Style>();

        public TmmLogTextPane() {
            this.doc = this.getStyledDocument();
            this.setEditable(false);
            this.defaultStyle = this.doc.addStyle("DEFAULT", null);
            StyleConstants.setForeground(this.defaultStyle, this.getForeground());
            this.dateStyle = this.doc.addStyle("DATE", null);
            StyleConstants.setFontFamily(this.dateStyle, "Courier New");
            this.levelStyles.put("INFO", this.dateStyle);
            this.levelStyles.put("WARN", this.createStyle(new Color(255, 125, 0)));
            this.levelStyles.put("ERROR", this.createStyle(Color.RED));
        }

        private Style createStyle(Color color) {
            Style style = this.doc.addStyle(color.toString(), null);
            StyleConstants.setForeground(style, color);
            StyleConstants.setBold(style, true);
            StyleConstants.setFontFamily(style, "Courier New");
            return style;
        }

        private void appendFormatted(LogEntry logEntry) {
            try {
                this.doc.insertString(this.doc.getLength(), "[" + logEntry.timestamp + "] ", this.dateStyle);
                this.doc.insertString(this.doc.getLength(), String.format("%-5s ", logEntry.level), this.levelStyles.getOrDefault(logEntry.level, this.defaultStyle));
                this.doc.insertString(this.doc.getLength(), logEntry.message + "\n", this.defaultStyle);
                this.setCaretPosition(this.doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private record LogEntry(String timestamp, String level, String message) {
    }
}

