/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.math;

import io.jenetics.internal.math.probability;
import io.jenetics.internal.util.require;
import io.jenetics.util.IntRange;
import java.util.Random;
import java.util.stream.IntStream;

public final class random {
    private random() {
        require.noInstance();
    }

    public static byte nextByte(Random random2) {
        return (byte)random.nextInt(-128, 128, random2);
    }

    public static char nextChar(Random random2) {
        char c = '\u0000';
        while (!Character.isLetterOrDigit(c = (char)random.nextInt(0, 65536, random2))) {
        }
        return c;
    }

    public static short nextShort(Random random2) {
        return (short)random.nextInt(Short.MIN_VALUE, 32768, random2);
    }

    public static int nextInt(int origin, int bound, Random random2) {
        int value;
        if (origin >= bound) {
            throw new IllegalArgumentException(String.format("origin >= bound: %d >= %d", origin, bound));
        }
        if (origin < bound) {
            int n = bound - origin;
            if (n > 0) {
                value = random2.nextInt(n) + origin;
            } else {
                int r;
                while ((r = random2.nextInt()) < origin || r >= bound) {
                }
                value = r;
            }
        } else {
            value = random2.nextInt();
        }
        return value;
    }

    public static int nextInt(IntRange range, Random random2) {
        return range.size() == 1 ? range.getMin() : random.nextInt(range.getMin(), range.getMax(), random2);
    }

    public static float nextFloat(float min, float max, Random random2) {
        if (min >= max) {
            throw new IllegalArgumentException(String.format("min >= max: %f >= %f.", Float.valueOf(min), Float.valueOf(max)));
        }
        float value = random2.nextFloat();
        if (min < max && (value = value * (max - min) + min) >= max) {
            value = Math.nextDown(value);
        }
        return value;
    }

    public static double nextDouble(double min, double max, Random random2) {
        if (min >= max) {
            throw new IllegalArgumentException(String.format("min >= max: %f >= %f.", min, max));
        }
        double value = random2.nextDouble();
        if (min < max && (value = value * (max - min) + min) >= max) {
            value = Math.nextDown(value);
        }
        return value;
    }

    public static String nextASCIIString(int length, Random random2) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)random.nextInt(32, 127, random2);
        }
        return new String(chars);
    }

    public static String nextASCIIString(Random random2) {
        return random.nextASCIIString(random.nextInt(5, 20, random2), random2);
    }

    public static float toFloat(int a) {
        return (float)(a >>> 8) / 1.6777216E7f;
    }

    public static float toFloat(long a) {
        return (float)((int)(a >>> 40)) / 1.6777216E7f;
    }

    public static double toDouble(long a) {
        return (double)((a >>> 38 << 27) + (long)((int)a >>> 5)) / 9.007199254740992E15;
    }

    public static double toDouble(int a, int b) {
        return (double)(((long)(a >>> 6) << 27) + (long)(b >>> 5)) / 9.007199254740992E15;
    }

    public static float toFloat2(int a) {
        return (float)(a >>> 9) * 1.1920929E-7f;
    }

    public static float toFloat2(long a) {
        return (float)((int)(a >>> 41)) * 1.1920929E-7f;
    }

    public static double toDouble2(long a) {
        return (double)(a & 0xFFFFFFFFFFFFFL) * 2.220446049250313E-16;
    }

    public static double toDouble2(int a, int b) {
        return (double)((long)(a >>> 6) << 26 | (long)(b >>> 6)) * 2.220446049250313E-16;
    }

    public static IntStream indexes(Random random2, int start, int end, double p) {
        require.probability(p);
        int P = probability.toInt(p);
        return random.equals(p, 0.0, 1.0E-20) ? IntStream.empty() : (random.equals(p, 1.0, 1.0E-20) ? IntStream.range(start, end) : IntStream.range(start, end).filter(i -> random2.nextInt() < P));
    }

    private static boolean equals(double a, double b, double delta) {
        return Math.abs(a - b) <= delta;
    }

    public static IntStream indexes(Random random2, int n, double p) {
        return random.indexes(random2, 0, n, p);
    }

    public static byte[] seedBytes(int length) {
        return random.seed(new byte[length]);
    }

    public static byte[] seed(byte[] seed) {
        int i = 0;
        int len = seed.length;
        while (i < len) {
            int n = Math.min(len - i, 8);
            long x = random.seed();
            while (n-- > 0) {
                seed[i++] = (byte)x;
                x >>= 8;
            }
        }
        return seed;
    }

    public static long seed() {
        return random.seed(System.nanoTime());
    }

    public static long seed(long base2) {
        return random.mix(base2, random.objectHashSeed());
    }

    private static long mix(long a, long b) {
        long c = a ^ b;
        c ^= c << 17;
        c ^= c >>> 31;
        c ^= c << 8;
        return c;
    }

    private static long objectHashSeed() {
        return (long)new Object().hashCode() << 32 | (long)new Object().hashCode();
    }
}

