/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.grammar;

import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Iterator;
import lombok.Generated;
import lombok.NonNull;
import org.vinniks.parsla.grammar.Option;
import org.vinniks.parsla.grammar.serialization.ExtendedGrammarReader;
import org.vinniks.parsla.grammar.serialization.StandardGrammarReader;
import org.vinniks.parsla.grammar.serialization.StandardGrammarWriter;
import org.vinniks.parsla.util.Validations;

public final class Grammar {
    private final Iterable<Option> options;

    public static Grammar readStandard(Reader source) throws IOException {
        return StandardGrammarReader.instance().read(source);
    }

    public static Grammar readStandard(String source) {
        return StandardGrammarReader.instance().read(source);
    }

    public static Grammar readExtended(Reader source) throws IOException {
        return ExtendedGrammarReader.instance().read(source);
    }

    public static Grammar readExtended(String source) {
        return ExtendedGrammarReader.instance().read(source);
    }

    public Grammar(@NonNull Iterable<Option> options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        Validations.requireNonNullElements(options, "grammar option can not be null");
        this.options = options;
    }

    public String toString() {
        String string;
        try (StringWriter writer = new StringWriter();){
            StandardGrammarWriter.instance().write(this, writer);
            string = writer.toString();
        }
        return string;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Grammar) {
            Grammar otherGrammar = (Grammar)other;
            Iterator<Option> optionIterator = this.options.iterator();
            Iterator<Option> otherOptionIterator = otherGrammar.options.iterator();
            while (optionIterator.hasNext() && otherOptionIterator.hasNext()) {
                if (optionIterator.next().equals(otherOptionIterator.next())) continue;
                return false;
            }
            return !optionIterator.hasNext() && !otherOptionIterator.hasNext();
        }
        return false;
    }

    @Generated
    public Iterable<Option> getOptions() {
        return this.options;
    }
}

