/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.moddiscovery.InvalidModFileException;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class NightConfigWrapper
implements IConfigurable {
    private final UnmodifiableConfig config;
    private IModFileInfo file;

    public NightConfigWrapper(UnmodifiableConfig config) {
        this.config = config;
    }

    private NightConfigWrapper(UnmodifiableConfig config, IModFileInfo file) {
        this.config = config;
        this.file = file;
    }

    void setFile(IModFileInfo file) {
        this.file = file;
    }

    public <T> Optional<T> getConfigElement(String key) {
        List<String> path = List.of(key);
        return Optional.ofNullable(this.validate(this.config.get(path), path));
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        List<String> path = Arrays.asList(key);
        return Optional.ofNullable(this.validate(this.config.get(path), path));
    }

    private <T> T validate(@Nullable T value, List<String> path) {
        ArrayList al;
        if (value instanceof UnmodifiableConfig) {
            UnmodifiableConfig cfg = (UnmodifiableConfig)value;
            Set entries = cfg.entrySet();
            ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)entries.size());
            for (UnmodifiableConfig.Entry e : entries) {
                builder.put((Object)e.getKey(), e.getValue());
            }
            return (T)builder.build();
        }
        if (value instanceof ArrayList && !(al = (ArrayList)value).isEmpty() && al.getFirst() instanceof UnmodifiableConfig) {
            throw new InvalidModFileException("The configuration path " + String.valueOf(path) + " is invalid. I wasn't expecting a multi-object list - remove one of the [[ ]]", this.file);
        }
        return value;
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        List<String> path = Arrays.asList(key);
        if (this.config.contains(path) && !(this.config.get(path) instanceof Collection)) {
            throw new InvalidModFileException("The configuration path " + String.valueOf(path) + " is invalid. Expecting a collection!", this.file);
        }
        Collection nestedConfigs = (Collection)this.config.getOrElse(path, ArrayList::new);
        return nestedConfigs.stream().map(conf -> new NightConfigWrapper((UnmodifiableConfig)conf, this.file)).collect(Collectors.toList());
    }
}

