/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import java.nio.file.Path;
import java.util.List;
import net.minecraftforge.fml.loading.targets.CommonDevLaunchHandler;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
abstract sealed class ForgeDevLaunchHandler
extends CommonDevLaunchHandler {
    private ForgeDevLaunchHandler(CommonLaunchHandler.LaunchType type) {
        super(type, "forge_dev_");
    }

    private ForgeDevLaunchHandler(String name) {
        super(name);
    }

    @Override
    public List<Path> getMinecraftPaths() {
        Path extra = ForgeDevLaunchHandler.getPathFromResource("assets/.mcassetsroot");
        Path minecraft = ForgeDevLaunchHandler.getPathFromResource("net/minecraft/client/Minecraft.class");
        Path forge = ForgeDevLaunchHandler.getPathFromResource("net/minecraftforge/common/MinecraftForge.class");
        if (!forge.equals(minecraft)) {
            return List.of(minecraft, extra);
        }
        Path filtered = CommonDevLaunchHandler.getMinecraftOnly(extra, minecraft);
        return List.of(filtered);
    }

    public static final class Custom
    extends ForgeDevLaunchHandler {
        public Custom() {
            super("forge_dev");
        }
    }

    public static final class ServerGameTest
    extends ForgeDevLaunchHandler {
        public ServerGameTest() {
            super(SERVER_GAMETEST);
        }
    }

    public static final class Server
    extends ForgeDevLaunchHandler {
        public Server() {
            super(SERVER);
        }
    }

    public static final class Data
    extends ForgeDevLaunchHandler {
        public Data() {
            super(DATA);
        }
    }

    public static final class ClientData
    extends ForgeDevLaunchHandler {
        public ClientData() {
            super(CLIENT_DATA);
        }
    }

    public static final class Client
    extends ForgeDevLaunchHandler {
        public Client() {
            super(CLIENT);
        }
    }
}

