/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.ModelContext;

@OnlyIn(value=Dist.CLIENT)
public interface ResolvedModel
extends ModelDebugName {
    public static final boolean DEFAULT_AMBIENT_OCCLUSION = true;
    public static final UnbakedModel.GuiLight DEFAULT_GUI_LIGHT = UnbakedModel.GuiLight.SIDE;

    public UnbakedModel wrapped();

    @Nullable
    public ResolvedModel parent();

    public static TextureSlots findTopTextureSlots(ResolvedModel p_393648_) {
        TextureSlots.Resolver textureslots$resolver = new TextureSlots.Resolver();
        for (ResolvedModel resolvedmodel = p_393648_; resolvedmodel != null; resolvedmodel = resolvedmodel.parent()) {
            textureslots$resolver.addLast(resolvedmodel.wrapped().textureSlots());
        }
        return textureslots$resolver.resolve((ModelDebugName)p_393648_);
    }

    default public TextureSlots getTopTextureSlots() {
        return ResolvedModel.findTopTextureSlots(this);
    }

    public static boolean findTopAmbientOcclusion(ResolvedModel p_393409_) {
        while (p_393409_ != null) {
            Boolean obool = p_393409_.wrapped().ambientOcclusion();
            if (obool != null) {
                return obool;
            }
            p_393409_ = p_393409_.parent();
        }
        return true;
    }

    default public boolean getTopAmbientOcclusion() {
        return ResolvedModel.findTopAmbientOcclusion(this);
    }

    public static UnbakedModel.GuiLight findTopGuiLight(ResolvedModel p_392767_) {
        while (p_392767_ != null) {
            UnbakedModel.GuiLight unbakedmodel$guilight = p_392767_.wrapped().guiLight();
            if (unbakedmodel$guilight != null) {
                return unbakedmodel$guilight;
            }
            p_392767_ = p_392767_.parent();
        }
        return DEFAULT_GUI_LIGHT;
    }

    default public UnbakedModel.GuiLight getTopGuiLight() {
        return ResolvedModel.findTopGuiLight(this);
    }

    public static UnbakedGeometry findTopGeometry(ResolvedModel p_395357_) {
        while (p_395357_ != null) {
            UnbakedGeometry unbakedgeometry = p_395357_.wrapped().geometry();
            if (unbakedgeometry != null) {
                return unbakedgeometry;
            }
            p_395357_ = p_395357_.parent();
        }
        return UnbakedGeometry.EMPTY;
    }

    default public UnbakedGeometry getTopGeometry() {
        return ResolvedModel.findTopGeometry(this);
    }

    default public QuadCollection bakeTopGeometry(TextureSlots p_396041_, ModelBaker p_395367_, ModelState p_396505_) {
        return this.getTopGeometry().bake(p_396041_, p_395367_, p_396505_, this, this.getContext());
    }

    public static TextureAtlasSprite resolveParticleSprite(TextureSlots p_391346_, ModelBaker p_396500_, ModelDebugName p_393309_) {
        return p_396500_.sprites().resolveSlot(p_391346_, "particle", p_393309_);
    }

    default public TextureAtlasSprite resolveParticleSprite(TextureSlots p_397861_, ModelBaker p_395675_) {
        return ResolvedModel.resolveParticleSprite(p_397861_, p_395675_, this);
    }

    public static ItemTransform findTopTransform(ResolvedModel p_393869_, ItemDisplayContext p_396067_) {
        while (p_393869_ != null) {
            ItemTransform itemtransform;
            ItemTransforms itemtransforms = p_393869_.wrapped().transforms();
            if (itemtransforms != null && (itemtransform = itemtransforms.getTransform(p_396067_)) != ItemTransform.NO_TRANSFORM) {
                return itemtransform;
            }
            p_393869_ = p_393869_.parent();
        }
        return ItemTransform.NO_TRANSFORM;
    }

    public static ItemTransforms findTopTransforms(ResolvedModel p_392780_) {
        ItemTransform itemtransform = ResolvedModel.findTopTransform(p_392780_, ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
        ItemTransform itemtransform1 = ResolvedModel.findTopTransform(p_392780_, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
        ItemTransform itemtransform2 = ResolvedModel.findTopTransform(p_392780_, ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
        ItemTransform itemtransform3 = ResolvedModel.findTopTransform(p_392780_, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
        ItemTransform itemtransform4 = ResolvedModel.findTopTransform(p_392780_, ItemDisplayContext.HEAD);
        ItemTransform itemtransform5 = ResolvedModel.findTopTransform(p_392780_, ItemDisplayContext.GUI);
        ItemTransform itemtransform6 = ResolvedModel.findTopTransform(p_392780_, ItemDisplayContext.GROUND);
        ItemTransform itemtransform7 = ResolvedModel.findTopTransform(p_392780_, ItemDisplayContext.FIXED);
        return new ItemTransforms(itemtransform, itemtransform1, itemtransform2, itemtransform3, itemtransform4, itemtransform5, itemtransform6, itemtransform7);
    }

    default public ItemTransforms getTopTransforms() {
        return ResolvedModel.findTopTransforms(this);
    }

    default public IGeometryBakingContext getContext() {
        return new ModelContext(this);
    }
}

