/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.tags.TagKey;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.TagConventionMappings;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class TagConventionMigrationHelper {
    private static final ArrayList<TagKey<?>> FOUND_LEGACY_TAGS = new ArrayList();

    private TagConventionMigrationHelper() {
    }

    static void init() {
        ServerStartingEvent.BUS.addListener(TagConventionMigrationHelper::onServerStarting);
    }

    public static void onServerStarting(ServerStartingEvent event) {
        boolean shouldRun;
        ForgeConfig.Common.MigrationHelperMode mode = (ForgeConfig.Common.MigrationHelperMode)((Object)ForgeConfig.COMMON.migrationHelperMode.get());
        switch (mode) {
            default: {
                throw new MatchException(null, null);
            }
            case OFF: {
                boolean bl = false;
                break;
            }
            case ONLY_IN_DEV_ENV: {
                boolean bl;
                if (!FMLLoader.isProduction()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case ALWAYS: {
                boolean bl = shouldRun = true;
            }
        }
        if (shouldRun) {
            TagConventionMigrationHelper.run(event.getServer().registryAccess());
        }
    }

    private static void run(RegistryAccess.Frozen registryAccess) {
        registryAccess.registries().forEach(registryEntry -> {
            if (registryEntry.key().location().getNamespace().equals("minecraft")) {
                FOUND_LEGACY_TAGS.addAll(registryEntry.value().getTags().map(HolderSet.Named::key).filter(TagConventionMappings.MAPPINGS::containsKey).toList());
            }
        });
        if (FOUND_LEGACY_TAGS.isEmpty()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder("~~~~~~~~ Tag migration helper ~~~~~~~~\nWarning for mod devs: Found known legacy tags that have direct common convention equivalents - consider migrating these to improve compatibility with other mods.\nNote: This feature isn't fully comprehensive - see Forge's net.minecraftforge.common.Tags class for a full list of tags.\nYou can disable this message by setting \"migrationHelperMode\" to \"OFF\" in Forge's common config.\n\nHere are some suggestions for replacements:".stripIndent());
        for (TagKey<?> legacyTag : FOUND_LEGACY_TAGS) {
            String replacement = TagConventionMappings.MAPPINGS.get(legacyTag);
            stringBuilder.append("\n- ").append(legacyTag).append(" -> ").append(replacement);
        }
        stringBuilder.append("\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~");
        LogManager.getLogger().warn((CharSequence)stringBuilder);
        FOUND_LEGACY_TAGS.clear();
        FOUND_LEGACY_TAGS.trimToSize();
    }
}

