/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.block.model;

import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;

@OnlyIn(value=Dist.CLIENT)
public class SingleVariant
implements BlockStateModel {
    private final BlockModelPart model;
    private final Collection<ChunkSectionLayer> layer;
    private final Collection<ChunkSectionLayer> layerFast;

    public SingleVariant(BlockModelPart p_394592_) {
        this.model = p_394592_;
        this.layer = this.model.layer() == null ? null : EnumSet.of(this.model.layer());
        this.layerFast = this.model.layerFast() == null ? null : EnumSet.of(this.model.layerFast());
    }

    @Override
    public void collectParts(RandomSource p_397567_, List<BlockModelPart> p_396765_) {
        p_396765_.add(this.model);
    }

    @Override
    public TextureAtlasSprite particleIcon() {
        return this.model.particleIcon();
    }

    public Collection<ChunkSectionLayer> getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        Collection<Object> type = ItemBlockRenderTypes.isFancy() ? this.layer : this.layerFast;
        return type != null ? type : BlockStateModel.super.getRenderTypes(state, rand, data);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(Variant variant) implements BlockStateModel.Unbaked
    {
        public static final Codec<Unbaked> CODEC = Variant.CODEC.xmap(Unbaked::new, Unbaked::variant);

        @Override
        public BlockStateModel bake(ModelBaker p_397283_) {
            return new SingleVariant(this.variant.bake(p_397283_));
        }

        public void resolveDependencies(ResolvableModel.Resolver p_395676_) {
            this.variant.resolveDependencies(p_395676_);
        }
    }
}

