/*
 * Decompiled with CFR 0.152.
 */
package com.uwetrottmann.trakt5;

import com.google.gson.Gson;
import com.uwetrottmann.trakt5.TraktV2Authenticator;
import com.uwetrottmann.trakt5.TraktV2Helper;
import com.uwetrottmann.trakt5.TraktV2Interceptor;
import com.uwetrottmann.trakt5.entities.AccessToken;
import com.uwetrottmann.trakt5.entities.AccessTokenRefreshRequest;
import com.uwetrottmann.trakt5.entities.AccessTokenRequest;
import com.uwetrottmann.trakt5.entities.CheckinError;
import com.uwetrottmann.trakt5.entities.ClientId;
import com.uwetrottmann.trakt5.entities.DeviceCode;
import com.uwetrottmann.trakt5.entities.DeviceCodeAccessTokenRequest;
import com.uwetrottmann.trakt5.entities.TraktError;
import com.uwetrottmann.trakt5.entities.TraktOAuthError;
import com.uwetrottmann.trakt5.services.Authentication;
import com.uwetrottmann.trakt5.services.Calendars;
import com.uwetrottmann.trakt5.services.Checkin;
import com.uwetrottmann.trakt5.services.Comments;
import com.uwetrottmann.trakt5.services.Episodes;
import com.uwetrottmann.trakt5.services.Genres;
import com.uwetrottmann.trakt5.services.Movies;
import com.uwetrottmann.trakt5.services.People;
import com.uwetrottmann.trakt5.services.Recommendations;
import com.uwetrottmann.trakt5.services.Scrobble;
import com.uwetrottmann.trakt5.services.Search;
import com.uwetrottmann.trakt5.services.Seasons;
import com.uwetrottmann.trakt5.services.Shows;
import com.uwetrottmann.trakt5.services.Sync;
import com.uwetrottmann.trakt5.services.Users;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import javax.annotation.Nullable;
import okhttp3.Authenticator;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class TraktV2 {
    public static final String API_HOST = "api.trakt.tv";
    public static final String API_STAGING_HOST = "api-staging.trakt.tv";
    public static final String API_URL = "https://api.trakt.tv/";
    public static final String API_STAGING_URL = "https://api-staging.trakt.tv/";
    public static final String API_VERSION = "2";
    public static final String SITE_URL = "https://trakt.tv";
    public static final String OAUTH2_AUTHORIZATION_URL = "https://trakt.tv/oauth/authorize";
    public static final String HEADER_AUTHORIZATION = "Authorization";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String HEADER_TRAKT_API_VERSION = "trakt-api-version";
    public static final String HEADER_TRAKT_API_KEY = "trakt-api-key";
    @Nullable
    private OkHttpClient okHttpClient;
    @Nullable
    private Retrofit retrofit;
    private String apiKey;
    @Nullable
    private String clientSecret;
    @Nullable
    private String redirectUri;
    @Nullable
    private String accessToken;
    @Nullable
    private String refreshToken;
    private final HttpUrl apiBaseUrl;

    public TraktV2(String apiKey) {
        this(apiKey, false);
    }

    public TraktV2(String apiKey, String clientSecret, String redirectUri) {
        this(apiKey, clientSecret, redirectUri, false);
    }

    public TraktV2(String apiKey, boolean staging) {
        this.apiKey = apiKey;
        this.apiBaseUrl = HttpUrl.get((String)(staging ? API_STAGING_URL : API_URL));
    }

    public TraktV2(String apiKey, String clientSecret, String redirectUri, boolean staging) {
        this(apiKey, staging);
        this.clientSecret = clientSecret;
        this.redirectUri = redirectUri;
    }

    public String apiHost() {
        return this.apiBaseUrl.host();
    }

    public String apiKey() {
        return this.apiKey;
    }

    public TraktV2 apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Nullable
    public String accessToken() {
        return this.accessToken;
    }

    public TraktV2 accessToken(@Nullable String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    public String refreshToken() {
        return this.refreshToken;
    }

    public TraktV2 refreshToken(@Nullable String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    protected Retrofit.Builder retrofitBuilder() {
        return new Retrofit.Builder().baseUrl(this.apiBaseUrl).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)TraktV2Helper.getGsonBuilder().create())).client(this.okHttpClient());
    }

    protected synchronized OkHttpClient okHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            this.setOkHttpClientDefaults(builder);
            this.okHttpClient = builder.build();
        }
        return this.okHttpClient;
    }

    protected void setOkHttpClientDefaults(OkHttpClient.Builder builder) {
        builder.addInterceptor((Interceptor)new TraktV2Interceptor(this));
        builder.authenticator((Authenticator)new TraktV2Authenticator(this));
    }

    protected Retrofit retrofit() {
        if (this.retrofit == null) {
            this.retrofit = this.retrofitBuilder().build();
        }
        return this.retrofit;
    }

    public String buildAuthorizationUrl(String state) {
        if (this.redirectUri == null) {
            throw new IllegalStateException("redirectUri not provided");
        }
        StringBuilder authUrl = new StringBuilder(OAUTH2_AUTHORIZATION_URL);
        authUrl.append("?").append("response_type=code");
        authUrl.append("&").append("redirect_uri=").append(this.urlEncode(this.redirectUri));
        authUrl.append("&").append("state=").append(this.urlEncode(state));
        authUrl.append("&").append("client_id=").append(this.urlEncode(this.apiKey()));
        return authUrl.toString();
    }

    private String urlEncode(String content) {
        try {
            return URLEncoder.encode(content, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public Response<DeviceCode> generateDeviceCode() throws IOException {
        ClientId clientId = new ClientId();
        clientId.client_id = this.apiKey;
        return this.authentication().generateDeviceCode(clientId).execute();
    }

    public Response<AccessToken> exchangeDeviceCodeForAccessToken(String deviceCode) throws IOException {
        if (this.clientSecret == null) {
            throw new IllegalStateException("clientSecret not provided");
        }
        DeviceCodeAccessTokenRequest request = new DeviceCodeAccessTokenRequest();
        request.client_id = this.apiKey;
        request.client_secret = this.clientSecret;
        request.code = deviceCode;
        return this.authentication().exchangeDeviceCodeForAccessToken(request).execute();
    }

    public Response<AccessToken> exchangeCodeForAccessToken(String authCode) throws IOException {
        if (this.clientSecret == null) {
            throw new IllegalStateException("clientSecret not provided");
        }
        if (this.redirectUri == null) {
            throw new IllegalStateException("redirectUri not provided");
        }
        return this.authentication().exchangeCodeForAccessToken(new AccessTokenRequest(authCode, this.apiKey(), this.clientSecret, this.redirectUri)).execute();
    }

    public Response<AccessToken> refreshAccessToken(String refreshToken) throws IOException {
        if (this.clientSecret == null) {
            throw new IllegalStateException("clientSecret not provided");
        }
        if (this.redirectUri == null) {
            throw new IllegalStateException("redirectUri not provided");
        }
        return this.authentication().refreshAccessToken(new AccessTokenRefreshRequest(refreshToken, this.apiKey(), this.clientSecret, this.redirectUri)).execute();
    }

    @Nullable
    public CheckinError checkForCheckinError(Response<?> response) {
        if (response.code() != 409) {
            return null;
        }
        Converter errorConverter = this.retrofit().responseBodyConverter(CheckinError.class, new Annotation[0]);
        try {
            return (CheckinError)errorConverter.convert((Object)response.errorBody());
        }
        catch (IOException e) {
            return new CheckinError();
        }
    }

    @Nullable
    public TraktError checkForTraktError(Response<?> response) {
        if (response.isSuccessful()) {
            return null;
        }
        Converter errorConverter = this.retrofit().responseBodyConverter(TraktError.class, new Annotation[0]);
        try {
            return (TraktError)errorConverter.convert((Object)response.errorBody());
        }
        catch (IOException ignored) {
            return new TraktError();
        }
    }

    @Nullable
    public TraktOAuthError checkForTraktOAuthError(Response<?> response) {
        if (response.isSuccessful()) {
            return null;
        }
        Converter errorConverter = this.retrofit().responseBodyConverter(TraktOAuthError.class, new Annotation[0]);
        if (response.errorBody() != null) {
            try {
                return (TraktOAuthError)errorConverter.convert((Object)response.errorBody());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new TraktOAuthError();
    }

    public Authentication authentication() {
        return (Authentication)this.retrofit().create(Authentication.class);
    }

    public Calendars calendars() {
        return (Calendars)this.retrofit().create(Calendars.class);
    }

    public Checkin checkin() {
        return (Checkin)this.retrofit().create(Checkin.class);
    }

    public Comments comments() {
        return (Comments)this.retrofit().create(Comments.class);
    }

    public Genres genres() {
        return (Genres)this.retrofit().create(Genres.class);
    }

    public Movies movies() {
        return (Movies)this.retrofit().create(Movies.class);
    }

    public People people() {
        return (People)this.retrofit().create(People.class);
    }

    public Recommendations recommendations() {
        return (Recommendations)this.retrofit().create(Recommendations.class);
    }

    public Search search() {
        return (Search)this.retrofit().create(Search.class);
    }

    public Shows shows() {
        return (Shows)this.retrofit().create(Shows.class);
    }

    public Seasons seasons() {
        return (Seasons)this.retrofit().create(Seasons.class);
    }

    public Episodes episodes() {
        return (Episodes)this.retrofit().create(Episodes.class);
    }

    public Sync sync() {
        return (Sync)this.retrofit().create(Sync.class);
    }

    public Scrobble scrobble() {
        return (Scrobble)this.retrofit().create(Scrobble.class);
    }

    public Users users() {
        return (Users)this.retrofit().create(Users.class);
    }
}

