/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.call;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.AbstractModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.PlaylistModel;

public final class Playlist {

    public static class Swap
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Swap";

        public Swap(Integer n, Integer n2, Integer n3) {
            this.addParameter("playlistid", n);
            this.addParameter("position1", n2);
            this.addParameter("position2", n3);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.asText();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Remove
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Remove";

        public Remove(Integer n, Integer n2) {
            this.addParameter("playlistid", n);
            this.addParameter("position", n2);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.asText();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Insert
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Insert";

        public Insert(Integer n, Integer n2, PlaylistModel.Item item) {
            this.addParameter("playlistid", n);
            this.addParameter("position", n2);
            this.addParameter("item", (AbstractModel)item);
        }

        public Insert(Integer n, Integer n2, PlaylistModel.Item ... itemArray) {
            this.addParameter("playlistid", n);
            this.addParameter("position", n2);
            this.addParameter("item", itemArray);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.asText();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetProperties
    extends AbstractCall<PlaylistModel.PropertyValue> {
        public static final String API_TYPE = "Playlist.GetProperties";

        public GetProperties(Integer n, String ... stringArray) {
            this.addParameter("playlistid", n);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected PlaylistModel.PropertyValue parseOne(JsonNode jsonNode) {
            return new PlaylistModel.PropertyValue(jsonNode);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class GetPlaylists
    extends AbstractCall<GetPlaylistsResult> {
        public static final String API_TYPE = "Playlist.GetPlaylists";

        @Override
        protected ArrayList<GetPlaylistsResult> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            if (arrayNode != null) {
                ArrayList<GetPlaylistsResult> arrayList = new ArrayList<GetPlaylistsResult>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new GetPlaylistsResult((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<GetPlaylistsResult>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }

        public static class GetPlaylistsResult
        extends AbstractModel {
            public static final String PLAYLISTID = "playlistid";
            public static final String TYPE = "type";
            public final Integer playlistid;
            public final String type;

            public GetPlaylistsResult(Integer n, String string) {
                this.playlistid = n;
                this.type = string;
            }

            public GetPlaylistsResult(JsonNode jsonNode) {
                this.playlistid = GetPlaylistsResult.parseInt(jsonNode, PLAYLISTID);
                this.type = GetPlaylistsResult.parseString(jsonNode, TYPE);
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(PLAYLISTID, this.playlistid);
                objectNode.put(TYPE, this.type);
                return objectNode;
            }

            static List<GetPlaylistsResult> getPlaylistGetPlaylistsResultList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<GetPlaylistsResult> arrayList = new ArrayList<GetPlaylistsResult>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new GetPlaylistsResult(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<GetPlaylistsResult>(0);
            }

            public static interface Type {
                public static final String UNKNOWN = "unknown";
                public static final String VIDEO = "video";
                public static final String AUDIO = "audio";
                public static final String PICTURE = "picture";
                public static final String MIXED = "mixed";
                public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "video", "audio", "picture", "mixed"));
            }
        }
    }

    public static class GetItems
    extends AbstractCall<ListModel.AllItems> {
        public static final String API_TYPE = "Playlist.GetItems";
        public static final String RESULT = "items";

        public GetItems(Integer n, ListModel.Limits limits, ListModel.Sort sort, String ... stringArray) {
            this.addParameter("playlistid", n);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", stringArray);
        }

        public GetItems(Integer n, String ... stringArray) {
            this.addParameter("playlistid", n);
            this.addParameter("properties", stringArray);
        }

        public GetItems(Integer n, ListModel.Limits limits, String ... stringArray) {
            this.addParameter("playlistid", n);
            this.addParameter("limits", (AbstractModel)limits);
            this.addParameter("properties", stringArray);
        }

        public GetItems(Integer n, ListModel.Sort sort, String ... stringArray) {
            this.addParameter("playlistid", n);
            this.addParameter("sort", (AbstractModel)sort);
            this.addParameter("properties", stringArray);
        }

        @Override
        protected ArrayList<ListModel.AllItems> parseMany(JsonNode jsonNode) {
            ArrayNode arrayNode = this.parseResults(jsonNode, RESULT);
            if (arrayNode != null) {
                ArrayList<ListModel.AllItems> arrayList = new ArrayList<ListModel.AllItems>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode objectNode = (ObjectNode)arrayNode.get(i);
                    arrayList.add(new ListModel.AllItems((JsonNode)objectNode));
                }
                return arrayList;
            }
            return new ArrayList<ListModel.AllItems>(0);
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return true;
        }
    }

    public static class Clear
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Clear";

        public Clear(Integer n) {
            this.addParameter("playlistid", n);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.asText();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }

    public static class Add
    extends AbstractCall<String> {
        public static final String API_TYPE = "Playlist.Add";

        public Add(Integer n, PlaylistModel.Item item) {
            this.addParameter("playlistid", n);
            this.addParameter("item", (AbstractModel)item);
        }

        public Add(Integer n, PlaylistModel.Item ... itemArray) {
            this.addParameter("playlistid", n);
            this.addParameter("item", itemArray);
        }

        @Override
        protected String parseOne(JsonNode jsonNode) {
            return jsonNode.asText();
        }

        @Override
        public String getName() {
            return API_TYPE;
        }

        @Override
        protected boolean returnsList() {
            return false;
        }
    }
}

