/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.button;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class TriStateCheckBox
extends JCheckBox
implements ActionListener {
    public static final int STATE_UNSELECTED = 0;
    public static final int STATE_SELECTED = 1;
    public static final int STATE_MIXED = 2;

    public TriStateCheckBox(String text, Icon icon) {
        super(text, icon);
    }

    public TriStateCheckBox(String text) {
        this(text, null);
    }

    public TriStateCheckBox() {
        this((String)null);
    }

    @Override
    protected void init(String text, Icon icon) {
        this.model = this.createButtonModel();
        this.setModel(this.model);
        this.addActionListener(this);
        super.init(text, icon);
    }

    protected ButtonModel createButtonModel() {
        return new TriStateButtonModel();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.isMixed()) {
            this.adjustMixedIcon();
        } else {
            this.restoreMixedIcon();
        }
    }

    protected void adjustMixedIcon() {
        this.setIcon(UIManager.getIcon("TriStateCheckBox.icon"));
    }

    protected void restoreMixedIcon() {
        this.setIcon(null);
    }

    @Override
    public void setSelected(boolean b) {
        this.restoreMixedIcon();
        super.setSelected(b);
    }

    public boolean isMixed() {
        return this.getState() == 2;
    }

    public void setMixed(boolean b) {
        if (b) {
            this.setState(2);
        } else {
            this.setState(0);
        }
    }

    public int getState() {
        if (this.model instanceof TriStateButtonModel) {
            return ((TriStateButtonModel)this.model).getState();
        }
        throw new IllegalStateException("TriStateButtonModel is required for TriStateCheckBox");
    }

    public void setState(int state) {
        if (this.model instanceof TriStateButtonModel) {
            int old = ((TriStateButtonModel)this.model).getState();
            if (old != state) {
                ((TriStateButtonModel)this.model).setState(state);
            }
        } else {
            throw new IllegalStateException("TriStateButtonModel is required for TriStateCheckBox");
        }
        this.stateUpdated(state);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.stateUpdated(this.getState());
    }

    protected void stateUpdated(int state) {
        if (state == 2) {
            this.adjustMixedIcon();
        } else {
            this.restoreMixedIcon();
        }
    }

    public static class TriStateButtonModel
    extends JToggleButton.ToggleButtonModel {
        public static final int MIXED = 128;

        public void setState(int state) {
            switch (state) {
                case 0: {
                    this.setSelected(false);
                    break;
                }
                case 1: {
                    this.setSelected(true);
                    break;
                }
                case 2: {
                    this.setMixed(true);
                }
            }
        }

        public int getState() {
            if (this.isMixed()) {
                return 2;
            }
            if (this.isSelected()) {
                return 1;
            }
            return 0;
        }

        protected int getNextState(int current) {
            if (current == 0) {
                return 1;
            }
            if (current == 1) {
                return 2;
            }
            return 0;
        }

        @Override
        public void setPressed(boolean b) {
            if (this.isPressed() == b || !this.isEnabled()) {
                return;
            }
            if (!b && this.isArmed()) {
                this.updateState();
            }
            this.stateMask = b ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int modifiers = 0;
                AWTEvent currentEvent = EventQueue.getCurrentEvent();
                if (currentEvent instanceof InputEvent) {
                    modifiers = ((InputEvent)currentEvent).getModifiersEx();
                } else if (currentEvent instanceof ActionEvent) {
                    modifiers = ((ActionEvent)currentEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), modifiers));
            }
        }

        protected void updateState() {
            this.setState(this.getNextState(this.getState()));
        }

        @Override
        public void setSelected(boolean b) {
            boolean mixed = this.isMixed();
            if (mixed) {
                this.stateMask &= 0xFFFFFF7F;
                this.internalSetSelected(!this.isSelected());
            }
            super.setSelected(b);
            this.fireStateChanged();
        }

        void internalSetSelected(boolean b) {
            this.stateMask = b ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
        }

        public boolean isMixed() {
            return (this.stateMask & 0x80) != 0;
        }

        public void setMixed(boolean b) {
            if (this.isMixed() == b) {
                return;
            }
            if (b) {
                this.stateMask |= 0x80;
                this.stateMask |= 2;
            } else {
                this.stateMask &= 0xFFFFFF7F;
            }
            this.fireStateChanged();
        }
    }
}

