/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.dashboard.widgets;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.api.dashboard.WifiExperienceStatDto;
import com.ubnt.model.api.dashboard.widgets.DashboardWidget;
import com.ubnt.model.api.dashboard.widgets.DashboardWidgetDto;
import com.ubnt.model.api.dashboard.widgets.ImmutableWirelessExperienceWidgetDto;
import com.ubnt.model.api.dashboard.widgets.NoStatsReason;
import com.ubnt.return.Object;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@Object
public interface WirelessExperienceWidgetDto
extends DashboardWidgetDto {
    @Override
    default public DashboardWidget type() {
        return DashboardWidget.WIRELESS_EXPERIENCE;
    }

    @JsonProperty(value="history")
    public List<WifiExperienceStatDto> wifiStats();

    @JsonProperty(value="active-num_sta")
    public Optional<Integer> activeSiteClientCount();

    @JsonProperty(value="total-num_sta")
    public Optional<Integer> totalSiteClientCount();

    @JsonProperty(value="no_stats_reason")
    public Optional<NoStatsReason> noStatsReason();

    public static WirelessExperienceWidgetDto forSite(List<WifiExperienceStatDto> list, int n2, int n3) {
        return ImmutableWirelessExperienceWidgetDto.builder().wifiStats(list).activeSiteClientCount(n2).totalSiteClientCount(n3).build();
    }

    public static WirelessExperienceWidgetDto forAp(List<WifiExperienceStatDto> list) {
        return ImmutableWirelessExperienceWidgetDto.builder().wifiStats(list).build();
    }

    public static WirelessExperienceWidgetDto withoutStats(NoStatsReason noStatsReason) {
        return ImmutableWirelessExperienceWidgetDto.builder().wifiStats(List.of()).noStatsReason(noStatsReason).build();
    }

    public static WirelessExperienceWidgetDto withoutStats(NoStatsReason noStatsReason, int n2, int n3) {
        return ImmutableWirelessExperienceWidgetDto.builder().wifiStats(List.of()).noStatsReason(noStatsReason).activeSiteClientCount(n2).totalSiteClientCount(n3).build();
    }
}

