#!/usr/bin/perl
# edit_welcome.cgi
# Display welcome and block lists of to and from addresses

require './spam-lib.pl';
&ReadParse();
&set_config_file_in(\%in);
&can_use_check("welcome");
&ui_print_header($header_subtext, $text{'welcome_title'}, "");
$conf = &get_config();

print "$text{'welcome_desc'}<p>\n";
print &ui_form_start("save_welcome.cgi", "form-data");
print $form_hiddens;

# Start of tabs
$url = "edit_welcome.cgi?file=".&urlize($in{'file'}).
       "&title=".&urlize($in{'title'});
print &ui_tabs_start(
	[ map { [ $_, $text{'welcome_tab'.$_}, $url."&mode=$_" ] }
	      ( 'ham', 'spam', 'some', 'import' ) ],
	"mode", $in{'mode'} || "ham", 1);

# Start of ham addresses tab
print &ui_tabs_start_tab("mode", "ham");
print $text{'welcome_hamdesc'},"<p>\n";
print &ui_table_start(undef, undef, 2);

# Addresses to always welcomelist
@from = &find("welcomelist_from", $conf);
print &ui_table_row(&hlink($text{'welcome_from'}, 'welcome_from'),
	&edit_textbox("welcomelist_from",
		      [ map { @{$_->{'words'}} } @from ], 60, 10));

# Exceptions to welcomelist
@un = &find("unwelcomelist_from", $conf);
print &ui_table_row(&hlink($text{'welcome_unfrom'}, 'welcome_unfrom'),
	&edit_textbox("unwelcomelist_from",
		      [ map { @{$_->{'words'}} } @un ], 60, 5));

if ($config{'show_global'}) {
	# Global welcome and blocklists
	$gconf = &get_config($config{'global_cf'}, 1);
	@gfrom = &find("welcomelist_from", $gconf);
	print &ui_table_row($text{'welcome_gfrom'},
		&edit_textbox("gwelcomelist_from",
			      [ map { @{$_->{'words'}} } @gfrom ], 40, 5, 1));

	@gun = &find("unwelcomelist_from", $gconf);
	print &ui_table_row($text{'welcome_gunfrom'},
		&edit_textbox("gunwelcomelist_from",
			      [ map { @{$_->{'words'}} } @gun ], 40, 5));
	}

# Welcomelist by received header
@rcvd = &find("welcomelist_from_rcvd", $conf);
print &ui_table_row(&hlink($text{'welcome_rcvd2'}, 'welcome_rcvd2'),
	&edit_table("welcomelist_from_rcvd",
		[ $text{'welcome_addr'}, $text{'welcome_rcvdhost'} ],
		[ map { $_->{'words'} } @rcvd ], [ 40, 30 ], undef, 3));

print &ui_table_end();
print &ui_tabs_end_tab("mode", "ham");

# Start of spam addresses tab
print &ui_tabs_start_tab("mode", "spam");
print $text{'welcome_spamdesc'},"<p>\n";
print &ui_table_start(undef, undef, 2);

# Blocklisted addresses
@from = &find("blocklist_from", $conf);
print &ui_table_row($text{'welcome_block'},
	&edit_textbox("blocklist_from",
		      [ map { @{$_->{'words'}} } @from ], 60, 10));

# Exceptions to blocklist
@un = &find("unblocklist_from", $conf);
print &ui_table_row($text{'welcome_unblock'},
	&edit_textbox("unblocklist_from",
		      [ map { @{$_->{'words'}} } @un ], 40, 5));

if ($config{'show_global'}) {
	# Global blocklist
	@gfrom = &find("blocklist_from", $gconf);
	print &ui_table_row($text{'welcome_gblock'},
		&edit_textbox("gblocklist_from",
			      [ map { @{$_->{'words'}} } @gfrom ], 40, 5, 1));

	@gun = &find("gunblocklist_from", $gconf);
	print &ui_table_row($text{'welcome_gunblock'},
		&edit_textbox("gunblocklist_from",
			      [ map { @{$_->{'words'}} } @gun ], 40, 5, 1));
	}

print &ui_table_end();
print &ui_tabs_end_tab("mode", "spam");

print &ui_tabs_start_tab("mode", "some");
print $text{'welcome_somedesc'},"<p>\n";
print &ui_table_start(undef, undef, 2);

# Addresses to allow some spam to
push(@to, map { [ $_, 0 ] } map { @{$_->{'words'}} }
	      &find("welcomelist_to", $conf));
push(@to, map { [ $_, 1 ] } map { @{$_->{'words'}} }
	      &find("more_spam_to", $conf));
push(@to, map { [ $_, 2 ] } map { @{$_->{'words'}} }
	      &find("all_spam_to", $conf));
print &ui_table_row($text{'welcome_to'},
	&edit_table("welcomelist_to",
		    [ $text{'welcome_addr2'}, $text{'welcome_level'} ],
		    \@to, [ 40, 0 ], \&welcomelist_to_conv, 3));

print &ui_table_end();
print &ui_tabs_end_tab("mode", "some");

# Show welcomelist import form
print &ui_tabs_start_tab("mode", "import");
print "$text{'welcome_importdesc'}<p>\n";
print &ui_table_start(undef, undef, 2);

# File to import, uploaded
print &ui_table_row($text{'welcome_import'}, &ui_upload("import"));

# Sort addresses?
print &ui_table_row($text{'welcome_sort'}, &ui_yesno_radio("sort", 0));

print &ui_table_end();
print &ui_tabs_end_tab("mode", "import");

print &ui_tabs_end(1);
print &ui_form_end([ [ undef, $text{'save'} ] ]);

&ui_print_footer($redirect_url, $text{'index_return'});

# welcomelist_to_conv(col, name, size, value)
sub welcomelist_to_conv
{
if ($_[0] == 0) {
	return &default_convfunc(@_);
	}
else {
	return &ui_select($_[1], $_[3],
		[ [ 0, $text{"welcome_level0"} ],
		  [ 1, $text{"welcome_level1"} ],
		  [ 2, $text{"welcome_level2"} ] ]);
	}
}

