data:extend(
{
  {
    type = "fluid",
    name = "ammoniacal-solution",
    icon = "__space-age__/graphics/icons/fluid/ammoniacal-solution.png",
    subgroup = "fluid",
    order = "b[new-fluid]-e[aquilo]-a[ammoniacal-solution]",
    default_temperature = -50,
    max_temperature = 100,
    heat_capacity = "0.2kJ",
    base_color = {0, 0.15, 0.4},
    flow_color = {0, 0.35, 0.7},
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "ammonia",
    subgroup = "fluid",
    icon = "__space-age__/graphics/icons/fluid/ammonia.png",
    order = "b[new-fluid]-e[aquilo]-b[ammonia]",
    default_temperature = -35,
    max_temperature = -33,
    heat_capacity = "0.2kJ",
    base_color = {0, 0, 0.6},
    flow_color = {0, 0, 0.7},
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "fluorine",
    icon = "__space-age__/graphics/icons/fluid/fluorine.png",
    subgroup = "fluid",
    order = "b[new-fluid]-e[aquilo]-c[fluorine]",
    default_temperature = 25,
    heat_capacity = "0.1kJ",
    base_color = {0.0, 0.3, 0.15},
    flow_color = {0.1, 0.7, 0.4},
    gas_temperature = 15,
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "fluoroketone-cold",
    icon = "__space-age__/graphics/icons/fluid/fluoroketone-cold.png",
    subgroup = "fluid",
    order = "b[new-fluid]-e[aquilo]-e[fluoroketone-cold]",
    default_temperature = -150,
    max_temperature = 180,
    heat_capacity = "1kJ",
    base_color = {0.0, 0.3, 0.15},
    flow_color = {0.1, 0.7, 0.4},
  },
  {
    type = "fluid",
    name = "fluoroketone-hot",
    icon = "__space-age__/graphics/icons/fluid/fluoroketone-hot.png",
    subgroup = "fluid",
    order = "b[new-fluid]-e[aquilo]-d[fluoroketone-hot]",
    default_temperature = 180,
    heat_capacity = "1kJ",
    base_color = {0.3, 0.3, 0.10},
    flow_color = {0.4, 0.7, 0.35},
  },
  {
    type = "fluid",
    name = "holmium-solution",
    icon = "__space-age__/graphics/icons/fluid/holmium-solution.png",
    subgroup = "fluid",
    order = "b[new-fluid]-c[fulgora]-a[holmium-solution]",
    default_temperature = 15,
    max_temperature = 2000,
    heat_capacity = "0.01kJ",
    base_color = {0.53, 0.1, 53},
    flow_color = {0.93, 0.68, 0.73},
    auto_barrel = false,
  },
  {
    type = "fluid",
    name = "electrolyte",
    icon = "__space-age__/graphics/icons/fluid/electrolyte.png",
    subgroup = "fluid",
    order = "b[new-fluid]-c[fulgora]-b[electrolyte]",
    default_temperature = 15,
    max_temperature = 500,
    heat_capacity = "0.01kJ",
    base_color = {0.8, 0.01, 0.2},
    flow_color = {0.99, 0.01, 0.3},
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "lithium-brine",
    icon = "__space-age__/graphics/icons/fluid/lithium-brine.png",
    subgroup = "fluid",
    order = "b[new-fluid]-e[aquilo]-f[lithium-brine]",
    default_temperature = 15,
    heat_capacity = "0.1kJ",
    base_color = {0.8, 0.85, .8},
    flow_color = {0.6, 0.65, 0.6},
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "lava",
    icon = "__space-age__/graphics/icons/fluid/lava.png",
    subgroup = "fluid",
    order = "b[new-fluid]-b[vulcanus]-a[lava]",
    default_temperature = 1500,
    max_temperature = 2000,
    heat_capacity = "0.01kJ",
    base_color = {1, 0.4, 0.1},
    flow_color = {0.3, 0.1, 0},
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "molten-iron",
    icon = "__space-age__/graphics/icons/fluid/molten-iron.png",
    subgroup = "fluid",
    order = "b[new-fluid]-b[vulcanus]-a[molten-iron]",
    default_temperature = 1500,
    max_temperature = 2000,
    heat_capacity = "0.01kJ",
    base_color = {0, 0.1, 0.53},
    flow_color = {0.2, 0.68, 0.93},
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "molten-copper",
    icon = "__space-age__/graphics/icons/fluid/molten-copper.png",
    subgroup = "fluid",
    order = "b[new-fluid]-b[vulcanus]-b[molten-copper]",
    default_temperature = 1100,
    max_temperature = 2000,
    heat_capacity = "0.01kJ",
    base_color = {0.53, 0.1, 0},
    flow_color = {0.93, 0.68, 0.2},
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "thruster-fuel",
    icon = "__space-age__/graphics/icons/fluid/thruster-fuel.png",
    subgroup = "fluid",
    order = "b[new-fluid]-a[space]-a[thruster-fuel]",
    default_temperature = 25,
    fuel_value = "50kJ",
    base_color = {0.53, 0.1, 0},
    flow_color = {0.93, 0.68, 0.2},
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "thruster-oxidizer",
    icon = "__space-age__/graphics/icons/fluid/thruster-oxidizer.png",
    subgroup = "fluid",
    order = "b[new-fluid]-a[space]-b[thruster-oxidizer]",
    default_temperature = 25,
    fuel_value = "50kJ",
    base_color = {0.0, 0.1, 0.53},
    flow_color = {0.2, 0.68, 0.93},
    auto_barrel = false
  },
  {
    type = "fluid",
    name = "fusion-plasma",
    icon = "__space-age__/graphics/icons/fluid/fusion-plasma.png",
    subgroup = "fluid",
    order = "b[new-fluid]-e[aquilo]-g[fusion-plasma]",
    default_temperature = 1000000,
    max_temperature = 10000000,
    heat_capacity = "25J",
    base_color = {0.0, 0.1, 0.53},
    flow_color = {0.2, 0.68, 0.93},
    auto_barrel = false
  },
})
