/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class VillagerTradingManager {
    private static final Lazy<Map<ResourceKey<VillagerProfession>, Int2ObjectMap<VillagerTrades.ItemListing[]>>> VANILLA_TRADES = Lazy.of(VillagerTradingManager::copyVanillaTrades);
    private static final Lazy<List<Pair<VillagerTrades.ItemListing[], Integer>>> WANDERER_TRADES = Lazy.of(() -> new ArrayList(VillagerTrades.WANDERING_TRADER_TRADES));

    private static Map<ResourceKey<VillagerProfession>, Int2ObjectMap<VillagerTrades.ItemListing[]>> copyVanillaTrades() {
        HashMap<ResourceKey<VillagerProfession>, Int2ObjectMap<VillagerTrades.ItemListing[]>> ret = new HashMap<ResourceKey<VillagerProfession>, Int2ObjectMap<VillagerTrades.ItemListing[]>>();
        VillagerTrades.TRADES.forEach((key, value) -> {
            Int2ObjectOpenHashMap copy = new Int2ObjectOpenHashMap();
            for (Int2ObjectMap.Entry ent : value.int2ObjectEntrySet()) {
                copy.put(ent.getIntKey(), (Object)Arrays.copyOf((VillagerTrades.ItemListing[])ent.getValue(), ((VillagerTrades.ItemListing[])ent.getValue()).length));
            }
            ret.put((ResourceKey<VillagerProfession>)key, (Int2ObjectMap<VillagerTrades.ItemListing[]>)copy);
        });
        return ret;
    }

    static void loadTrades(ServerAboutToStartEvent e) {
        VillagerTradingManager.postWandererEvent();
        VillagerTradingManager.postVillagerEvents();
    }

    private static void postWandererEvent() {
        if (!WandererTradesEvent.BUS.hasListeners()) {
            return;
        }
        WandererTradesEvent event = (WandererTradesEvent)WandererTradesEvent.BUS.fire((Event)new WandererTradesEvent((List)WANDERER_TRADES.get()));
        VillagerTrades.WANDERING_TRADER_TRADES.clear();
        for (WandererTradesEvent.Pool pool : event.getPools()) {
            VillagerTrades.WANDERING_TRADER_TRADES.add(Pair.of((Object)((VillagerTrades.ItemListing[])pool.getEntries().toArray(VillagerTrades.ItemListing[]::new)), (Object)pool.getRolls()));
        }
    }

    private static void postVillagerEvents() {
        if (!VillagerTradesEvent.BUS.hasListeners()) {
            return;
        }
        Map vanilla = (Map)VANILLA_TRADES.get();
        for (VillagerProfession value : ForgeRegistries.VILLAGER_PROFESSIONS) {
            ResourceKey<VillagerProfession> prof = ForgeRegistries.VILLAGER_PROFESSIONS.getResourceKey(value).orElseThrow();
            Int2ObjectMap trades = (Int2ObjectMap)vanilla.getOrDefault(prof, new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap mutableTrades = new Int2ObjectOpenHashMap();
            for (int i = 1; i < 6; ++i) {
                mutableTrades.put(i, (Object)NonNullList.create());
            }
            for (Int2ObjectMap.Entry entry : trades.int2ObjectEntrySet()) {
                Arrays.stream((VillagerTrades.ItemListing[])entry.getValue()).forEach(((List)mutableTrades.get(entry.getIntKey()))::add);
            }
            VillagerTradesEvent.BUS.post((Event)new VillagerTradesEvent((Int2ObjectMap<List<VillagerTrades.ItemListing>>)mutableTrades, prof));
            Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
            for (Int2ObjectMap.Entry entry : mutableTrades.int2ObjectEntrySet()) {
                newTrades.put(entry.getIntKey(), (Object)((List)entry.getValue()).toArray(new VillagerTrades.ItemListing[0]));
            }
            VillagerTrades.TRADES.put(prof, newTrades);
        }
    }
}

