/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity;

import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.bus.EventBus;
import org.jetbrains.annotations.NotNull;

public final class ProjectileImpactEvent
extends EntityEvent {
    public static final EventBus<ProjectileImpactEvent> BUS = EventBus.create(ProjectileImpactEvent.class);
    private final HitResult ray;
    private final Projectile projectile;
    private ImpactResult result = ImpactResult.DEFAULT;

    public ProjectileImpactEvent(Projectile projectile, HitResult ray) {
        super((Entity)projectile);
        this.ray = ray;
        this.projectile = projectile;
    }

    public HitResult getRayTraceResult() {
        return this.ray;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public void setImpactResult(@NotNull ImpactResult newResult) {
        this.result = Objects.requireNonNull(newResult, "ImpactResult cannot be null");
    }

    public ImpactResult getImpactResult() {
        return this.result;
    }

    public static enum ImpactResult {
        DEFAULT,
        SKIP_ENTITY,
        STOP_AT_CURRENT,
        STOP_AT_CURRENT_NO_DAMAGE;

    }
}

