/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.internal;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.ObjIntConsumer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.versions.forge.ForgeVersion;
import net.minecraftforge.versions.mcp.MCPVersion;

public final class BrandingControl {
    private static List<String> brandings;
    private static List<String> brandingsNoMC;

    private BrandingControl() {
    }

    private static void computeBranding() {
        if (brandings == null) {
            ArrayList<CallSite> list = new ArrayList<CallSite>();
            String[] forge = ForgeVersion.getVersion().split("-", 2);
            boolean beta = "0".equals(forge[0].split("\\.")[1]);
            String name = beta ? "\u00a7eForge Beta\u00a7f " : "Forge ";
            list.add((CallSite)((Object)(name + forge[0] + " (" + ForgeI18n.parseMessage("fml.menu.loadingmods", ModList.get().size()) + ")")));
            if (forge.length > 1) {
                list.add((CallSite)((Object)("Branch " + forge[1])));
            }
            list.add((CallSite)((Object)("Minecraft " + MCPVersion.getMCVersion())));
            brandings = List.copyOf(list);
            brandingsNoMC = brandings.subList(0, brandings.size() - 1);
        }
    }

    private static List<String> getBrandings(boolean includeMC, boolean reverse) {
        BrandingControl.computeBranding();
        if (includeMC) {
            return reverse ? brandings.reversed() : brandings;
        }
        return reverse ? brandingsNoMC.reversed() : brandingsNoMC;
    }

    public static List<String> getOverCopyrightBrandings() {
        final class LazyInit {
            private static final List<String> INSTANCE = ForgeHooksClient.forgeStatusLine == null ? Collections.emptyList() : List.of(ForgeHooksClient.forgeStatusLine);

            private LazyInit() {
            }
        }
        return LazyInit.INSTANCE;
    }

    public static void forEachLine(boolean includeMC, boolean reverse, ObjIntConsumer<String> lineConsumer) {
        List<String> brandings = BrandingControl.getBrandings(includeMC, reverse);
        for (int idx = 0; idx < brandings.size(); ++idx) {
            lineConsumer.accept(brandings.get(idx), idx);
        }
    }

    public static void forEachAboveCopyrightLine(ObjIntConsumer<String> lineConsumer) {
        List<String> overCopyrightBrandings = BrandingControl.getOverCopyrightBrandings();
        for (int idx = 0; idx < overCopyrightBrandings.size(); ++idx) {
            lineConsumer.accept(overCopyrightBrandings.get(idx), idx);
        }
    }

    public static String getBranding() {
        return "forge";
    }

    public static ResourceManagerReloadListener resourceManagerReloadListener() {
        return BrandingControl::onResourceManagerReload;
    }

    private static void onResourceManagerReload(ResourceManager resourceManager) {
        brandings = null;
        brandingsNoMC = null;
    }
}

